<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemSubCategory;
use App\Enums\TransactionCode;

class ItemSubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

           try{
                $subCategories = ItemSubCategory::select('code','category_code','name','description')
                ->where('is_active','=',1)
                ->get();
                return response()->json([
                    'status'=> 200,
                    'subCategories'=> $subCategories
                ]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }


    }

    public function show($id)
    {
        try{
            $subCategory = ItemSubCategory::select('code','category_code','name','description')
            ->where('is_active','=',1)
            ->where('code',$id)
            ->first();
            return response()->json([
                'status'=> 200,
                'subCategories'=> $subCategory
            ]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    public function store(Request $request)
    {

        try{
            $itemSubCategory =TransactionCode::ITEM_SUB_CATEGORY_CODE;
            $bixz_code = ItemSubCategory::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;

            $subCategory = ItemSubCategory::create([
                'code'=>$itemSubCategory.$max_id,
                'category_code'=>$request->category_code,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Sub Category Created"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {


        try{
            $subCategory= ItemSubCategory::findOrFile($id);
            $subCategory->update([
                'category_code'=>$request->category_code,
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Sub Category updated"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }


    public function destroy($id)
    {
        try{
            $subCategory = ItemSubCategory::select('id','is_active')->findOrFail($id);
            $subCategory->update([
                'is_active'=>0
            ]);
            return response()->json(['status'=> 200, 'message'=>"Sub Category - Delete"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
