<?php

namespace App\Http\Controllers\Item_Controllers;

use Exception;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Item_Models\ItemSize;

class ItemSizeController extends Controller
{
    public function index()
    {
      //  try{
                $size = ItemSize::select('code','name','description')->where('is_active','=',1)->get();
                return response()->json(['status'=> 200, 'size'=>$size]);
        // }catch (Exception $e) {
        //     return response()->json([
        //         'status'=> 500,
        //         'message'=> $e
        //     ],500);
        // }

    }

    public function show($id)
    {
        //try{
            $size = ItemSize::select('code','name','description')->where('code',$id)->where('is_active','=',1)->first();
            return response()->json(['status'=> 200, 'size'=>$size]);
            // }catch (Exception $e) {
            //     return response()->json([
            //         'status'=> 500,
            //         'message'=> $e
            //     ],500);
            // }
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            DB::beginTransaction();

            // // Check if the name already exists in the database
            $exitingUnit = ItemSize::where('name', $request->name)->first();
            if($exitingUnit){
                return response()->json([
                    'status' => 200,
                    'UnitExiting' => true,
                    'message' => "'{$request->name}' is already exsiting!",
                ], 200);
            }

            $itemSize =TransactionCode::ITEM_SIZE_CODE;
            $bixz_code = ItemSize::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;

            $unit = ItemSize::create([
                'code'=>$itemSize.$max_id,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Unit Created"]);

        }catch (Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function update(Request $request, $id)
    {

        try{

            $unit = ItemSize::where('code',$id)->first();
            $unit ->update([
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"size Updated"]);

        }catch (Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
