<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Enums\DefaultValues;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemMaster;
use App\Models\Item_Models\ItemImage;
use App\Enums\TransactionCode;
use App\Models\Item_Models\ItemPrice;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockHistory;
use Exception;
use Illuminate\Support\Facades\DB;

class ItemMasterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // try {
            $items = ItemMaster::select('code', 'reference_code', 'barcode', 'name', 'description', 'category_code', 'sub_category_code', 'unit_code', 'brand_code', 'color_code', 'size_code', 'bin_location_code', 'wholesale_price', 'retail_price', 'dealer_price', 'least_price', 'cost_price', 'model', 'min_stock', 'max_stock', 'reorder_stock', 'expiry_notification_days', 'is_service')
            ->with([
                'itemImages' => function ($query) {
                    $query->select('code', 'item_code')->where('is_active', '=', 1);
                }
            ])
            ->where('is_active', '=', 1)
            ->get();
            return response()->json(['status' => 200, 'items' => $items]);
        // } catch (\Exception $e) {
        //     throw new Exception($e);
        // }
    }

    /**
     * show
     * Author: Suhail Jamaldeen
     * Date: 27.12.2022
     * Version: 01
     * Logic: Get the item for id
     * @param  mixed $id
     * @return void
     */
    public function show($id)
    {
        try {
            $item = ItemMaster::select(
                'code',
                'reference_code',
                'barcode',
                'name',
                'description',
                'category_code',
                'sub_category_code',
                'unit_code',
                'brand_code',
                'color_code',
                'bin_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'model',
                'min_stock',
                'max_stock',
                'reorder_stock',
                'is_service',
                'expiry_notification_days',
                'size_code'
            )
                ->with([
                    'itemCategory' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemSubCategory' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemUnit' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemBrand' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemSize' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemColor' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemBinLocation' => function ($query) {
                        $query->select('code', 'location')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemImages' => function ($query) {
                        $query->select('code', 'item_code','file_path')->where('is_active', '=', 1);
                    }
                ])
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();
            return response()->json(['status' => 200, 'item' => $item]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function showItem($key)
    {
        try {
            $items = DB::select("CALL getGroupByCostPrice(" . $key . ")");
            return response()->json
            (['status' => 200, 'item' => $items]);
        }
        catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * itemServiceSearch
     * Author: Suhail Jamaldeen
     * Date: 15.02.2023
     * Version: 01
     * Logic: Get only the services in item master
     * @param  mixed $key
     * @return void
     */
    public function itemServiceSearch($key)
    {
        try {
            $item = ItemMaster::select(
                'code',
                'reference_code',
                'barcode',
                'name',
                'description',
                'category_code',
                'sub_category_code',
                'unit_code',
                'brand_code',
                'size_code',
                'color_code',
                'bin_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'model',
                'min_stock',
                'max_stock',
                'reorder_stock',
                'expiry_notification_days'
            )

                ->where([['is_service', '=', 1]])
                ->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('description', 'like', "%$key%")
                        ->orWhere('name', 'like', "%$key%")
                        ->orWhere('barcode', 'like', "%$key%");
                })->get();

            return response()->json(['status' => 200, 'item' => $item]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function itemSearch($key)
    {
        try {
            $item = ItemMaster::select(
                'code',
                'reference_code',
                'barcode',
                'name',
                'description',
                'category_code',
                'sub_category_code',
                'unit_code',
                'brand_code',
                'size_code',
                'color_code',
                'bin_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'model',
                'min_stock',
                'max_stock',
                'reorder_stock',
                'expiry_notification_days'
            ) ->with([
                'stocks' => function ($query) {
                    $query->where('is_active', '=', 1)
                     ->where('is_freeze', '=', 0);

                }
            ])
                ->where([['is_active', '=', 1]])

                // ->where([['is_service', '=', 0]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('description', 'like', "%$key%")
                        ->orWhere('name', 'like', "%$key%")
                        ->orWhere('barcode', 'like', "%$key%");
                })->get();

            return response()->json(['status' => 200, 'item' => $item]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {

            DB::beginTransaction();


            $item_code = TransactionCode::ITEM_MASTER;
            $bixz_code = ItemMaster::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;

            $item = ItemMaster::create([
                'code' => $item_code . $max_id,
                'reference_code' => $request->referenceCode,
                'barcode' => $request->barcode ? $request->barcode : $max_id,
                'name' => $request->name,
                'description' => $request->description,
                'category_code' => $request->itemCategory != null ? $request->itemCategory['code'] : null,
                'sub_category_code' => $request->itemSubCategories != null ? $request->itemSubCategories['code'] : null,
                'unit_code' => $request->itemUnit != null ? $request->itemUnit['code'] : null,
                'brand_code' => $request->itemBrand != null ? $request->itemBrand['code'] : null,
                'size_code' => $request->itemSize != null ? $request->itemSize['code'] : null,
                'color_code' => $request->itemColor != null ? $request->itemColor['code'] : null,
                'bin_location_code' => $request->itemBinLocation != null ? $request->itemBinLocation['code'] : null,
                'wholesale_price' => $request->wholesalePrice,
                'retail_price' => $request->retailPrice,
                'dealer_price' => $request->dealerPrice,
                'least_price' => $request->leastPrice,
                'cost_price' => $request->costPrice,
                'discount_price' => $request->discountPrice,
                'discount' => $request->discount,
                'min_stock' => $request->minStock,
                'max_stock' => $request->maxStock,
                // 'size_code' => $request->size,
                'model' => $request->model,
                'is_service' => $request->type == 'service' ? 1 : 0,
                'reorder_stock' => $request->reorderStock,
                'expiry_notification_days' => $request->expiryNotificationDays,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            if ($item) {

                $stock_code = TransactionCode::STOCK;
                $max_code = Stock::max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
                Stock::create([
                    'code' => $stock_code . $max_id,
                    'item_code' => $item->code,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'remaining_quantity' => 0,
                    'wholesale_price' => $item->wholesale_price ?? 0,
                    'retail_price' => $item->retail_price ?? 0,
                    'dealer_price' => $item->dealer_price ?? 0,
                    'least_price' => $item->least_price ?? 0,
                    'cost_price' => $item->cost_price ?? 0,
                    'discount_price' => $item->discount_price ?? 0,
                    'discount' => $item->discount ?? 0,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);

                $itemImage = TransactionCode::ITEM_IMAGE_CODE;
                $bixz_code = ItemImage::max('code');
                $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;

                ItemImage::create([
                    'code' => $itemImage.$max_id,
                    'item_code' => $item->code,
                    'file_path' => $request->image != null ? $request->image['path'] : null,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow()
                    ]);

            }



            DB::commit();

            return response()->json(['status' => 200, 'message' => "Item Master Insert"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addItemPrice($item_price, $item_code)
    {
        try {
            if (count($item_price) > 0) {

                foreach ($item_price as $itemPrice) {
                    $this->itemPrice($itemPrice, $item_code);
                }
            }
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }




    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        try {

            DB::beginTransaction();
            $item = itemMaster::where('code', $id)->first();
            $item->update([

                'reference_code' => $request->referenceCode,
                'barcode' => $request->barcode,
                'name' => $request->name,
                'description' => $request->description,
                'category_code' => $request->itemCategory != null ? $request->itemCategory['code'] : null,
                'sub_category_code' => $request->itemSubCategories != null ? $request->itemSubCategories['code'] : null,
                'unit_code' => $request->itemUnit != null ? $request->itemUnit['code'] : null,
                'brand_code' => $request->itemBrand != null ? $request->itemBrand['code'] : null,
                'size_code' => $request->size != null ? $request->size['code'] : null,
                'color_code' => $request->itemColor != null ? $request->itemColor['code'] : null,
                'bin_location_code' => $request->itemBinLocation != null ? $request->itemBinLocation['code'] : null,
                'wholesale_price' => $request->wholesalePrice,
                'retail_price' => $request->retailPrice,
                'dealer_price' => $request->dealerPrice,
                'least_price' => $request->leastPrice,
                'cost_price' => $request->costPrice,
                'discount_price' => $request->discountPrice,
                'discount' => $request->discount,
                'min_stock' => $request->minStock,
                'max_stock' => $request->maxStock,
                'model' => $request->model,
                'is_service' => $request->type == 'service' ? 1 : 0,
                'reorder_stock' => $request->reorderStock,
                'expiry_notification_days' => $request->expiryNotificationDays,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            // $itemImage = ItemImage::where('item_code', $item->code)->first();
            // $itemImage->update([
            //     'file_path' => $request->image? $request->image['path'] : null,
            //     'updated_by' => getUserCode(),
            //     'updated_at' => getDateTimeNow()
            //     ]);

            DB::commit();

            return response()->json(['status' => 200, 'message' => "Item Master Updated"]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }






    public function destroy($id)
    {
        try {

            $item = itemMaster::findOrFail($id);
            $item->update([
                'is_active' => 0
            ]);
            return response()->json(['status' => 200, 'message' => "Item Master Deleted"]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
    public function getLatstItemCategory($key)
    {
        try {
            $item = ItemMaster::select('barcode')
                ->where('is_active', 1)
                ->where('category_code', 'like', "%$key%")
                ->orderBy('created_at', 'desc')
                ->limit(1)
                ->get();

            return response()->json(['status' => 200, 'item' => $item]);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }
}
