<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemImage;
use App\Enums\TransactionCode;

class ItemImageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
                $images = ItemImage::select('code','item_code','file_path')
                ->where('is_active','=',1)
                ->get();
                
                return response()->json(['status'=> 200, 'images'=>$images]);
        
            }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
    public function show($id)
    {

        try{
            $image = ItemImage::select('code','item_code','file_path')
            ->where('is_active','=',1)
            ->where('code',$id)
            ->first();
            
            return response()->json(['status'=> 200, 'image'=>$image]);
        
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        try{
            $itemImage = TransactionCode::ITEM_IMAGE_CODE;
            $bixz_code = ItemImage::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;

            $image = ItemImage::create([
                'code' => $itemImage.$max_id,
                'item_code' => $request->item_code,
                'file_path' => $request->path,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
                ]);
            return response()->json(['status'=> 200, 'message'=>'Item Image Created']);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{
            $image = ItemImage::where('code',$id)->first();
            $image ->update([
                'item_code'=>$request->item_code,
                'file_path'=>$request->location,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
                ]);
            return response()->json(['status'=> 200, 'message'=>'Item Image updated']);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $image = ItemImage::findOrFail($id);
            $image->update([
                'is_active'=>1
                ]);
            return response()->json(['status'=> 200, 'message'=>'Item Image deleted']);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
