<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemColor;
use App\Enums\TransactionCode;


class ItemColorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        try{
            $color = ItemColor::select('code','name','description')->where( 'is_active', '=', 1)->get();
            return response()->json(['status'=> 200, 'color'=>$color]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    public function show($id)
    {

        try{
            $color = ItemColor::select('code','name','description')
            ->where( 'code',$id)
            ->where('is_active','=',1)
            ->first();
            return response()->json(['status'=> 200, 'color'=>$color]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $itemColor =TransactionCode::ITEM_COLOR_CODE;
            $bixz_code = ItemColor::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;

            $color = ItemColor::create([
                'code'=>$itemColor.$max_id,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Color Created"]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $color= ItemColor::where('code',$id)->first();
            $color ->update([
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Color updated"]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $color = ItemColor::findOrFail($id);
            $color->update([
                'is_active'=>0
            ]);
            return response()->json(['status'=> 200, 'message'=>"Color Deleted"]);

            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
