<?php
// i//
namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemCategory;
use App\Models\Item_Models\ItemSubCategory;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;

class ItemCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        //  try {
            $categories = ItemCategory::select(
                'code',
                'name',
                'category_code',
                'description')
            ->where('is_active', '=', 1)->get();
            return response()->json([
                'status' => 200,
                'category' => $categories
            ]);
        // } catch (Exception $e) {
        //     return response()->json([
        //         'status' => 500,
        //         'message' => $e
        //     ], 500);
        // }
    }


    public function show($id)
    {
        try {
            $category = ItemCategory::select('code','name','category_code')
                ->with(['itemSubCategories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->json([
                'status' => 200,
                'category' => $category
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            DB::beginTransaction();

            // Check if the name already exists in the database
            $existingCategory = ItemCategory::where('name', $request->name )->first();
            if ($existingCategory) {
                return response()->json([
                    'status' => 200,
                    'categogryExiting' => true,
                    'message' => "'{$request->name}' is already exsiting!",
                ], 200);
            }
            $existingCategory = ItemCategory::where('category_code', $request->categoryCode)->first();
            if ($existingCategory) {
                return response()->json([
                    'status' => 200,
                    'codeExisting'=>true,
                    'message' => "Category code: {$request->categoryCode} is already existing!",
                ], 200);
            }

            $itemCategory = TransactionCode::ITEM_CATEGORY_CODE;
            $bixz_code = ItemCategory::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;

            $category = ItemCategory::create([
                'code' => $itemCategory . $max_id,
                'name' => $request->name,
                'category_code' => $request->categoryCode,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);

            if ($category) {
                $itemSubCategory = $request->itemSubCategories;
                $this->addSubCategory($itemSubCategory, $category->code);
            }

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Item Category Created"
            ], 200);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            DB::transaction(function () {
            });

            DB::beginTransaction();

            $category = ItemCategory::where('code', $id)->first();
            $category->update([
                'name' => $request->name,
                'category_code' => $request->categoryCode,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            if ($category) {

                $itemSubCategory = $request->itemSubCategories;
                $this->updateSubCategory($itemSubCategory, $category->code);
            }

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => 'Item Category Updated'

            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy($id)
    {
        try {
            $category = ItemCategory::select('id', 'is_active')->findOrFail($id);
            $category->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "category - Deleted"
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    protected function addSubCategory($itemSubCategory, $category_code)
    {
        try {

            if (count($itemSubCategory) > 0) {
                foreach ($itemSubCategory as $sub_category) {

                    $this->createSingleSubCategory($sub_category, $category_code);
                }
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    protected function updateSubCategory($itemSubCategory, $category_code)
    {
        try {


            foreach ($itemSubCategory as $sub_category) {
                $itemSubCategory = "";

                if (isset($sub_category['code'])) {
                    $itemSubCategory = ItemSubCategory::select('id', 'code', 'category_code')
                        ->where('code', $sub_category['code'])
                        ->where('category_code', $category_code)
                        ->first();

                    $itemSubCategory->update([
                        'name' => $sub_category['name'],
                        // 'description'=>$sub_category['description'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                } else {
                    $this->createSingleSubCategory($sub_category, $category_code);
                }
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    protected function createSingleSubCategory($sub_category, $category_code)
    {
        try {
            DB::transaction(function () {
            });
            DB::beginTransaction();

            $itemSubCategory = TransactionCode::ITEM_SUB_CATEGORY_CODE;

            $bixz_code = ItemSubCategory::max('code');
            $max_id = $bixz_code == null ? config('global.code_value') + 1 : substr("$bixz_code", 3) + 1;

            ItemSubCategory::create([
                'code' => $itemSubCategory . $max_id,
                'category_code' => $category_code,
                'name' => $sub_category['name'],
                // 'description'=>$sub_category['description'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Sub Category created"
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
