<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemBrand;
use App\Enums\TransactionCode;

class ItemBrandController extends Controller
{

    public function index()
    {
        try{
            $brand = ItemBrand::select('code','name','description')
            ->where( 'is_active', '=', 1)
            ->get();
            return response()->json(['status'=> 200, 'brand'=>$brand]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }

    }

    public function show($id)
    {

        try{
            $brand = ItemBrand::select('code','name','description')
            ->where( 'code',$id)
            ->where('is_active','=',1)
            ->first();
            return response()->json(['status'=> 200, 'brand'=>$brand]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try{

            $itemBrand =TransactionCode::ITEM_BRAND_CODE;
            $bixz_code = ItemBrand::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;

            $brand = ItemBrand::create([
                'code'=> $itemBrand.$max_id,
                'name'=>$request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Brand Created"]);

         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }


    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {

        try{

            $brand= ItemBrand::where('code',$id)->first();
            $brand ->update([
                'name'=>$request->name,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=>"Brand updated"]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
        $brand = ItemBrand::findOrFail($id);
        $brand->update([
            'is_active'=>0
        ]);
        return response()->json(['status'=> 200, 'message'=>"Brand Deleted"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
