<?php

namespace App\Http\Controllers\Item_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item_Models\ItemBinLocation;
use App\Enums\TransactionCode;

class ItemBinLocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
            $bin = ItemBinLocation::select('code','location')->where('is_active','=',1)->get();
            return response()->json(['status'=> 200, 'bin'=>$bin]);
            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }

    public function show($id)
    {
        try{
            $bin = ItemBinLocation::select('code','location')->where('is_active','=',1)->where('code',$id)->first();
            return response()->json(['status'=> 200, 'bin'=>$bin]);
            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }


    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try{
            $itemBin =TransactionCode::ITEM_BIN_LOCATION_CODE;
            $bixz_code = ItemBinLocation::max('code');
            $max_id= $bixz_code==null ? config('global.code_value')+1 : substr("$bixz_code",3)+1;
            $bin = ItemBinLocation::create([
                'code'=>$itemBin.$max_id,
                'location'=>$request->location,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

                ]);
            return response()->json(['status'=> 200, 'message'=>"Bin Location Created"]);
            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {

        try{
            $bin = ItemBinLocation::where('code',$id)->first();
            $bin ->update([
                'location'=>$request->location,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            return response()->json(['status'=> 200, 'message'=>"Bin Updated"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $bin = ItemBinLocation::findOrFail($id);
            $bin ->update([
                'is_active'=>0
            ]);
            return response()->json(['status'=> 200, 'message'=>"Bin Deleted"]);

        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }
}
