<?php

namespace App\Http\Controllers\Invoice_Controllers;

use App\Enums\DefaultValues;
use App\Enums\StockHistorySource;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Invoice_Models\Invoice;
use App\Models\Stock_Models\StockHistoryExt;
use App\Enums\TransactionCode;
use App\Models\Stock_Models\StockHistory;
use App\Http\Controllers\Function_Controllers\PaymentReceiptFunction;
use App\Http\Controllers\Function_Controllers\PaymentReceiptFunctionForInvoice;
use App\Http\Controllers\Function_Controllers\StockHistoryFunction;
use App\Models\Customer_Models\Customer;
use App\Http\Controllers\Function_Controllers\StockFunction;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\Stock_Models\Stock;
use Illuminate\Support\Facades\DB;
use Exception;

class InvoiceWithPackSizeController extends Controller
{
    private $stock_history_function;
    private $payment_receipt_function_for_invoice;
    private $stock_function;

    public function __construct()
    {
        $this->stock_history_function =  new StockHistoryFunction();
        $this->payment_receipt_function_for_invoice =  new PaymentReceiptFunctionForInvoice();
        $this->stock_function = new StockFunction();
    }


    public function index()
    {

        try {
            $invoices = Invoice::select('code', 'invoice_number', 'invoice_source_code', 'date', 'customer_code', 'quotation_code', 'sales_order_code', 'discount_amount', 'discount_percentage', 'bill_discount', 'discount_total', 'paid_amount', 'sub_total_amount', 'total_amount', 'paid_status', 'received_amount', 'invoices.prints', 'created_by', 'updated_by')
                ->with([
                    'stockHistories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where('is_active', '=', 1)
                ->get();
            return response()->json(['status' => 200, 'Invoice' =>  $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }



    public function recentInvoice($key)
    {

        try {
            $invoices = Invoice::select('invoices.code', 'invoices.invoice_number',  'invoices.date_time', 'customer_code', 'invoices.paid_amount', 'invoices.sub_total_amount', 'invoices.total_amount', 'invoices.paid_status', 'invoices.prints')
                ->with([
                    'customer' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                 ->with([
                    'customer.customerAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->Where('invoices.code', 'like', "%$key%")
                ->limit(3)->orderBy('invoices.code', 'DESC')->get();

            return response()->json(['status' => 200, 'Invoice' =>  $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function outstandingInvoiceForCustomer($key)
    {
        // try {
        //     $code = $request->code;

        //     $sql = "SELECT invoices.code,invoices.date, invoices.customer_code,invoices.total_amount,
        //     IFNULL((select sum(invoice_payments.paid_amount) from  invoice_payments where invoice_payments.invoice_code = invoices.code),0) as invoicePayment
        //     FROM invoices
        //     where invoices.customer_code =  $code and invoices.paid_status !=1 and invoices.total_amount != IFNULL((select sum(invoice_payments.paid_amount) from  invoice_payments where invoice_payments.invoice_code = invoices.code),0)";
        //     $outstandingInvoice = DB::select($sql);

        //     return response()->json(['status' => 200, 'OutstandingInvoice' =>  $outstandingInvoice]);
        // } catch (\Exception $e) {
        //     throw new Exception($e);
        // }

        try {
            $invoices = Invoice::select('invoices.code',  'customer_code', 'customers.first_name', 'total_amount',  'invoices.date_time', 'invoices.total_amount', 'invoices.paid_amount')
                ->join('customers', 'customers.code', '=', 'invoices.customer_code')
                ->where([
                    ['invoices.is_active', '=', 1],
                ])
                ->whereColumn(
                    'invoices.total_amount',
                    '>',
                    'invoices.paid_amount'
                )
                ->where(function ($query) use ($key) {
                    $query->Where('customers.code', 'like', "%$key%");
                })->get();
            return response()->Json(['status' => 200, 'invoices' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function show($id)
    {
        try {
            $invoice = Invoice::select('code', 'invoice_number', 'invoice_source_code', 'date', 'customer_code', 'quotation_code', 'sales_order_code', 'discount_amount', 'discount_percentage', 'bill_discount', 'discount_total', 'paid_amount', 'sub_total_amount', 'total_amount', 'paid_status', 'prints', 'received_amount')
                ->with([
                    'stockHistories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->with([
                    'salesReturns' => function ($query) {
                    $query->where('is_active', '=', 1);
                }])
                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();

            $salesReturn = SalesReturn::select('code', 'invoice_code', 'total_amount', 'remarks', 'customer_code',  'total_amount', 'return_date_time')
                ->with([
                    'stockHistories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->where('is_active', '=', 1)
                ->where('invoice_code', $id)
                ->first();



            return response()->json(['status' => 200, 'invoice' =>  $invoice, 'salesReturn' => $salesReturn]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function invoiceSearch($key)
    {
        try {
            $invoice = Invoice::select('code', 'invoice_number', 'invoice_source_code', 'date', 'customer_code',  'quotation_code', 'sales_order_code', 'discount_amount', 'discount_percentage', 'bill_discount', 'discount_total', 'paid_amount', 'sub_total_amount', 'total_amount', 'prints', 'paid_status', 'received_amount', 'created_by', 'updated_by')
                ->with([
                    'stockHistories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
                ])
                // ->with(['invoicePayment' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('invoice_number', 'like', "%$key%")
                        ->orWhere('customer_code', 'like', "%$key%");
                })
                ->get();
            return response()->json(['status' => 200, 'invoice' =>  $invoice]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function itemPriceSearch($key)
    {
        try
        {
            $price = Stock::select('stocks.code AS stockCode', 'stocks.stock_location_code', 'item_masters.code', 'item_masters.barcode', 'item_masters.name', 'item_masters.unit_code','item_units.name AS unitName','item_masters.description', 'stocks.remaining_quantity', 'stocks.wholesale_price', 'stocks.retail_price', 'stocks.cost_price')
                ->join('item_masters', 'item_masters.code', '=', 'stocks.item_code')
                ->join('item_units', 'item_masters.unit_code', '=', 'item_units.code')
                ->where([['remaining_quantity', '>', 0]]) //Comment if you don't want to display 0 remaining quantity

                // ->with(['itemMaster.itemUnit' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where(function ($query) use ($key) {
                $query->orWhere('item_masters.code', 'like', "%$key%")
                ->orWhere('item_masters.barcode', 'like', "%$key%")
                ->orWhere('item_masters.name', 'like', "%$key%")
                ->orWhere('item_masters.description', 'like', "%$key%");
                })
                ->get();
            return response()->json(['status' => 200, 'item' =>  $price]);
        }
         catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $invoice_code = TransactionCode::INVOICE_CODE;
            $cus_code = Invoice::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $invoice = Invoice::create([
                'code' => $invoice_code . $max_id,
                'invoice_number' => $request->invoiceNumber,
                'invoice_source_code' => $request->invoiceSourceCode,
                'date' => getDateTimeNow(),
                'customer_code' => $request->customer ? $request->customer['code'] : DefaultValues::CUSTOMER_CODE,
                'quotation_code' => $request->quotationCode ?? null,
                'sales_order_code' => $request->salesOrderCode ?? null,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'bill_discount' => $request->billDiscount,
                'discount_total' => $request->discountTotal,
                'paid_amount' => $request->paidAmount,
                'sub_total_amount' => $request->subTotalAmount,
                'total_amount' => $request->totalAmount,
                'paid_status' => $request->paidStatus,
                'prints' => 1,
                'is_locked' => $request->isLocked,
                'received_amount' => $request->receivedAmount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            if ($invoice) {

                $stock_history = $request->stockHistory;
                $stockHistoryExt = $request->stockHistoryExt;
                if (count(($stock_history)) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $quatity = $stockHistory['quantity'];

                        $quatity =  $quatity * $stockHistory['packSize'];
                        $stockHistory['subTotalAmount'] =  $quatity * $stockHistory['retailPrice'];
                        $stockHistory['totalAmount'] = $stockHistory['retailPrice'] ? ($quatity * $stockHistory['retailPrice']) - (($quatity * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) - ($quatity * $stockHistory['discountAmount']) : 0;
                        $stockHistory['discountTotal'] = $stockHistory['retailPrice'] ? ($quatity * $stockHistory['discountAmount']) + (($quatity * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) : 0;
                        $stockHistory['subTotalAmount'] =  $quatity * $stockHistory['retailPrice'];

                        //Unit Sold Price is the amount per item after applying the discount
                        $stockHistory['unitSoldPrice'] = $stockHistory['totalAmount'] / $quatity;
                        $stock = $this->stock_function->getExistingStock($stockHistory['stockCode']);
                        $remainingQuantity = $stock->remaining_quantity - $quatity;
                        $stock->update([
                            'remaining_quantity' => $remainingQuantity,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                        $stockHistoryAdd = $this->stock_history_function->addStockHistory($stockHistory, $invoice->code, StockHistorySource::INVOICE, $stock);

                        $this->stock_history_function->addStockHistoryExt($stockHistory,  $stockHistory['packSize'], $stockHistoryAdd->code);

                    }
                   // count((is_countable($admin)?$admin:[]))
                }

                 //stock history ext used for adding pack size
                 $stock_History_Ext = $request->stockHistoryExt;
                 if (($stock_History_Ext) > 0){
                 foreach ($stock_History_Ext as $stockHistoryExt) {
                     $this->stock_history_function->addStockHistoryExt($stockHistory, $stockHistoryExt, $stockHistory->code);

                 }
             }

                $modeOfPayments = $request->modeOfPayments;
                if ($request->paidAmount != 0) {
                    $this->payment_receipt_function_for_invoice->addPaymentReceipt($request, $modeOfPayments, $invoice);
                }

                if ($invoice->customer_code !=  DefaultValues::CUSTOMER_CODE) {
                    $customer = Customer::where('code', $invoice->customer_code)->first();
                    $customer->update([
                        'invoice_total' => $invoice->total_amount + $customer['invoice_total'],
                        'received_amount' => $invoice['paid_amount'] + $customer['received_amount'],
                        'credit_amount' => $invoice['paid_amount'] == 0 ? ($customer['credit_amount'] + $invoice['total_amount']) : $customer['credit_amount'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }

            DB::commit();

            return response()->json([
                'status' => 200,
                'Invoice' => "Invoice created",
                'code' => $invoice->code,
                'date' => getDateTimeNow(),
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);

            return response()->json([
                'status' => 500,
                'message' => $e->getMessage()
            ], 500);

        }
    }



    public function edit($id)
    {
        //
    }

    //Calling, when Invoice Edit
    /**
     * update
     * Author : Fathima Sajana
     * Date : 2022.11.11 , 2022.12.04
     * Version : 2
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(Request $request, $id)
    {
        try
        {
            DB::beginTransaction();

            $invoice = Invoice::where('code', $id)->first();
            if ($invoice) {
                $customer = Customer::where('code', $invoice->customer_code)->first();
                $customer->update([   // when newly start this function for changing customer (already existing invoice customer) , call this one for reducing credit balance from that custoemr
                    'credit_amount' => $customer['credit_amount'] - (($invoice->total_amount)- ($invoice->paid_amount)),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }
            $invoice->update([
                'invoice_number' => $request->invoiceNumber,
                'invoice_source_code' => $request->invoiceSourceCode,
                'customer_code' => $request->customer['code'] ?? null,
                'quotation_code' => $request->quotationCode ?? null,
                'sales_order_code' => $request->salesOrderCode ?? null,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'bill_discount' => $request->billDiscount,
                'discount_total' => $request->discountTotal,
                'paid_amount' => $request->paidAmount,
                'sub_total_amount' => $request->subTotalAmount,
                'total_amount' => $request->totalAmount,
                'paid_status' => $request->paidStatus,
                'prints' => $request->prints,
                'is_locked' => $request->isLocked,
                'received_amount' => $request->receivedAmount,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);

            if ($invoice) {
                $stock_history = $request->stockHistory;
                if (count($stock_history) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $quatity = $stockHistory['quantity'];

                        $stockHistory['totalAmount'] = $stockHistory['retailPrice'] ? ($quatity * $stockHistory['retailPrice']) - (($quatity * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) - ($quatity * $stockHistory['discountAmount']) : 0;
                        $stockHistory['discountTotal'] = $stockHistory['retailPrice'] ? ($quatity * $stockHistory['discountAmount']) + (($quatity * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) : 0;

                        //Unit Sold Price is the amount per item after applying the discount
                        $stockHistory['unitSoldPrice'] =  $stockHistory['totalAmount'] / $quatity;

                        //$stock =  $this->stock_history_function->stockUpdate($stockHistory, StockHistorySource::INVOICE);

                        $stock = $this->stock_history_function->stockResetInvoice($stockHistory, StockHistorySource::INVOICE, $invoice);
                        $stock = Stock::select('code', 'remaining_quantity')
                        ->where('code', $stockHistory['stockCode'])
                        ->first();
                        StockHistory::where('code', $stockHistory['stockCode'])
                        ->update([
                            'remaining_quantity' =>  $stock['remaining_quantity'] ?? null,
                    ]);

                    $this->stock_history_function->updateStockHistory($stockHistory, $invoice->code, StockHistorySource::INVOICE, $stock);
                    }
                }

                $modeOfPayments = $request->modeOfPayments;

                if ($request->paidAmount != 0) {
                    $this->payment_receipt_function_for_invoice->addPaymentReceipt($request, $modeOfPayments, $invoice);
                }

                if ($invoice->customer_code != DefaultValues::CUSTOMER_CODE) {
                    $customer = Customer::where('code', $invoice->customer_code)->first();
                    $customer->update([  // calling this credit balance for newly changed customer (from existing customer to updated customer), this customer alredy had credit balance adding new amount through this credit_amount , if it is not call other fuction ($invoice->total_amount - $invoice->paid_amount)
                        'credit_amount' => ($invoice->total_amount - $invoice->paid_amount) > 0 ? $customer['credit_amount'] + ($invoice->total_amount - $invoice->paid_amount) : $customer['credit_amount'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Invoice Updated",
                'code' => $invoice->code,
                'date' => $invoice->updated_at,
            ], 200);
         }
        catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function destroy($id)
    {
        try {
            $invoice = Invoice::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $invoice->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Invoice- Deleted"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
}
