<?php

namespace App\Http\Controllers\Invoice_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Invoice_Models\InvoiceSource;
use App\Enums\TransactionCode;
use Illuminate\Support\Facades\DB;

class InvoiceSourceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
            $invoiceSources  = InvoiceSource::select('code','name')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'invoiceSources' =>  $invoiceSources ]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function show($id)
    {
        try{
            $invoiceSources  = InvoiceSource::select('code','name')->where('id',$id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'Invoice Sources' =>  $invoiceSources ]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{

            $invoice_code =TransactionCode::BILL_SOURCE_CODE;
            $cus_code = InvoiceSource::max('code');
            $max_id= $cus_code==null ? config('global.code_value')+1 : substr("$cus_code",3)+1;

            $invoiceSource = InvoiceSource::create([

                'code'=> $invoice_code.$max_id,
                'name'=> $request->name,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);

            return response()->json(['status' => 200, 'message'=>"Invoice Created" ]);
        }catch (\Exception $e) {
            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{
        $invoiceSource= InvoiceSource::where('code',$id)->first();
        $invoiceSource->update([
            'name'=> $request->name,
            'updated_by'=> getuserCode(),
            'updated_at'=> getDateTimeNow(),
        ]);
        return response()->json(['status'=> 200, 'message'=> 'Invoice Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $invoiceSource = InvoiceSource::select('id','is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $invoiceSource->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=> "Invoice - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
