<?php

namespace App\Http\Controllers\Invoice_Controllers;

use Exception;
use App\Enums\DefaultValues;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Enums\MultiPurposeStatus;
use App\Enums\StockHistorySource;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Invoice_Models\InvoiceTemps;
use App\Models\Stock_Models\StockHistoryTemp;
use App\Http\Controllers\Function_Controllers\StockHistoryFunction;


class InvoiceSaveController extends Controller
{
    private $stock_history_function;
    private $stock_function;
    private $payment_receipt_function_for_invoice;
    private $sms_function;



    public function __construct()
    {
        $this->stock_history_function = new StockHistoryFunction();
    }

    public function index()
    {
        try {
            $invoices = InvoiceTemps::select(
                'code',
                'stock_location_code',
                'invoice_number',
                'invoice_source_code',
                'date_time',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'sub_total_amount',
                'total_amount',
                'paid_status',
                'remarks',
                'status',
                'created_by',
                'updated_by'
            )
                ->with([
                    'stockHistoryTemp' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistoryTemp.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistoryTemp.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                // ->with([
                //     'user' => function ($query) {
                //         $query->where('is_active', '=', 1);
                //     }
                // ])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where('is_active', '=', 1)
                ->orderBy('code', 'desc')
                ->get();
            return response()->json(['status' => 200, 'Invoice' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function recentSavedInvoice(Request $request)
    {

        try {
            $key = $request->key;

            if($key) {
                $invoices = InvoiceTemps::select(
                    'code',
                    'invoice_number',
                    'invoice_source_code',
                    'date_time',
                    'customer_code',
                    'sales_quotation_code',
                    'sales_order_code',
                    'discount_amount',
                    'discount_percentage',
                    'bill_discount',
                    'discount_total',
                    'sub_total_amount',
                    'total_amount',
                    'paid_status',
                    'status',
                    'prints',
                    'billing_price',
                    'remarks',
                    'created_at',
                    'created_by'
                )
                    ->with([
                        'customer' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'customer.customerAddresses' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'user' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                    ->Where('code', '=', $key)
                    ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    //->limit(3)->orderBy('invoices.series_code')
                    ->where('status','<>',MultiPurposeStatus::INVOICED)
                    ->where('total_amount','<>',0)
                   // ->limit(3)->orderBy('code', 'DESC')
                   ->get();
            }else {
                $invoices = InvoiceTemps::select(
                    'code',
                    'invoice_number',
                    'invoice_source_code',
                    'date_time',
                    'customer_code',
                    'sales_quotation_code',
                    'sales_order_code',
                    'discount_amount',
                    'discount_percentage',
                    'bill_discount',
                    'discount_total',
                    'sub_total_amount',
                    'total_amount',
                    'paid_status',
                    'status',
                    'prints',
                    'billing_price',
                    'remarks',
                    'created_at',
                    'created_by'
                )
                    ->with([
                        'customer' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'customer.customerAddresses' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'user' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                    ->Where('code', 'like', "%$key%")
                    ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    //->limit(3)->orderBy('invoices.series_code')
                    ->where('status','<>',MultiPurposeStatus::INVOICED)
                    ->where('total_amount','<>',0)
                    ->limit(3)->orderBy('code', 'DESC')->get();
            }


            return response()->json(['status' => 200, 'Invoice' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

        /**
     * show
     *
     * Author: Aasif Saneeth
     * Date: 06.11.2023
     * Version : 3
     * Logic : Get invoice Detailssetteld by single payment Receipt
     * @param  mixed $id
     * @return void
     */
    public function show($id)
    {

       // try {
            $invoice = InvoiceTemps::select(
                'code',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'sub_total_amount',
                'total_amount',
                'billing_price',
                'prints',
                'series_code',
                'remarks',
                'created_at',
                'created_by'
            )
                ->with([
                    'stockHistoryTemp' => function ($query) {
                        $query->select('*', 'quantity as oldQuantity')
                            ->where('is_active', '=', 1);
                    },
                    'stockHistoryTemp.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistoryTemp.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistoryTemp.stock' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.route' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'salesQuotation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->where('is_active', '=', 1)
                ->Where('code', 'like', "%$id%")
                ->first();

            return response()->json(
                [
                    'status' => 200,
                    'invoice' => $invoice,
                ]
            );
        // } catch (Exception $e) {
        //     throw new Exception($e);
        // }
    }




    /**
     * store
     * Author: Assif Saneeth
     * Date: 23.07.2024
     * Version: 01
     * Logic: Stores the Invoice Details, stock History
     * Not update stock and
     * @param  mixed $request
     * @return void
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $invoice_code = TransactionCode::INVOICE_TEMPS;

            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr($stockLocationCode, -2);
            $SERIES_CODE = $request->seriesCode;
            //$series = substr($SERIES_CODE, -2);
            $max_code = InvoiceTemps::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
               // ->where('series_code', '=', $SERIES_CODE)
                ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;


            $savedInvoice = InvoiceTemps::create([
                'code' => $invoice_code . $locationPrefix . $max_id,
                //'code' => $invoice_code . $locationPrefix . $max_id,
                'invoice_number' => $request->invoiceNumber,
                'stock_location_code' => getCurrentLocationCode($request),
                'series_code' => $SERIES_CODE,
                'invoice_source_code' => $request->invoiceSourceCode,
                'date_time' => getDateTimeNow(),
                //'date_time' => $request->date,
                'customer_code' => $request->customer ? $request->customer['code'] : DefaultValues::CUSTOMER_CODE,
                'sales_quotation_code' => $request->salesQuotation ? $request->salesQuotation['code'] : null,
                'sales_order_code' => $request->salesOrderCode ?? null,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'bill_discount' => $request->billDiscount,
                'discount_total' => $request->discountTotal,
                'sub_total_amount' => $request->subTotalAmount,
                'total_amount' => $request->totalAmount,
                'paid_status' => $request->paidStatus,
                'prints' => 1,
                'is_locked' => $request->isLocked,
                'billing_price' => $request->billingPrice,
                'remarks' => $request->remarks,
                'phone_2'=> $request->phone2,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            if ($savedInvoice) {

                $stock_history = $request->stockHistories;
                if (count(($stock_history)) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $quantity = $stockHistory['quantity'];
                        $stockHistory['subTotalAmount'] = $quantity * $stockHistory['retailPrice'];
                            $stockHistory['totalAmount'] = $stockHistory['retailPrice'] ? ($quantity * $stockHistory['retailPrice']) - (($quantity * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) - ($quantity * $stockHistory['discountAmount']) : 0;
                            $stockHistory['discountTotal'] = $stockHistory['retailPrice'] ? ($quantity * $stockHistory['discountAmount']) + (($quantity * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) : 0;
                            $stockHistory['subTotalAmount'] = $quantity * $stockHistory['retailPrice'];
                            $this->addStockHistoryTemp($stockHistory, $savedInvoice->code, StockHistorySource::INVOICE_SAVE);

                    }
                }
            }

            DB::commit();
           // $invoiceCreated = $this->invoiceSearchForInsert($invoice->code);
            return response()->json([
                'status' => 200,
                'Invoice' => "Invoice saved",
                'code' => $savedInvoice->code,
                //'submittedData' => $invoiceCreated,
                //'date_time' => $invoice->date_time,
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            throw new Exception($e);


        }
    }



    private function addStockHistoryTemp($stockHistoryTemp, $sourceCode, $source)
    {
        try {
            DB::beginTransaction();
            $order = TransactionCode::STOCK_HISTORY_TEMP;
            $max_code = StockHistoryTemp::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            $stockHistoryTemp = StockHistoryTemp::create([
                'code' => $order . $max_id,
                'item_code' => $stockHistoryTemp['itemMaster']['code'] ?? $stockHistoryTemp['itemCode'],
                'source_code' => $sourceCode,
                'stock_code' => $stockHistoryTemp['stockCode'],
                'source' => $source,
                'wholesale_price' => $stockHistoryTemp['wholesalePrice'] ?? null,
                'retail_price' => $stockHistoryTemp['retailPrice'] ?? null,
                'cost_price' => $stockHistoryTemp['costPrice'] ?? null,
                'quantity' => $stockHistoryTemp['quantity'] ?? null,
                'sub_total_amount' => $stockHistoryTemp['subTotalAmount'],
                'discount_amount' => $stockHistoryTemp['discountAmount'] ?? null,
                'discount_percentage' => $stockHistoryTemp['discountPercentage'] ?? null,
                'discount_total' => $stockHistoryTemp['discountTotal'] ?? null,
                'total_amount' => $stockHistoryTemp['totalAmount'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);


            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            throw new Exception($e);
        }
    }

    public function inActivInvoiceItems(Request $request){
        try {
            $code = $request->code;
            $stockHistory =   StockHistoryTemp::where('code', $code)->first();

            if($stockHistory){
                $stockHistory->update([
                    'is_active'=>0,
                ]);
            }

             $invoiceTems = InvoiceTemps::where('code', $stockHistory['source_code'])->first();
            //  $invoiceTemsTotal =  $invoiceTems['total_amount'];

            //  $totalAmount = $stockHistory['total_amount'];
            $invoiceTems->update([
                'sub_total_amount'=> $invoiceTems['total_amount'] - $stockHistory['total_amount'],
                'total_amount'=> $invoiceTems['total_amount'] - $stockHistory['total_amount'],
            ]);

            return response()->json([
                'status' => 200,
                'message' =>  'Invactive Successfully',
                //'total'=> $totalAmount,
                 'stockHistory'=>$stockHistory,
                 //'temsTotal'=>  $invoiceTemsTotal
                 'invoiceTems'=>$invoiceTems,



                //'submittedData' => $invoiceCreated,
                //'date_time' => $invoice->date_time,
            ]);

        } catch (Exception $e) {
          DB::rollBack();
          throw new Exception($e);

        }
    }

    public function update(Request $request, $id)
    {
        //try {
            DB::beginTransaction();

            $savedInvoice = InvoiceTemps::where('code',$id)
            ->first();

            $savedInvoice->update([
                'invoice_number' => $request->invoiceNumber,
                'stock_location_code' => getCurrentLocationCode($request),
                'series_code' => $request->seriesCode,
                'invoice_source_code' => $request->invoiceSourceCode,
                'date_time' => getDateTimeNow(),
                //'date_time' => $request->date,
                'customer_code' => $request->customer ? $request->customer['code'] : DefaultValues::CUSTOMER_CODE,
                'sales_quotation_code' => $request->salesQuotation ? $request->salesQuotation['code'] : null,
                'sales_order_code' => $request->salesOrderCode ?? null,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'bill_discount' => $request->billDiscount,
                'discount_total' => $request->discountTotal,
                'sub_total_amount' => $request->subTotalAmount,
                'total_amount' => $request->totalAmount,
                'paid_status' => $request->paidStatus,
                'prints' => 1,
                'is_locked' => $request->isLocked,
                'billing_price' => $request->billingPrice,
                'remarks' => $request->remarks,
                'phone_2'=> $request->phone2,
                'created_by' => getUserCode(),
                //'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            StockHistoryTemp::where('source_code', $savedInvoice->code)
            ->delete();

            if ($savedInvoice) {
                $stock_history = $request->stockHistories;
                if (count(($stock_history)) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $quantity = $stockHistory['quantity'];
                        $stockHistory['subTotalAmount'] = $quantity * $stockHistory['wholesalePrice'];
                            $stockHistory['totalAmount'] = $stockHistory['wholesalePrice'] ? ($quantity * $stockHistory['wholesalePrice']) - (($quantity * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) - ($quantity * $stockHistory['discountAmount']) : 0;
                            $stockHistory['discountTotal'] = $stockHistory['wholesalePrice'] ? ($quantity * $stockHistory['discountAmount']) + (($quantity * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) : 0;
                            $stockHistory['subTotalAmount'] = $quantity * $stockHistory['wholesalePrice'];
                            $this->addStockHistoryTemp($stockHistory, $savedInvoice->code, StockHistorySource::INVOICE_SAVE);

                    }
                }
            }

            DB::commit();
           // $invoiceCreated = $this->invoiceSearchForInsert($invoice->code);
            return response()->json([
                'status' => 200,
                'Invoice' =>  'Invoice Saved Successfully',
                'code' => $savedInvoice->code,
                //'submittedData' => $invoiceCreated,
                //'date_time' => $invoice->date_time,
            ]);
        // } catch (Exception $e) {
        //     DB::rollBack();
        //     throw new Exception($e);


        // }
    }
    public function invoiceSaveSearch($key)
    {
        try {
            $invoiceSave = InvoiceTemps::select(
                    'code',
                    'invoice_number',
                    'invoice_source_code',
                    'date_time',
                    'customer_code',
                    'sales_quotation_code',
                    'sales_order_code',
                    'discount_amount',
                    'discount_percentage',
                    'bill_discount',
                    'discount_total',
                    'sub_total_amount',
                    'total_amount',
                    'paid_status',
                    'status',
                    'prints',
                    'billing_price',
                    'remarks',
                    'created_at',
                    'created_by'
                )

                ->with([
                    'stockHistoryTemp.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistoryTemp.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                // ->with(['invoicePayment' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where([['is_active', '=', 1]])
                //->leftjoin('sales_reps', 'sales_reps.code', '=', 'customers.rep_code')

                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('invoice_number', 'like', "%$key%")
                        ->orWhere('customer_code', 'like', "%$key%")
                        ->orWhere('total_amount', 'like', "%$key%")
                        ->orWhereHas('customer', function ($query) use ($key) {
                            $query->where('first_name', 'like', "%$key%")
                            ->orwhere('phone_1', 'like', "%$key%")
                            ->orwhere('phone_2', 'like', "%$key%");
                        });
                        ;
                })
                ->get();
            return response()->json(['status' => 200, 'invoice Save' => $invoiceSave]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

}
