<?php

namespace App\Http\Controllers\Invoice_Controllers;

use App\Http\Controllers\Function_Controllers\SmsFunction;
use Exception;
use App\Enums\SearchBy;
use App\Enums\DefaultValues;
use App\Enums\PaymentStatus;
use Illuminate\Http\Request;
use App\Enums\PaymentTypeCode;
use App\Enums\TransactionCode;
use App\Enums\MultiPurposeStatus;
use App\Enums\StockHistorySource;
use App\Models\Stock_Models\Route;
use App\Models\Stock_Models\Stock;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Stock_Models\SalesRep;
use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\InvoiceTemps;
use App\Models\Item_Models\ItemMaster;
use App\Models\Customer_Models\Customer;
use App\Models\Stock_Models\StockHistory;
use App\Models\Invoice_Models\SalesReturn;
use App\Models\PaymentReceipt_Models\BankPayment;
use App\Models\PaymentReceipt_Models\CardPayment;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Models\PaymentReceipt_Models\OverPayment;
use App\Models\PaymentReceipt_Models\ReturnAmount;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\ModeOfPayment;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use App\Models\PaymentReceipt_Models\OnlineTransferPayment;
use App\Http\Controllers\Function_Controllers\StockFunction;
use App\Http\Controllers\Function_Controllers\StockHistoryFunction;
use App\Http\Controllers\Function_Controllers\PaymentReceiptFunction;
use App\Http\Controllers\Function_Controllers\PaymentReceiptFunctionForInvoice;
use App\Models\Customer_Models\SalesOrder;
use App\Models\Item_Models\ItemBrand;
use App\Models\Item_Models\ItemCategory;
use App\Models\Stock_Models\StockHistoryTemp;

class ReturnValues {
    public $itemCode;
    public $quantity;

    public function __construct($property1, $property2) {
        $this->itemCode = $property1;
        $this->quantity = $property2;

    }
}


class InvoiceController extends Controller
{
    private $stock_history_function;
    private $stock_function;
    private $payment_receipt_function_for_invoice;
    private $sms_function;

    public function __construct()
    {
        $this->stock_history_function = new StockHistoryFunction();
        $this->payment_receipt_function_for_invoice = new PaymentReceiptFunctionForInvoice();
        $this->stock_function = new StockFunction();
        $this->sms_function = new SmsFunction();

    }


    public function index()
    {

        try {
            $invoices = Invoice::select(
                'code',
                'invoice_number',
                'stock_location_code',
                'invoice_source_code',
                'date_time',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'total_amount',
                'paid_status',
                'received_amount',
                'remarks',
                'status',
                'invoices.prints',
                'created_by',
                'updated_by',
                'billing_price'
            )
                ->with([
                    'stockHistories' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistories.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'user' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where('is_active', '=', 1)
                ->orderBy('date_time','DESC')
                ->get();
            return response()->json(['status' => 200, 'Invoice' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }



    public function recentInvoice(Request $request)
    {

        try {
            $key = $request->key;

            if($key) {
                $invoices = Invoice::select(
                    'invoices.code',
                    'series_code',
                    'invoices.invoice_number',
                    'invoices.date_time',
                    'customer_code',
                    'invoices.paid_amount',
                    'invoices.sub_total_amount',
                    'invoices.is_freeze',
                    'remarks',
                    'status',
                    'invoices.total_amount',
                    'invoices.paid_status',
                    'invoices.prints',
                    'invoices.created_at',
                    'created_by',
                    'billing_price'
                )
                    ->with([
                        'customer' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'customer.customerAddresses' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'user' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                    ->Where('code', '=', $key)
                     ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    // ->limit(3)->orderBy('invoices.series_code')
                    // ->limit(3)->orderBy('invoices.code', 'DESC')
                    ->get();
            }else {
                $invoices = Invoice::select(
                    'invoices.code',
                    'series_code',
                    'invoices.invoice_number',
                    'invoices.date_time',
                    'customer_code',
                    'invoices.paid_amount',
                    'invoices.sub_total_amount',
                    'invoices.is_freeze',
                    'remarks',
                    'status',
                    'invoices.total_amount',
                    'invoices.paid_status',
                    'invoices.prints',
                    'invoices.created_at',
                    'created_by'
                )
                    ->with([
                        'customer' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'customer.customerAddresses' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    // ->with([
                    //     'user' => function ($query) {
                    //         $query->where('is_active', '=', 1);
                    //     }
                    // ])
                   // ->Where('code', '=', "%$key%")
                    ->where('stock_location_code', '=', getCurrentLocationCode($request))
                    ->limit(3)->orderBy('invoices.series_code')
                    ->limit(3)->orderBy('invoices.code', 'DESC')->get();
            }



            return response()->json(['status' => 200, 'Invoice' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function outstandingInvoiceForCustomer($key)
    {
        // try {
        //     $code = $request->code;

        //     $sql = "SELECT invoices.code,invoices.date, invoices.customer_code,invoices.total_amount,
        //     IFNULL((select sum(invoice_payments.paid_amount) from  invoice_payments where invoice_payments.invoice_code = invoices.code),0) as invoicePayment
        //     FROM invoices
        //     where invoices.customer_code =  $code and invoices.paid_status !=1 and invoices.total_amount != IFNULL((select sum(invoice_payments.paid_amount) from  invoice_payments where invoice_payments.invoice_code = invoices.code),0)";
        //     $outstandingInvoice = DB::select($sql);

        //     return response()->json(['status' => 200, 'OutstandingInvoice' =>  $outstandingInvoice]);
        // } catch (\Exception $e) {
        //     throw new Exception($e);
        // }

        try {
            $invoices = Invoice::select(
                'invoices.code',
                'customer_code',
                'customers.first_name',
                'total_amount',
                'invoices.date_time',
                'invoices.total_amount',
                'invoices.paid_amount'
            )
                ->join('customers', 'customers.code', '=', 'invoices.customer_code')
                ->where([
                    ['invoices.is_active', '=', 1],
                ])
                ->whereColumn(
                    'invoices.total_amount',
                    '>',
                    'invoices.paid_amount'
                )
                ->where(function ($query) use ($key) {
                    $query->Where('customers.code', '=', $key);
                })
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                ->get();
            return response()->Json(['status' => 200, 'invoices' => $invoices]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    /**
     * show
     *
     * Author: Aasif Saneeth
     * Date: 06.11.2023
     * Version : 3
     * Logic : Get invoice Detailssetteld by single payment Receipt
     * @param  mixed $id
     * @return void
     */
    public function show($id)
    {

        try {
            $invoice = Invoice::select(
                'code',
                'invoice_number',
                'invoice_source_code',
                'date_time',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'is_freeze',
                'total_amount',
                'paid_status',
                'pay_off',
                'is_freeze',
                'status',
                'prints',
                'billing_price',
                'received_amount',
                'remarks',
                'created_at',
                'created_by'
            )
                ->with([
                    'stockHistories' => function ($query) {
                        $query->select('*', 'quantity as oldQuantity')
                            ->where('is_active', '=', 1);
                    },
                    'stockHistories.stockHistoryExt' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistories.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistories.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistories.stock' => function ($query) {
                        $query->where('stocks.is_active', '=', 1);
                    },
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.route' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'salesReturns' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'paymentReceipts' => function ($query) {
                        // $query->where('invoice_payment_receipts.status', '<>', MultiPurposeStatus::REVERSED);
                    }
                ])
                ->with([
                    'salesQuotation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])  ->with([
                    'paymentReceipts.invoices' => function ($query) {
                        //$query->where('is_active', '=', 1);
                    }
                ])


                ->where('invoices.is_active', '=', 1)
                ->where('invoices.code', $id)
                ->first();

            $salesReturn = SalesReturn::select(
                'code',
                'invoice_code',
                'total_amount',
                'remarks',
                'customer_code',
                'total_amount',
                'return_date_time'
            )
                ->with([
                    'stockHistories' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('invoice_code', $id)
                ->get();

                $salesReturnItemGroupBy = [];

                // Iterate through the result and group by itemCode while summing the quantity
                foreach ($salesReturn as $item) {
                    foreach ($item->stockHistories as $history) {
                        $itemCode = $history->item_code;
                        $quantity = floatval($history->quantity);

                        if (isset($salesReturnItemGroupBy[$itemCode])) {
                            // If yes, add the quantity to the existing value
                            $salesReturnItemGroupBy[$itemCode] += $quantity;
                        } else {
                            // If no, create a new entry with the itemCode and quantity


                            $object1 = new ReturnValues($itemCode,$quantity);

                            $salesReturnItemGroupBy[] = $object1;


                        }
                    }
                }


                return response()->json(
                    [
                        'status' => 200,
                        'invoice' => $invoice,
                        'salesReturn' => $salesReturn,
                        'salesReturnItemGroupBy' => $salesReturnItemGroupBy
                    ]
                );
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }

    public function invoiceSearch($key)
    {
        try {
            $invoice = Invoice::select(
                'code',
                'invoice_number',
                'invoice_source_code',
                'date_time',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'total_amount',
                'prints',
                'paid_status',
                'received_amount',
                'created_by',
                'updated_by'
            )

                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockHistories.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                // ->with(['invoicePayment' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where([['is_active', '=', 1]])
                //->leftjoin('sales_reps', 'sales_reps.code', '=', 'customers.rep_code')

                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('invoice_number', 'like', "%$key%")
                        ->orWhere('customer_code', 'like', "%$key%")
                        ->orWhere('total_amount', 'like', "%$key%")
                        ->orWhereHas('customer', function ($query) use ($key) {
                            $query->where('first_name', 'like', "%$key%")
                            ->orwhere('phone_1', 'like', "%$key%")
                            ->orwhere('phone_2', 'like', "%$key%");
                        });
                        ;
                })
                ->get();
            return response()->json(['status' => 200, 'invoice' => $invoice]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function invoiceSearchForInsert($key)
    {
        try {
            $invoice = Invoice::select(
                'code',
                'invoice_number',
                'invoice_source_code',
                'date_time',
                'customer_code',
                'sales_quotation_code',
                'sales_order_code',
                'discount_amount',
                'discount_percentage',
                'bill_discount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'total_amount',
                'prints',
                'paid_status',
                'received_amount',
                'created_by',
                'updated_by'
            )

                ->with([
                    'stockHistories.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                // ->with(['invoicePayment' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                // ->with(['salesOrders' => function ($query) {
                //     $query->where('is_active', '=', 1);
                // }])
                ->where([['is_active', '=', 1]])
                //->leftjoin('sales_reps', 'sales_reps.code', '=', 'customers.rep_code')

                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('invoice_number', 'like', "%$key%")
                        ->orWhere('customer_code', 'like', "%$key%");
                })
                ->first();
            return $invoice;
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * itemPriceSearchLocationBased
     * Author: Suhail Jamaldeen
     * Date: 04.01.2023
     * Version: 01
     *
     * Author: Fathima Sajana
     * Date: 2023.02.02
     * Version: 02
     * Logic: Get the items based on the location and id
     * @param  mixed $request
     * @return void
     */

     public function itemPriceSearchLocationBased(Request $request)
     {
         $key = $request->key;
         $searchBy = $request->code;

      // try {
         $stockQuery = Stock::select(
             'code',
             'code as stockCode',
             'remaining_quantity',
             'wholesale_price',
             'retail_price',
             'cost_price',
             (DB::raw('stocks.remaining_quantity - stocks.order_quantity as availableQuantity')),
             'stock_location_code',
             'item_code',
             'is_freeze'
         )
         //->where('remaining_quantity', '>', 0)
         ->where('is_freeze', '=', 0)
         ->where('stock_location_code', '=', $request->header('LocationCode'))
         ->with([
             'itemMaster' => function ($query) {
                 $query->select(
                     'code',
                     'name',
                     'barcode',
                     'wholesale_price',
                     'retail_price',
                     'cost_price',
                     'discount',
                     'discount_price',
                     'description',
                     'category_code',
                     'brand_code',
                     'unit_code',
                     'is_service'
                 )->with([
                     'itemCategory' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])->with([
                     'itemBrand' => function ($query) {
                         $query->where('is_active', '=', 1);
                     }
                 ])


                 ->with([
                     'itemImages' => function ($query) {
                         $query->select('code', 'item_code', 'file_path')->where('is_active', '=', 1);
                     }
                 ])
                 ->with([
                     'stocks' => function ($query) {
                         $query->select(
                             'code',
                             'item_code',
                             'code as stockCode',
                             'remaining_quantity',
                             'wholesale_price',
                             'retail_price',
                             'cost_price',
                             'stock_location_code',
                         )->with([
                             'stockLocation' => function ($query) {}
                         ])
                         ->orderBy('stocks.code', 'DESC');
                     },
                     'itemUnit' => function ($query) {
                         $query->select(
                             'code',
                             'name',
                             'created_at'
                         )->where('is_active', '=', 1);
                     },
                     'itemImages' => function ($query) {
                         $query->select(
                             'code',
                             'item_code',
                             'file_path'
                         )->where('is_active', '=', 1);
                     }
                 ])
                 ->where('is_active', '=', 1)
                 ->orderBy('barcode', 'ASC');
             }
         ]);

         if ($searchBy == SearchBy::NAME) {
             $stockQuery->whereHas('itemMaster', function ($query) use ($key) {
                 $query->where('name', 'LIKE', '%' . $key . '%');
             });
         } else if($searchBy == SearchBy::CATEGORY  ) {

             $categoryCode = ItemCategory::where('name','like','%' . $key . '%')->pluck('code');

             $stockQuery->whereHas('itemMaster', function ($query) use ($categoryCode) {
             $query->whereIn('category_code', $categoryCode);
         });

         }else if($searchBy == SearchBy::BARND) {

             $brandCode = ItemBrand::where('name','like','%' . $key . '%')->pluck('code');

             $stockQuery->whereHas('itemMaster', function ($query) use ($brandCode) {
                 $query->where('brand_code', $brandCode );
             });
         }else if($searchBy == SearchBy::DESCRIPTION) {
                $stockQuery->whereHas('itemMaster', function ($query) use ($key) {
             $query->where('description', 'LIKE', '%' . $key . '%');
         });

         }
         else {
             $stockQuery->whereHas('itemMaster', function ($query) use ($key) {
                 $query->where('barcode', 'LIKE', '%' . $key . '%');
                 $query->orWhere('name', 'LIKE', '%' . $key . '%');
             });
         }

         $stock = $stockQuery->get();

         // if ($stock->isEmpty()) {
         //     return response()->json([
         //         'status' => 404,
         //         'message' => 'Item not found',
         //     ]);
         // }

         // if ($stock->first()->remaining_quantity <= 0) {
         //     return response()->json([
         //         'status' => 400,
         //         'message' => 'Item not in stock',
         //     ]);
         // }

             return response()->json([
                 'status' => 200,
                 'stock' => $stock,
             ]);
         // } catch (\Exception $e) {
         //     throw new Exception($e);
         // }
     }

     public function itemPriceSearchLocationBasedWithoutStock(Request $request)
    {
        try {
            $key = $request->key;
            $searchBy = $request->code;

            $itemQuery = ItemMaster::select(
                'code',
                'reference_code',
                'barcode',
                'name',
                'description',
                'category_code',
                'sub_category_code',
                'unit_code',
                'brand_code',
                // 'size_code',
                'color_code',
                'bin_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'discount_price',
                'discount',
                'model',
                'min_stock',
                'max_stock',
                'reorder_stock',
                'expiry_notification_days'
            )->with([
                'itemImages' => function ($query) {
                    $query->select('code', 'item_code', 'file_path')->where('is_active', '=', 1);
                }
            ])->with([
                'stocks' => function ($query) {
                    $query->where('is_active', '=', 1)
                          ->where('is_freeze', '=', 0);
                }
            ])->where([['is_active', '=', 1]]);

            if ($searchBy == SearchBy::NAME) {
                $itemQuery->where('name', 'LIKE', '%' . $key . '%');
            } elseif ($searchBy == SearchBy::CATEGORY) {
                $categoryCode = ItemCategory::where('name', 'like', '%' . $key . '%')->pluck('code');
                $itemQuery->whereIn('category_code', $categoryCode);
            } elseif ($searchBy == SearchBy::BARND) {
                $brandCode = ItemBrand::where('name', 'like', '%' . $key . '%')->pluck('code');
                $itemQuery->whereIn('brand_code', $brandCode);
            } elseif ($searchBy == SearchBy::DESCRIPTION) {
                $itemQuery->where('description', 'LIKE', '%' . $key . '%');
            } else {
                 $itemQuery->where('barcode', 'LIKE', '%' . $key . '%');
                $itemQuery->orWhere('name', 'LIKE', '%' . $key . '%');
            }

            $item = $itemQuery->orderBy('barcode', 'ASC')->get();

            return response()->json(['status' => 200, 'item' => $item]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function itemPriceSearchWareHouseLocation(Request $request)
    {
        $key = $request->key;
        try {
            $stock = Stock::select(
                'code',
                'code as stockCode',
                'remaining_quantity',
                'order_quantity',
                DB::raw('remaining_quantity - order_quantity AS availablequantity'),
                'wholesale_price',
                'retail_price',
                'cost_price',
                'stock_location_code',
                'item_code',
                'is_freeze'
            )
            ->whereRaw('remaining_quantity - order_quantity > 0')
            //->where([['remaining_quantity', '>', 0]]) //Comment if you don't want to display 0 remaining quantity
                //->orderBy('stocks.code', 'DESC')
                //->groupBy('item_code')
                ->where('is_freeze', '=', 0)
                ->where('stock_location_code', '=', '21510000003')
                ->with([
                    'itemMaster' => function ($query) {
                        $query->select(
                            'code',
                            'name',
                            'barcode',
                            'wholesale_price',
                            'retail_price',
                            'cost_price',
                            'description',
                            'unit_code',
                            'is_service'
                        )
                            ->with([
                                'stocks' => function ($query) {
                                    $query->select(
                                        'code',
                                        'item_code',
                                        'code as stockCode',
                                        'remaining_quantity',
                                        'order_quantity',
                                        DB::raw('remaining_quantity - order_quantity AS availablequantity'),
                                        //(DB::raw('SUM(stocks.remaining_quantity)as remaining_quantity')),
                                        'wholesale_price',
                                        'retail_price',
                                        'cost_price',
                                        'stock_location_code',
                                    )
                                        //->groupBy('item_code')
                                        ->orderBy('stocks.code', 'DESC');
                                }
                                ,
                                'itemUnit' => function ($query) {
                                    $query->select(
                                        'code',
                                        'name',
                                        'created_at'
                                    )->where('is_active', '=', 1);
                                },
                                'itemImages' => function ($query) {
                                    $query->select(
                                        'code',
                                        'item_code',
                                        'file_path'
                                    )->where('is_active', '=', 1);
                                }
                            ])
                            ->where('is_active', '=', 1);
                    }
                ])
                ->orderBy('stocks.code', 'DESC')
                ->whereHas('itemMaster', function ($query) use ($key) {
                    $query->where('name', 'LIKE', '%' . $key . '%')
                        ->orwhere('barcode', 'LIKE', '%' . $key . '%');

                })
                // ->orwhereHas('itemMaster', function ($query) use ($key) {
                //     $query->where('barcode', 'LIKE', '%' . $key . '%');
                // })

                ->get();

            return response()->json([
                'status' => 200,
                'stock' => $stock

            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function create()
    {
        //
    }


    /**
     * store
     * Author: Suhail Jamaldeen
     * Date: 03.12.2022
     * Version: 01
     * Logic: Stores the Invoice Details, stock History, mode of payment and
     * customer
     * ******************
     * Author: Suhail Jamaldeen
     * Date: 14.01.2023
     * Logic: Added stock code change. This effects for stock quotation
     * @param  mixed $request
     * @return void
     */
    public function store(Request $request)
    {
        // try {
            DB::beginTransaction();
            $invoice_code = TransactionCode::INVOICE_CODE;

            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr($stockLocationCode, -2);
            $SERIES_CODE = $request->seriesCode;
            //$series = substr($SERIES_CODE, -2);
            $max_code = Invoice::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->where('series_code', '=', $SERIES_CODE)
                ->max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 6) + 1;

            $invoice = Invoice::create([
                'code' => $invoice_code . $locationPrefix . $SERIES_CODE . $max_id,
                //'code' => $invoice_code . $locationPrefix . $max_id,
                'invoice_number' => $request->invoiceNumber,
                'stock_location_code' => getCurrentLocationCode($request),
                'series_code' => $SERIES_CODE,
                'invoice_source_code' => $request->invoiceSourceCode,
                'date_time' => getDateTimeNow(),
                //'date_time' => $request->date,
                'customer_code' => $request->customer ? $request->customer['code'] : DefaultValues::CUSTOMER_CODE,
               'sales_quotation_code' => $request->salesQuotation ? $request->salesQuotation['code'] : null,
                'sales_order_code' => $request->salesOrderCode ?? null,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'bill_discount' => $request->billDiscount,
                'discount_total' => $request->discountTotal,
                'paid_amount' => $request->paidAmount,
                'pay_off'=>0,
                'sub_total_amount' => $request->subTotalAmount,
                'total_amount' => $request->totalAmount,
                'paid_status' => $request->paidStatus,
                'prints' => 1,
                'billing_price' => $request->billingPrice,
                'is_locked' => $request->isLocked,
                'remarks' => $request->remarks,
                'received_amount' => $request->receivedAmount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            if ($invoice) {
                $stock_history = $request->stockHistories;
                if (count(($stock_history)) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $quantity = $stockHistory['quantity'];
                        $billingPrice = $request->billingPrice;
                        $discountPercentage = $stockHistory['discountPercentage'] ?? 0;
                        $discountAmount = $stockHistory['discountAmount'] ?? 0;


                        if($billingPrice == 0) // 0 for wholesale price
                        {
                        $stockHistory['subTotalAmount'] = $quantity * $stockHistory['retailPrice'];
                        $stockHistory['totalAmount'] = $stockHistory['retailPrice'] ? ($quantity * $stockHistory['retailPrice']) - (($quantity * $stockHistory['retailPrice']) * $discountPercentage / 100) - ($quantity *  $discountAmount) : 0;
                        $stockHistory['discountTotal'] = $stockHistory['retailPrice'] ? ($quantity *  $discountAmount) + (($quantity * $stockHistory['retailPrice']) *   $discountPercentage / 100) : 0;
                        $stockHistory['subTotalAmount'] = $quantity * $stockHistory['retailPrice'];
                        }

                        if($billingPrice == 1) // 1 for wholesale price
                        {
                            $stockHistory['subTotalAmount'] = $quantity * $stockHistory['wholesalePrice'];
                            $stockHistory['totalAmount'] = $stockHistory['wholesalePrice'] ? ($quantity * $stockHistory['wholesalePrice']) - (($quantity * $stockHistory['wholesalePrice']) * $discountPercentage / 100) - ($quantity *  $discountAmount) : 0;
                            $stockHistory['discountTotal'] = $stockHistory['wholesalePrice'] ? ($quantity *  $discountAmount) + (($quantity * $stockHistory['wholesalePrice']) *   $discountPercentage / 100) : 0;
                            $stockHistory['subTotalAmount'] = $quantity * $stockHistory['wholesalePrice'];
                        }


                        //Unit Sold Price is the amount per item after applying the discount
                        $stockHistory['unitSoldPrice'] = $stockHistory['totalAmount'] / $quantity;

                        $stock = $this->stock_function->getExistingStock($stockHistory['stockCode']);

                        if ($stock->stock_location_code == getCurrentLocationCode($request)) {
                            // Update remaining quantity
                            //( Update remaining quantity and subtract $quantity from order_quantity) in this, substract this order quantity when getCurrentLocationCode($request)==21510000003, when other location getCurrentLocationCode($request) = 21510000001 or 21510000001 will won't subtract that order_quantity and checking Orderquantiy has value only its going to subtract



                            $remainingQuantity = $stock->remaining_quantity - $quantity;


                            $stock->update([
                                'remaining_quantity' => $remainingQuantity,
                                'updated_by' => getUserCode(),
                                'updated_at' => getDateTimeNow()
                            ]);
                        }
                        if ($stock->stock_location_code == $stockLocationCode) {
                            // Update order quantity
                            // Update order quantity only if getCurrentLocationCode($request) is not '21510000003'
                            if (getCurrentLocationCode($request) != $stockLocationCode) {
                                $stock->update([
                                    'order_quantity' => ($stock->order_quantity) + $quantity,
                                    'updated_by' => getUserCode(),
                                    'updated_at' => getDateTimeNow()
                                ]);
                            }
                        }


                        $stockHistoryAdd = $this->stock_history_function->addStockHistoryForBulkInvoice($stockHistory, $invoice->code, StockHistorySource::INVOICE, $stock);

                    }
                }


                $salesOrder = $request->salesOrder;
                $orderQuantity = $stock->order_quantity;
                if($salesOrder){
                    $stockHistoryTemps = $salesOrder['stockHistoryTemps'];
                    foreach($stockHistoryTemps as $stockHistoryTemp){
                       $itemCode = $stockHistoryTemp['itemCode'];
                       $qty =  $stockHistoryTemp['quantity'];
                    }
                $orderQuantity = ( $stock->item_code == $itemCode ) ? $stock->order_quantity - $qty : $stock->order_quantity;
                }

                      $stock->update([
                        'order_quantity' =>  $orderQuantity,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()
                    ]);


                $customer = $request->customer;
                $modeOfPayments = $request->modeOfPayments;
                if ($request->paidAmount != 0) {
                    $this->payment_receipt_function_for_invoice->addPaymentReceipt($request, $modeOfPayments, $invoice);
                }
                else{// suhail sir, This is a credit bill. No payment receipt available

                    $customer = Customer::where('code', $invoice->customer_code)->first();
                    $customer->update([
                        'invoice_total' => $invoice->total_amount + $customer['invoice_total'],
                        'received_amount' => $invoice['paid_amount'] + $customer['received_amount'],
                        'credit_amount' => $customer['credit_amount'] - $request->settledAmount,
                        'credit_amount' => $invoice['paid_amount'] == 0 ? ($customer['credit_amount'] + $invoice['total_amount']) : $customer['credit_amount'] + ($invoice['total_amount'] - $invoice['paid_amount']),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }

            $savedInvoice = InvoiceTemps::where('code',$request->savedInvoiceCode);

            $savedInvoice->update([
                'status'=>MultiPurposeStatus::INVOICED
            ]);

            $salesOrder = SalesOrder::where('code', $request->salesOrder ? $request->salesOrder['code'] : null);
            $salesOrder->update([
                'status'=>MultiPurposeStatus::INVOICED
            ]);

            DB::commit();
            $invoiceCreated = $this->invoiceSearchForInsert($invoice->code);
            return response()->json([
                'status' => 200,
                'Invoice' => "Invoice created",
                'code' => $invoice->code,
                'submittedData' => $invoiceCreated,
                'date_time' => $invoice->date_time,
            ]);
        // } catch (\Exception $e) {
        //     DB::rollBack();
        //     throw new Exception($e);


        // }
    }

    /**
     * reversal
     * Author: fathima sajana
     * date: 2023.03.15
     * logic: invoice credit reversal
     * version: 01
     *
     * Author: fathima sajana
     * date: 2023.10.18
     * logic: invoice reversal
     * version: 02
     *
     * Author: Suhail Jamaldeen
     * Version: 03
     * Logic: If an invoice is fully paid by more then one payment receipt, the invoice cannot be reversed.
    * An invoice can be reversed when a bill is a credit bill.
    * An invoice can be reversed when a bill is fully paid via one paymnet receipt and that receipt is only paid to this invoice and not paid to any other invoice.
     * An invoice can be reversed when a bill is partially paid by one receipt and that receipt is only paid to this invoice and not paid to any other invoice.
     * @param  mixed $request
     * @return void
     */
    public function reversal(Request $request)
    {
        try {
            DB::beginTransaction();

            $invoiceCode = $request->transactionCode;

            $invoice = Invoice::where('code', '=', $invoiceCode)
                ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
                //->where('status', '<>', MultiPurposeStatus::REVERSED)
                //->where('paid_status', '=', 3)
                ->first();

            if ($invoice->paid_status == PaymentStatus::PAYMENT_COMPLETED && $invoice->status <> MultiPurposeStatus::REVERSED) {
                //if ($invoice) {

                $invoicePaymentReceipt = InvoicePaymentReceipt::where('invoice_code', '=', $invoice->code)
                    ->where('is_active', '=', 1)->get();

                if (count($invoicePaymentReceipt) > 1) {
                    return response()->json([
                        'status' => 200,
                        'invoiceCode' => $invoice->code,
                        'message' => 'There have ' . count($invoicePaymentReceipt) . ' payment receipts for this invoice ' . $invoice->code
                    ]);
                }

                $stock_history = StockHistory::where('source_code', '=', $invoiceCode)
                ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
                ->get();

                if (count($stock_history) > 0) {
                foreach ($stock_history as $stockHistory) {

                    // if (isset($stockHistory['code']) && isset($stockHistory['stockCode'])) {
                    //     $stock = Stock::select('id', 'code', 'item_code', 'stock_location_code', 'remaining_quantity')
                    //         ->where('code', '=', $stockHistory['stockCode'])
                    //         ->first();

                    $itemCode = $stockHistory->itemCode ?: $stockHistory->itemMaster->code;
                    $stock = Stock::where('item_code', '=', $itemCode)->first();

                    if ($stock) {
                        $stockHistoryQuantity = ($stockHistory->quantity);
                        $stockQuantity = ($stock->remaining_quantity);
                        if (StockHistorySource::INVOICE) {
                            $stockQuantityUp = $stockQuantity + ($stockHistoryQuantity);
                        }

                        $stock->update([
                            'remaining_quantity' => $stockQuantityUp,
                            'updated_by' => getUserCode(),

                            'updated_at' => getDateTimeNow(),
                        ]);
                    }
                    // else {
                    //     $stock = $this->stock_function->getExistingStock($stockHistory['stockCode']);
                    //     $remainingQuantity = ($stock->remaining_quantity + $stockHistory['quantity']);
                    //     $stock->update([
                    //         'remaining_quantity' => $remainingQuantity,
                    //         'updated_by' => getUserCode(),
                    //         'updated_at' => getDateTimeNow()
                    //     ]);
                    // }

                    //}
                }
            }

                foreach ($invoicePaymentReceipt as $invoice_payment_receipt) {

                    $invoice = Invoice::where('code', $invoice_payment_receipt['invoice_code'])
                        ->first();

                    if ($invoice) {
                        $totalPaidAmount = $invoice['paid_amount'] - $invoice_payment_receipt['paid_amount'];

                        $invoice->update([
                            'paid_amount' => $totalPaidAmount,
                            'status' => MultiPurposeStatus::REVERSED,
                            'paid_status' => PaymentStatus::PAYMENT_NOT_DONE,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }
                    $invoice_payment_receipt->update([
                        'status' => MultiPurposeStatus::REVERSED,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),

                    ]);
                    //$paymentReceipt = null; // Initialize $paymentReceipt

                    $paymentReceipt = PaymentReceipt::where('code', '=', $invoice_payment_receipt['payment_receipt_code'])
                        ->where('status', '<>', MultiPurposeStatus::REVERSED)
                        ->where('is_active', '=', 1)->first();
                    if ($paymentReceipt) {
                        $paymentReceipt->update([
                            'status' => MultiPurposeStatus::REVERSED,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }

                    $modeOfPayment = ModeOfPayment::where('payment_receipt_code', '=', $invoice_payment_receipt['payment_receipt_code'])
                        ->where('is_active', '=', 1)->get();
                    $return = 0;
                    $over = 0;

                    if (count($modeOfPayment) > 0) {
                        foreach ($modeOfPayment as $mode_of_payment) {
                            $mode_of_payment->update([
                                'status' => MultiPurposeStatus::REVERSED,
                                'updated_by' => getUserCode(),
                                'updated_at' => getDateTimeNow()
                            ]);

                            $paymentType = $mode_of_payment->payment_type_code;
                            switch ($paymentType) {
                                case PaymentTypeCode::CASH_PAYMENT_CODE:
                                    CashPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    break;

                                case PaymentTypeCode::OVER_PAYMENT_CODE:
                                    OverPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'amount' => $mode_of_payment['amount'],
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    $overPmnt = OverPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->first();
                                    $over = $over + $overPmnt['amount'];
                                    break;

                                case PaymentTypeCode::RETURN_AMOUNT_CODE:
                                    ReturnAmount::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'amount' => $mode_of_payment['amount'],
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    $returnAmnt = ReturnAmount::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->first();
                                    $return = $return + $returnAmnt['amount'];
                                    break;

                                case PaymentTypeCode::CARD_PAYMENT_CODE:
                                    CardPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    break;

                                case PaymentTypeCode::CHEQUE_PAYMENT_CODE:
                                    ChequePayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    break;

                                case PaymentTypeCode::BANK_PAYMENT_CODE:
                                    BankPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    break;

                                case PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE:
                                    OnlineTransferPayment::where('mode_of_payment_code', $mode_of_payment->code)
                                        ->update([
                                            'status' => MultiPurposeStatus::REVERSED,
                                            'updated_by' => getUserCode(),
                                            'updated_at' => getDateTimeNow(),
                                        ]);
                                    break;
                                default:
                                    # code...
                                    break;
                            }
                        }

                        if ($paymentReceipt) {
                            // Check if 'settled_amount' exists before accessing it
                            if (isset($paymentReceipt['settled_amount'])) {
                                $customer = Customer::where('code', $invoice->customer_code, $mode_of_payment->payment_receipt_code)
                                    ->first();
                                if ($customer) {
                                    $customer->update([
                                        'invoice_total' => (($customer['invoice_total'] - $invoice['total_amount'])),
                                        //'credit_amount' => $customer['credit_amount'] + $paymentReceipt->settled_amount,
                                        'received_amount' => ($over + $return) == 0 ? $customer['received_amount'] - $paymentReceipt->total_amount : $customer['received_amount'] - ($paymentReceipt->total_amount - ($over + $return)),
                                        'over_payment' => $customer['over_payment'] ? ($customer['over_payment'] + $over) - $paymentReceipt->over_payment : $customer['over_payment'] - $paymentReceipt->over_payment,
                                        'return_amount' => $customer['return_amount'] + $return,
                                        'updated_by' => getUserCode(),
                                        'updated_at' => getDateTimeNow()
                                    ]);
                                }
                            }
                        }

                    }

                }


                // if ($invoice->customer_code != DefaultValues::CUSTOMER_CODE) {
                //     $customer = Customer::where('code', $invoice->customer_code)->first();
                //     $customer->update([
                //         'invoice_total' => (($customer['invoice_total'] - $invoice['total_amount'])),
                //        // 'credit_amount' => $customer['credit_amount'] - (($invoice->total_amount) - ($invoice->paid_amount)),
                //         'updated_by' => getUserCode(),
                //         'updated_at' => getDateTimeNow(),
                //     ]);
                // }

                // $invoice->update([
                //     'status' => MultiPurposeStatus::REVERSED,
                //     'updated_by' => getUserCode(),
                //     'updated_at' => getDateTimeNow(),
                // ]);
            } elseif ($invoice->paid_status == PaymentStatus::PAYMENT_NOT_DONE && $invoice->status <> MultiPurposeStatus::REVERSED) {
                $stock_history = StockHistory::where('source_code', '=', $invoiceCode)
                    ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
                    ->get();

                if (count($stock_history) > 0) {
                    foreach ($stock_history as $stockHistory) {

                        // if (isset($stockHistory['code']) && isset($stockHistory['stockCode'])) {
                        //     $stock = Stock::select('id', 'code', 'item_code', 'stock_location_code', 'remaining_quantity')
                        //         ->where('code', '=', $stockHistory['stockCode'])
                        //         ->first();

                        $itemCode = $stockHistory->itemCode ?: $stockHistory->itemMaster->code;
                        $stock = Stock::where('item_code', '=', $itemCode)->first();

                        if ($stock) {
                            $stockHistoryQuantity = ($stockHistory->quantity);
                            $stockQuantity = ($stock->remaining_quantity);
                            if (StockHistorySource::INVOICE) {
                                $stockQuantityUp = $stockQuantity + ($stockHistoryQuantity);
                            }

                            $stock->update([
                                'remaining_quantity' => $stockQuantityUp,
                                'updated_by' => getUserCode(),
                                'updated_at' => getDateTimeNow(),
                            ]);
                        }
                        // else {
                        //     $stock = $this->stock_function->getExistingStock($stockHistory['stockCode']);
                        //     $remainingQuantity = ($stock->remaining_quantity + $stockHistory['quantity']);
                        //     $stock->update([
                        //         'remaining_quantity' => $remainingQuantity,
                        //         'updated_by' => getUserCode(),
                        //         'updated_at' => getDateTimeNow()
                        //     ]);
                        // }

                        //}
                    }
                }
                $invoice->update([
                    'status' => MultiPurposeStatus::REVERSED,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);

                if ($invoice->customer_code != DefaultValues::CUSTOMER_CODE) {
                    $customer = Customer::where('code', $invoice->customer_code)->first();
                    $customer->update([
                        'invoice_total' => (($customer['invoice_total'] - $invoice['total_amount'])),
                        'credit_amount' => $customer['credit_amount'] - (($invoice->total_amount) - ($invoice->paid_amount) - ($invoice->pay_off) ),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'Invoice Code - ' . $invoiceCode . ' Not Found'
                ]);
            }

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Invoice Reversed",
                'code' => $invoice->code,
                'dateTime' => $invoice->date_time,
            ], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }

    }

    public function edit($id)
    {
        //
    }

    //Calling, when Invoice Edit
    /**
     * update
     * Author : Fathima Sajana
     * Date : 2022.11.11
     * Version : 2
     *
     *
     * Author: Suhail Jamaldeen
     * DateL 02.10.2023
     * Version: 03
     * Logic: Rechecking the logic for update.
     * @param  mixed $request
     * @param  mixed $id
     * @return void
     */
    public function update(Request $request, $id)
    {

        try {
            DB::beginTransaction();

            $invoice = Invoice::where('code', $id)
                ->first();
            if ($invoice) {
                //Get the existung customer and revert his values
                $customerExisting = Customer::where('code', $invoice->customer_code)
                    ->first();
                $customerExisting->update([
                    'invoice_total' => (($customerExisting['invoice_total'] - $invoice['total_amount'])),
                    // when newly start this function for changing customer (already existing invoice customer) , call this one for reducing credit balance from that custoemr
                    'credit_amount' => $customerExisting['credit_amount'] - (($invoice->total_amount) - ($invoice->paid_amount)),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);


                $invoice->update([
                    'invoice_number' => $request->invoiceNumber,
                    'invoice_source_code' => $request->invoiceSourceCode,
                    'customer_code' => $request->customer['code'] ?? null,
                    'sales_quotation_code' => $request->salesQuotationCode ?? null,
                    'sales_order_code' => $request->salesOrderCode ?? null,
                    'discount_amount' => $request->discountAmount,
                    'discount_percentage' => $request->discountPercentage,
                    'bill_discount' => $request->billDiscount,
                    // 'date' => getDateTimeNow(), No need to update during the invoice edit
                    'discount_total' => $request->discountTotal,
                    'paid_amount' => $request->paidAmount,
                    'sub_total_amount' => $request->subTotalAmount,
                    'total_amount' => $request->totalAmount,
                    'paid_status' => $request->paidStatus,
                    'prints' => $request->prints,
                    'is_locked' => $request->isLocked,
                    'billing_price' => $request->billingPrice,
                    'remarks' => $request->remarks,
                    'received_amount' => $request->receivedAmount,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow()
                ]);

                $stock_history = $request->stockHistories;
                if (count($stock_history) > 0) {
                    foreach ($stock_history as $stockHistory) {
                        $billingPrice = $request->billingPrice;

                         if($billingPrice == 0) // 0 for retail price
                        {
                        $stockHistory['subTotalAmount'] = $stockHistory['quantity'] > 0 ? $stockHistory['retailPrice'] ? ($stockHistory['quantity'] * $stockHistory['retailPrice']) : 0 : 0;
                        $stockHistory['totalAmount'] = $stockHistory['quantity'] > 0 ? $stockHistory['retailPrice'] ? ($stockHistory['quantity'] * $stockHistory['retailPrice']) - (($stockHistory['quantity'] * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) - ($stockHistory['quantity'] * $stockHistory['discountAmount']) : 0 : 0;
                        $stockHistory['discountTotal'] = $stockHistory['quantity'] > 0 ? $stockHistory['retailPrice'] ? ($stockHistory['quantity'] * $stockHistory['discountAmount']) + (($stockHistory['quantity'] * $stockHistory['retailPrice']) * $stockHistory['discountPercentage'] / 100) : 0 : 0;
                        }

                        if($billingPrice == 1) // 1 for wholesale price
                        {
                            $stockHistory['subTotalAmount'] = $stockHistory['quantity'] > 0 ? $stockHistory['wholesalePrice'] ? ($stockHistory['quantity'] * $stockHistory['wholesalePrice']) : 0 : 0;
                            $stockHistory['totalAmount'] = $stockHistory['quantity'] > 0 ? $stockHistory['wholesalePrice'] ? ($stockHistory['quantity'] * $stockHistory['wholesalePrice']) - (($stockHistory['quantity'] * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) - ($stockHistory['quantity'] * $stockHistory['discountAmount']) : 0 : 0;
                            $stockHistory['discountTotal'] = $stockHistory['quantity'] > 0 ? $stockHistory['wholesalePrice'] ? ($stockHistory['quantity'] * $stockHistory['discountAmount']) + (($stockHistory['quantity'] * $stockHistory['wholesalePrice']) * $stockHistory['discountPercentage'] / 100) : 0 : 0;
                        }

                        //Unit Sold Price is the amount per item after applying the discount
                        $stockHistory['unitSoldPrice'] = $stockHistory['quantity'] > 0 ? $stockHistory['totalAmount'] / $stockHistory['quantity'] : 0;
                        $stock = $this->stock_history_function->stockResetInvoice($request, $stockHistory, StockHistorySource::INVOICE, $invoice);
                        //$this->stock_history_function->updateStockHistory($stockHistory, $invoice->code, StockHistorySource::INVOICE, $stock);
                    }
                }

                $modeOfPayments = $request->modeOfPayments;

                if ($request->paidAmount != 0) {
                    $this->payment_receipt_function_for_invoice->addPaymentReceipt($request, $modeOfPayments, $invoice);
                }

                if ($invoice->customer_code != DefaultValues::CUSTOMER_CODE) {
                    $customer = Customer::where('code', $invoice->customer_code)->first();
                    $customer->update([
                        // calling this credit balance for newly changed customer (from existing customer to updated customer), this customer alredy had credit balance adding new amount through this credit_amount , if it is not call other fuction ($invoice->total_amount - $invoice->paid_amount)
                        //'credit_amount' => ($invoice->total_amount - $invoice->paid_amount) > 0 ? $customer['credit_amount'] + ($invoice->total_amount - $invoice->paid_amount) : $customer['credit_amount'],
                        'credit_amount' => $customer['credit_amount'] ? ($customer['credit_amount'] + ($invoice->total_amount - $invoice->paid_amount)) : ($invoice->total_amount - $invoice->paid_amount),
                        'invoice_total' => (($customer['invoice_total'] + $invoice['total_amount'])),
                        //'return_amount' => (($customer['return_amount'] + $invoice['total_amount'])),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }

            $invoiceCreated = $this->invoiceSearchForInsert($invoice->code);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Invoice Updated",
                'code' => $invoice->code,
                'date_time' => $invoice->date_time,
                'submittedData'=> $invoiceCreated,
            ], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function destroy($id)
    {
        try {
            $invoice = Invoice::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $invoice->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Invoice- Deleted"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
    public function sms(Request $request)
    {
        // try {
            DB::beginTransaction();
            $stockLocationCode = getCurrentLocationCode($request);
            $invoiceCode = $request->invoiceCode;

           $invoice  = Invoice::select(
            'code',
            'invoice_number',
            'invoice_source_code',
            'date_time',
            'customer_code',
            'sales_quotation_code',
            'sales_order_code',
            'discount_amount',
            'discount_percentage',
            'bill_discount',
            'discount_total',
            'paid_amount',
            'sub_total_amount',
            'total_amount',
            'paid_status',
            'prints',
            'phone_2',
            'received_amount',
            'created_at',
           )
           ->with([
            'customer' => function ($query) {
                $query->where('is_active', '=', 1);
            },
            'customer.route' => function ($query) {
                $query->where('is_active', '=', 1);
            },
            'customer.route.salesRep' => function ($query) {
                $query->where('is_active', '=', 1);
            },

        ])
        ->with([
            'paymentReceipts' => function ($query) {
                // $query->where('is_active', '=', 1);
            },
        ])
            ->where('code', $invoiceCode)
            ->first();

            $paymentReceipt =  $invoice->paymentReceipts;

            foreach($paymentReceipt as $receipt) {
               $settledAmount =  $receipt['settled_amount'];
               $totalAmount = $receipt['total_amount'];
               $outStanding = $receipt['total_amount'] -  $receipt['settled_amount'];
            }


            $sendSms = $invoiceCode['smsStatus'] ?? false;
            if ($sendSms == true) {
                $this->sms_function->InvoiceSMS($invoice->customer, $invoice,$invoiceCode);
            }
            $moreOfSms = $invoiceCode['moreSmsStatus']?? false;
            if ($moreOfSms == true) {
                $this->sms_function->MoreOfPaymentSMS($invoice->customer, $invoice,$settledAmount);
            }


            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Invoice- sms send",
                // 'setteledAmount'=> $settledAmount,
                // 'outStanding' => $outStanding,
                // 'customername'=>$invoice->customer->first_name,
                // 'invoiceCode'=>$invoice->code,
                // 'totalAmounts'=>$invoice->total_amount,
                // 'Outstanding'=>$invoice->customer->credit_amount,
                // 'phone_2'=>$invoice->phone_2,
                // 'phone_1'=>$invoice->customer->phone_2,
                // 'new'=> $invoiceCode['smsStatus'],
                // 'day' =>$invoiceCode['moreSmsStatus'],
            ]);
        // } catch (\Exception $e) {
        //     DB::rollBack();
        //     throw new Exception($e);
        // }
    }
}

