<?php

namespace App\Http\Controllers\General_Ledger_Controllers;

use App\Enums\DayEndSourceValues;
use App\Enums\EntryType;
use App\Enums\LedgerType;
use App\Enums\TransactionCode;
use App\Enums\TransactionMode;
use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccClosingBalance;
use App\Models\AccountTransaction_Models\AccGeneralLedger;
use App\Models\AccountTransaction_Models\AccTransaction;
use App\Models\AccountTransaction_Models\ClosingBalance;
use App\Models\Expense_Models\Expense;
use App\Models\GeneralLedger_Model\GeneralLedger;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GeneralLedgerController extends Controller
{
    public function index(Request $request)
    {
        try {
            $GeneralLedger = AccGeneralLedger::select(
                'code',
                'source_code',
                'stock_location_code',
                'amount'
            )

                ->where('is_active', '=', 1)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();

            return response()->json([
                'status' => 200,
                'GeneralLedger' => $GeneralLedger
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function store(Request $request)
    {


        try {
            DB::beginTransaction();
            $fromDate = $request->date;
            $toDate = $request->toDate;
            $stockLocationCode = getCurrentLocationCode($request);

            $general_Ledger_code = TransactionCode::DAY_END_CODE;
            $locationPrefix = substr($stockLocationCode, -2);

            $existingGeneralLedger = AccClosingBalance::where('stock_location_code', '=', $stockLocationCode)
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $fromDate)
                ->update(['is_active' => 0]);


            if ($existingGeneralLedger) {
                return response()->json([
                    'status' => 200,
                    'GeneralLedger' => $existingGeneralLedger
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'GeneralLedger' => 'No'
                ]);
            }
            GeneralLedger::where('stock_location_code', '=', $stockLocationCode)
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $fromDate)
                ->update(['is_active' => 0]);



            // $oldLedgers = GeneralLedger::select('code')
            //     ->where('ledger_date', '=', $fromDate)
            //     ->where('stock_location_code', '=', $stockLocationCode)
            //     ->get();

            // return $oldLedgers;
            $payment_receipts = 'SELECT (IFNULL(sum(settled_amount),0))AS settled_total FROM payment_receipts WHERE (payment_receipts.status <> 5  AND stock_location_code = ' . $stockLocationCode . ' AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';
            $payment_receipts = DB::select($payment_receipts);
            //     return $payment_receipts1[0]->receipt_total;

            //     return response()->json(['status' => 200,         
            //     'payment_receipt_total'=>$payment_receipts,
            // ], 200);

            if ($payment_receipts) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;

                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::PAYMENT_RECEIPT,
                    'stock_location_code' => $stockLocationCode,
                    'amount' => $payment_receipts[0]->settled_total,
                    'ledger_date' => $fromDate,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);

            }

            $cash_payment = 'SELECT IFNULL(sum(cash_payments.amount),0)AS cash_total, stock_location_code, stock_locations.name FROM payment_receipts 
        JOIN cash_payments on cash_payments.receipt_code = payment_receipts.code
        JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
        WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cash_payments.status <> 5  AND ( STR_TO_DATE(cash_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $cash_payment = DB::select($cash_payment);
            if (count($cash_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::CASH_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $cash_payment[0]->cash_total,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::DEBIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }
            $cheque_payment = 'SELECT IFNULL(sum(cheque_payments.amount),0)AS cheque_total, stock_location_code, stock_locations.name FROM payment_receipts 
        JOIN cheque_payments on cheque_payments.receipt_code = payment_receipts.code
        JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
        WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cheque_payments.status <> 5  AND ( STR_TO_DATE(cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $cheque_payment = DB::select($cheque_payment);
            if (count($cheque_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::CHEQUE_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $cheque_payment[0]->cheque_total,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::DEBIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            $card_payment = 'SELECT IFNULL(sum(card_payments.amount),0)AS card_total, stock_location_code, stock_locations.name FROM payment_receipts 
        JOIN card_payments on card_payments.receipt_code = payment_receipts.code
        JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
        WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND card_payments.status <> 5  AND ( STR_TO_DATE(card_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $card_payment = DB::select($card_payment);
            if (count($card_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::CARD_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $card_payment[0]->card_total,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CREDIT_CARD,
                    'entry_type' => EntryType::DEBIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            $bank_payment = 'SELECT IFNULL(sum(bank_payments.amount),0)AS bank_amount, stock_location_code, stock_locations.name FROM payment_receipts 
        JOIN bank_payments on bank_payments.receipt_code = payment_receipts.code
        JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
        WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND bank_payments.status <> 5  AND ( STR_TO_DATE(bank_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $bank_payment = DB::select($bank_payment);
            if (count($bank_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::BANK_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $bank_payment[0]->bank_amount,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::BANK,
                    'entry_type' => EntryType::DEBIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }


            //     $return_amount = 'SELECT IFNULL(sum(return_amounts.amount),0)AS return_amount, stock_location_code, stock_locations.name FROM payment_receipts 
            // JOIN return_amounts on return_amounts.receipt_code = payment_receipts.code
            // JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            // WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND return_amounts.status <> 5  AND ( STR_TO_DATE(return_amounts.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            //     //$return_amount = 'SELECT IFNULL(sum(amount),0)AS return_amount FROM return_amounts WHERE (return_amounts.status <> 5 AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
            //     $return_amount = DB::select($return_amount);
            //     if (count($return_amount) > 0) {


            //         $max_code = GeneralLedger::select('code')
            //             ->where('stock_location_code', '=', $stockLocationCode)
            //             ->max('code');
            //         $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
            //         $generalLedger = GeneralLedger::create([
            //             'code' => $general_Ledger_code . $locationPrefix . $max_id,
            //             'source_code' => DayEndSourceValues::RETURN_AMOUNT,
            //             'stock_location_code' => getCurrentLocationCode($request),
            //             'amount' => $return_amount[0]->return_amount,
            //             'created_by' => getUserCode(),
            //             'created_at' => getDateTimeNow(),
            //             'updated_by' => getUserCode(),
            //             'updated_at' => getDateTimeNow(),
            //         ]);
            //     }

            //     $over_payment = 'SELECT IFNULL(sum(over_payments.amount),0)AS over_payment, stock_location_code, stock_locations.name FROM payment_receipts 
            // JOIN over_payments on over_payments.receipt_code = payment_receipts.code
            // JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            // WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND over_payments.status <> 5  AND ( STR_TO_DATE(over_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            //     $over_payment = 'SELECT IFNULL(sum(amount),0)AS over_payment FROM over_payments WHERE (over_payments.status <> 5 AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';
            //     $over_payment = DB::select($over_payment);
            //     if (count($over_payment) > 0) {


            //         $max_code = GeneralLedger::select('code')
            //             ->where('stock_location_code', '=', $stockLocationCode)
            //             ->max('code');
            //         $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
            //         $generalLedger = GeneralLedger::create([
            //             'code' => $general_Ledger_code . $locationPrefix . $max_id,
            //             'source_code' => DayEndSourceValues::OVER_PAYMENT,
            //             'stock_location_code' => getCurrentLocationCode($request),
            //             'amount' => $over_payment[0]->over_payment,
            //             'created_by' => getUserCode(),
            //             'created_at' => getDateTimeNow(),
            //             'updated_by' => getUserCode(),
            //             'updated_at' => getDateTimeNow(),
            //         ]);
            //     }


            $expense_amount = Expense::select(
                'expenses.code',
                'total_amount',
                'expense_types.name AS expense_type',
                'expense_categories.name AS expense_category'
            )
                ->join('expense_types', 'expense_types.code', '=', 'expenses.expense_type_code')
                ->join('expense_categories', 'expense_categories.code', '=', 'expenses.expense_category_code')
                ->join('stock_locations', 'stock_locations.code', '=', 'expenses.stock_location_code')
                ->where('expenses.is_active', '=', 1)
                ->where('expenses.stock_location_code', '=', $stockLocationCode)
                ->whereBetween('payment_date', [date('Y-m-d H:m:s', strtotime($fromDate) - 1), date('Y-m-d H:m:s', strtotime($toDate))])
                ->get();
            if (count($expense_amount) > 0) {
                foreach ($expense_amount as $expenseAmount) {


                    $max_code = GeneralLedger::select('code')
                        ->where('stock_location_code', '=', $stockLocationCode)
                        ->max('code');
                    $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                    $generalLedger = GeneralLedger::create([
                        'code' => $general_Ledger_code . $locationPrefix . $max_id,
                        'source_code' => DayEndSourceValues::EXPENSE_AMOUNT,
                        'stock_location_code' => getCurrentLocationCode($request),
                        'amount' => $expenseAmount->total_amount,
                        'ledger_date' => $fromDate,
                        'ledger_type' => LedgerType::CASH,
                        'entry_type' => EntryType::CREDIT,
                        'transaction_type' => TransactionMode::CASH,
                        // 'is_debit' => 1,
                        'created_by' => getUserCode(),
                        'created_at' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
            }


            $payment_vouchers = 'SELECT IFNULL(sum(settled_amount),0)AS payment_voucher_settled FROM payment_vouchers WHERE (payment_vouchers.status <> 5 AND stock_location_code = ' . $stockLocationCode . ' AND( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';
            $payment_voucher_total = DB::select($payment_vouchers);
            if (count($payment_voucher_total) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::PAYMENT_VOUCHER,
                    'stock_location_code' => getCurrentLocationCode($request),
                    // 'is_debit' => 1,
                    'amount' => $payment_voucher_total[0]->payment_voucher_settled,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::CREDIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            $supplier_cash_payment = 'SELECT IFNULL(sum(supplier_cash_payments.amount),0)AS supplier_cash_total, stock_location_code, stock_locations.name FROM payment_vouchers 
        JOIN supplier_cash_payments on supplier_cash_payments.voucher_code = payment_vouchers.code
        JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
        WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_cash_payments.status <> 5  AND ( STR_TO_DATE(supplier_cash_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            // $supplier_cash_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_cash_total FROM supplier_cash_payments WHERE (supplier_cash_payments.status <> 5 AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "'. $fromDate . '" AND "' . $toDate . '"))';
            $supplier_cash_payment = DB::select($supplier_cash_payment);
            if (count($supplier_cash_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::SUPPLIER_CASH_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    // 'is_debit' => 1,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::CREDIT,
                    'transaction_type' => TransactionMode::CASH,
                    'amount' => $supplier_cash_payment[0]->supplier_cash_total,
                    'ledger_date' => $fromDate,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }


            $supplier_cheque_payment = 'SELECT IFNULL(sum(supplier_cheque_payments.amount),0)AS supplier_cheque_total, stock_location_code, stock_locations.name FROM payment_vouchers 
        JOIN supplier_cheque_payments on supplier_cheque_payments.voucher_code = payment_vouchers.code
        JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
        WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_cheque_payments.status <> 5  AND ( STR_TO_DATE(supplier_cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $supplier_cheque_payment = DB::select($supplier_cheque_payment);
            if (count($supplier_cheque_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::SUPPLIER_CHEQUE_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $supplier_cheque_payment[0]->supplier_cheque_total,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::CREDIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            $supplier_card_payment = 'SELECT IFNULL(sum(supplier_card_payments.amount),0)AS supplier_card_total, stock_location_code, stock_locations.name FROM payment_vouchers 
        JOIN supplier_card_payments on supplier_card_payments.voucher_code = payment_vouchers.code
        JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
        WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_card_payments.status <> 5  AND ( STR_TO_DATE(supplier_card_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $supplier_card_payment = DB::select($supplier_card_payment);
            if (count($supplier_card_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::SUPPLIER_CARD_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'ledger_date' => $fromDate,
                    'amount' => $supplier_card_payment[0]->supplier_card_total,
                    'ledger_type' => LedgerType::CREDIT_CARD,
                    'entry_type' => EntryType::CREDIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            $supplier_bank_payment = 'SELECT IFNULL(sum(supplier_bank_payments.amount),0)AS supplier_bank_total, stock_location_code, stock_locations.name FROM payment_vouchers 
        JOIN supplier_bank_payments on supplier_bank_payments.voucher_code = payment_vouchers.code
        JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
        WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_bank_payments.status <> 5  AND ( STR_TO_DATE(supplier_bank_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';

            $supplier_bank_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_bank_total FROM supplier_bank_payments WHERE (supplier_bank_payments.status <> 5 AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '" ))';
            $supplier_bank_payment = DB::select($supplier_bank_payment);
            if (count($supplier_bank_payment) > 0) {


                $max_code = GeneralLedger::select('code')
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
                $generalLedger = GeneralLedger::create([
                    'code' => $general_Ledger_code . $locationPrefix . $max_id,
                    'source_code' => DayEndSourceValues::SUPPLIER_BANK_PAYMENT,
                    'stock_location_code' => getCurrentLocationCode($request),
                    'amount' => $supplier_bank_payment[0]->supplier_bank_total,
                    'ledger_date' => $fromDate,
                    'ledger_type' => LedgerType::CASH,
                    'entry_type' => EntryType::CREDIT,
                    'transaction_type' => TransactionMode::CASH,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }

            // $purchase_return = 'SELECT IFNULL(sum(total_amount),0)AS purchase_return_total FROM purchase_returns WHERE (stock_location_code = ' . $stockLocationCode . ' AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';
            // $purchase_return = DB::select($purchase_return);
            // if (count($purchase_return) > 0) {


            //     $max_code = GeneralLedger::select('code')
            //         ->where('stock_location_code', '=', $stockLocationCode)
            //         ->max('code');
            //     $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
            //     $generalLedger = GeneralLedger::create([
            //         'code' => $general_Ledger_code . $locationPrefix . $max_id,
            //         'source_code' => DayEndSourceValues::PURCHASE_RETURN,
            //         'stock_location_code' => getCurrentLocationCode($request),
            //         'amount' => $purchase_return[0]->purchase_return_total,
            //         'created_by' => getUserCode(),
            //         'created_at' => getDateTimeNow(),
            //         'updated_by' => getUserCode(),
            //         'updated_at' => getDateTimeNow(),
            //     ]);
            // }


            // $sales_return = 'SELECT IFNULL(sum(total_amount),0)AS sales_return_total FROM sales_returns WHERE (stock_location_code = ' . $stockLocationCode . ' AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromDate . '" AND "' . $toDate . '"))';
            // $sales_return = DB::select($sales_return);
            // if (count($sales_return) > 0) {


            //     $max_code = GeneralLedger::select('code')
            //         ->where('stock_location_code', '=', $stockLocationCode)
            //         ->max('code');
            //     $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;
            //     $generalLedger = GeneralLedger::create([
            //         'code' => $general_Ledger_code . $locationPrefix . $max_id,
            //         'source_code' => DayEndSourceValues::SALES_RETURN,
            //         'stock_location_code' => getCurrentLocationCode($request),
            //         'amount' => $sales_return[0]->sales_return_total,
            //         'is_debit' => 1,
            //         'created_by' => getUserCode(),
            //         'created_at' => getDateTimeNow(),
            //         'updated_by' => getUserCode(),
            //         'updated_at' => getDateTimeNow(),
            //     ]);
            // }

            // Working on custom transaction



            //

            $account_transaction = AccTransaction::select(
                'acc_transactions.code as source_code',
                'entry_types.code',
                'amount',
                'entry_types.name AS acc_transaction_type',
                'entry_types.ledger_type',
                'entry_types.entry_type',
                'entry_types.transaction_mode',
                'entry_types.acc_ledger_type_to_code',
                'entry_types.entry_type_to',
                'entry_types.transaction_mode_to'
            )
                ->join('stock_locations', 'stock_locations.code', '=', 'acc_transactions.stock_location_code')
                ->where('entry_types.is_active', '=', 1)
                // ->whereBetween('acc_transactions.created_at', [date('Y-m-d H:m:s', strtotime($fromDate) - 1), date('Y-m-d H:m:s', strtotime($toDate))])
                ->whereBetween('acc_transactions.date_time', [date('Y-m-d H:m:s', strtotime($fromDate) - 1), date('Y-m-d H:m:s', strtotime($toDate) + 1)])
                ->get();
            //return $account_transaction;
            if (count($account_transaction) > 0) {
                foreach ($account_transaction as $accountTransaction) {


                    $max_code = GeneralLedger::select('code')
                        ->where('stock_location_code', '=', $stockLocationCode)
                        ->max('code');
                    $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;

                    $generalLedger = GeneralLedger::create([
                        'code' => $general_Ledger_code . $locationPrefix . $max_id,
                        'source_code' => $accountTransaction->source_code,
                        'stock_location_code' => getCurrentLocationCode($request),
                        'amount' => $accountTransaction->amount,
                        'ledger_date' => $fromDate,
                        'ledger_type' => $accountTransaction->ledger_type,
                        'entry_type' => $accountTransaction->entry_type,
                        'transaction_type' => $accountTransaction->transaction_mode,
                        'created_by' => getUserCode(),
                        'created_at' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                    if ($accountTransaction->acc_ledger_type_to_code !== null) {
                        $max_code1 = GeneralLedger::select('code')
                            ->where('stock_location_code', '=', $stockLocationCode)
                            ->max('code');
                        $max_id1 = $max_code1 == null ? config('global.code_value') + 1 : substr($max_code1, 5) + 1;

                        $generalLedger = GeneralLedger::create([
                            'code' => $general_Ledger_code . $locationPrefix . $max_id1,
                            'source_code' => $accountTransaction->source_code,
                            'stock_location_code' => getCurrentLocationCode($request),
                            'amount' => $accountTransaction->amount,
                            'ledger_date' => $fromDate,
                            'ledger_type' => $accountTransaction->acc_ledger_type_to_code,
                            'entry_type' => $accountTransaction->entry_type_to,
                            'transaction_type' => $accountTransaction->transaction_mode_to,
                            'created_by' => getUserCode(),
                            'created_at' => getDateTimeNow(),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);

                    }


                }
            }



            DB::commit();

            // This is a replicate from generalLedgerView
            $generalLedgerView = GeneralLedger::select(
                'code',
                'source_code',
                'stock_location_code',
                'amount',
                'ledger_type',
                'entry_type',
                'transaction_type',
                'created_at',

            )->with([
                        'accTransaction' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                ->with([
                    'accTransaction.entryType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->where('is_active', '=', 1)

                ->whereBetween('created_at', [date('Y-m-d H:m:s', strtotime($fromDate) - 1), date('Y-m-d H:m:s', strtotime($toDate))], )
                ->get();





            return response()->json([
                'status' => 200,
                'generalLedgerView' => $generalLedgerView
            ], 200);
            //     // return response()->json([
            //     //     'status' => 200,
            //     //     'Invoice' => "Invoice created",
            //     //     'code' => $invoice->code,
            //     //     'submittedData' => $invoiceCreated,
            //     //     'date' => getDateTimeNow(),
            //     //     'isDebit' =>
            //     // ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }


    public function generalLedgerView(Request $request)
    {
        $date = $request->date;
        $ledgerType = $request->ledgerType;
        try {
            if ($date) {
                $generalLedgerView = AccGeneralLedger::select(
                    'code',
                    'source_code',
                    'stock_location_code',
                    'amount',
                    'ledger_type',
                    'entry_type',
                    'transaction_type',
                    'ledger_date',

                )->with([
                            'accTransaction' => function ($query) {
                                $query->where('is_active', '=', 1);
                            }
                        ])
                    ->with([
                        'accTransaction.entryType' => function ($query) {
                            $query->where('is_active', '=', 1);
                        }
                    ])
                    ->where('is_active', '=', 1)
                    ->where('ledger_date', '=', $date)
                    ->where('ledger_type', '=', $ledgerType)

                    ->get();
                return response()
                    ->json([
                        'status' => 200,
                        'generalLedgerView' => $generalLedgerView
                    ], 200);

            } else {
                return response()
                    ->json([
                        'status' => 200,
                        'generalLedgerView' => 'need to generate'
                    ], 200);

            }

        } catch (\Exception $e) {
            throw new Exception($e);
        }

    }
}