<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\DefaultValues;
use App\Enums\FreezeStatus;
use App\Enums\StockHistorySource;
use App\Enums\TransactionCode;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockHistory;
use App\Models\Stock_Models\StockHistoryExt;
use App\Models\Vehicle_Models\VehicleType;
use Exception;
use Illuminate\Support\Facades\DB;

class StockHistoryFunction
{


    /**
     * addStockHistory
     * Author: Suhail Jamaldeen
     * Date: 18.02.2022
     * Version: 01
     * Logic: Inserts Data into stock history
     * @param  mixed $stockHistory
     * @param  mixed $sourceCode
     * @param  mixed $source
     * @param  mixed $stock
     * @return StockHistory
     */
    public function addStockHistory($stockHistory, $sourceCode, $source, $stock): StockHistory
    {
        try {
            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $stockHistory['itemMaster']['code'],
                'source_code' => $sourceCode,
                'source' => $source,
                'stock_code' => $stock['code'] ?? null,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'quantity' => $stockHistory['quantity'] ?? 1,
                'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? 0,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? 0,
                'discount_total' => $stockHistory['discountTotal'] ?? 0,
                'total_amount' => $stockHistory['totalAmount'],
                //($stockHistory['quantity'] * $stockHistory['unitSoldPrice'])-
                //($stockHistory['quantity'] * $stockHistory['discountAmount'])
                //(($stockHistory['quantity'] * $stockHistory['unitSoldPrice']) * $stockHistory['discountPercentage'] / 100 )
                // 'total_amount' => $stockHistory['totalAmount'] ?? null, //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'] - $stockHistory['discountTotal'] ,
                'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return $stock_history;
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addStockHistoryForBulkInvoice($stockHistory, $sourceCode, $source, $stock): StockHistory
    {
        try {
            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $stockHistory['itemMaster']['code'],
                'source_code' => $sourceCode,
                'source' => $source,
                'stock_code' => $stock['code'] ?? null,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'quantity' => $stockHistory['quantity'] ?? 1,
                'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? 0,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? 0,
                'discount_total' => $stockHistory['discountTotal'] ?? 0,
                'total_amount' => $stockHistory['totalAmount'],
                //($stockHistory['quantity'] * $stockHistory['unitSoldPrice'])-
                //($stockHistory['quantity'] * $stockHistory['discountAmount'])
                //(($stockHistory['quantity'] * $stockHistory['unitSoldPrice']) * $stockHistory['discountPercentage'] / 100 )
                // 'total_amount' => $stockHistory['totalAmount'] ?? null, //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'] - $stockHistory['discountTotal'] ,
                'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return $stock_history;
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addStockHistoryForService($stockHistory, $sourceCode, $source): StockHistory
    {


        try {
            // DB::beginTransaction();


            // DB::commit();


            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            // DB::commit();

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $stockHistory['code'],
                'source_code' => $sourceCode,
                'source' => $source,
                'stock_code' => null,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'quantity' => $stockHistory['quantity'] ?? null,
                'remaining_quantity' => null,
                'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? 0,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? 0,
                'discount_total' => $stockHistory['discountTotal'] ?? 0,
                'total_amount' => $stockHistory['totalAmount'],
                //($stockHistory['quantity'] * $stockHistory['unitSoldPrice'])-
                //($stockHistory['quantity'] * $stockHistory['discountAmount'])
                //(($stockHistory['quantity'] * $stockHistory['unitSoldPrice']) * $stockHistory['discountPercentage'] / 100 )
                // 'total_amount' => $stockHistory['totalAmount'] ?? null, //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'] - $stockHistory['discountTotal'] ,
                'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
            return $stock_history;
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addStockHistoryExt($stockHistory, $packSize, $code)
    {
        try {
            DB::beginTransaction();
            $stock_history_ext_code = TransactionCode::STOCK_HISTORY_EXT;
            $cus_code = StockHistoryExt::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stock_history_ext = StockHistoryExt::create([
                'code' => $stock_history_ext_code . $max_id,
                'stock_history_code' => $code,
                'pack_size' => $packSize,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return $stock_history_ext;
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }



    /**
     * stockResetInvoice
     * Author : Fathima Sajana
     * Date : 2022.11.08
     * Version : 1
     * Logic : when edit the invoice, here call this function for changing remaining quantity in stock also stock history,
     *
     *
     * Author: Suhail Jamaldeen
     * Date: 02.10.2023
     * Version: 02
     * Logic: Added Getting stock based on the item. Added setting.is_batch_enabled.
     *
     * Author: Fathima Sajana
     * Date: 2023.12.19
     * Version: 03
     * Logic:
     */
    public function stockResetInvoice($request, $stockHistory, $source, $invoice)
    {
        try {
            DB::beginTransaction();
            $stockLocationCode = getCurrentLocationCode($request);
           if (config('setting.is_batch_enabled') || $invoice->is_freeze) {

                $stock = Stock::select(
                    'id',
                    'code',
                    'item_code',
                    'stock_location_code',
                    'remaining_quantity'
                )
                    ->where('code', '=', $stockHistory['stockCode'])
                    ->first();
            } else {
                $stock = Stock::select(
                    'id',
                    'code',
                    'item_code',
                    'stock_location_code',
                    'remaining_quantity'
                )
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->where('item_code', '=', $stockHistory['itemCode'])
                    ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                    ->first();
            }

            if ($stock) {
                $stockHistoryExisting = StockHistory::select('code', 'quantity')
                    ->where('code', $stockHistory['code'])
                    ->first();

                if (!$stockHistoryExisting) //if the item is new
                {

                    $stockHistoryQuantity = $stockHistory['quantity'];
                    $stockRemainingQuantity = $stock->remaining_quantity;

                    if ($source === StockHistorySource::INVOICE) {
                        $stockQuantityUp = $stockRemainingQuantity - $stockHistoryQuantity;
                    }
                    $stock->update([
                        'remaining_quantity' => $stockQuantityUp,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);

                    $stockHistory['remainingQuantity'] = $stockQuantityUp;
                    $this->addStockHistory($stockHistory, $invoice->code, StockHistorySource::INVOICE, $stock);
                } else // if it has existing quantity
                {

                    $stockHistoryQuantity = ($stockHistoryExisting->quantity);

                    //Get the difference between existing stock history quantity and updated stock history quantity
                    // $stockHistory['quantity'] -> updated quantity
                    $stockHistoryDifference = $stockHistoryQuantity - $stockHistory['quantity'];
                    $stockQuantity = $stock->remaining_quantity;
                    if ($source === StockHistorySource::INVOICE) {
                        $stockQuantityUp = $stockQuantity + ($stockHistoryDifference);
                    }
                    $stock->update([
                        'remaining_quantity' => $stockQuantityUp,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);

                    StockHistory::where('code', '=', $stockHistory['code'])
                        ->update([
                            'remaining_quantity' => $stockQuantityUp,
                            'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                            'retail_price' => $stockHistory['retailPrice'] ?? null,
                            'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                            'least_price' => $stockHistory['leastPrice'] ?? null,
                            'cost_price' => $stockHistory['costPrice'] ?? null,
                            'quantity' => $stockHistory['quantity'] ?? null,
                            'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                            'discount_amount' => $stockHistory['discountAmount'] ?? null,
                            'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                            'discount_total' => $stockHistory['discountTotal'] ?? null,
                            'total_amount' => $stockHistory['totalAmount'] ?? null,
                            'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                            //'is_freeze'  => 0,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                }
                DB::commit();
                return $stock;
            }
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function priceUpdate($stockHistory)
    {
        try {
            DB::beginTransaction();
            $price = Stock::where('item_code', '=', $stockHistory['itemCode'])
                ->where('stock_location_code', '=', $stockHistory['stockLocationCode'])
                ->where('wholesale_price', '=', $stockHistory['wholesalePrice'])
                ->Where('retail_price', '=', $stockHistory['retailPrice'])
                ->Where('cost_price', '=', $stockHistory['costPrice'])
                ->count();

            if ($price > 0) {
                $stock = Stock::where('item_code', '=', $stockHistory['itemCode'])
                    ->where('stock_location_code', $stockHistory['stockLocationCode'])
                    ->where('wholesale_price', '=', $stockHistory['wholesalePrice'])
                    ->Where('retail_price', '=', $stockHistory['retailPrice'])
                    ->Where('cost_price', '=', $stockHistory['costPrice'])
                    ->first();
                $stock = $stock->update([
                    'item_code' => $stockHistory['itemCode'],
                    'stock_location_code' => $stockHistory['stockLocationCode'],
                    'remaining_quantity' => $stockHistory['quantity'],
                    'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                    'retail_price' => $stockHistory['retailPrice'] ?? null,
                    'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                    'least_price' => $stockHistory['leastPrice'] ?? null,
                    'cost_price' => $stockHistory['costPrice'] ?? null,
                    'discount_price' => $stockHistory['discountPrice'] ?? null,
                    'discount' => $stockHistory['discount'] ?? null,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
                DB::commit();
                return $stock;
            } else {
                $stock_code = TransactionCode::STOCK;
                $max_code = Stock::max('code');
                $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
                $stock = Stock::create([
                    'code' => $stock_code . $max_id,
                    'item_code' => $stockHistory['itemCode'],
                    'stock_location_code' => $stockHistory['stockLocationCode'],
                    'remaining_quantity' => $stockHistory['quantity'],
                    'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                    'retail_price' => $stockHistory['retailPrice'] ?? null,
                    'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                    'least_price' => $stockHistory['leastPrice'] ?? null,
                    'cost_price' => $stockHistory['costPrice'] ?? null,
                    'discount_price' => $stockHistory['discountPrice'] ?? null,
                    'discount' => $stockHistory['discount'] ?? null,
                    'created_by' => getUserCode(),
                    'created_at' => getDateTimeNow(),
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
                DB::commit();
                return $stock;
            }
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    /**
     * Author: Suhail Jamaldeen
     * Version: 01
     * Date: 03.10.2023
     * Logic:
     * Summary of updateStockHistory
     * @param mixed $stockHistory
     * @param mixed $sourceCode
     * @param mixed $source
     * @param mixed $stock
     * @return mixed
     */
    public function updateStockHistory($stockHistory, $sourceCode, $source, $stock)
    {
        // try {
        DB::beginTransaction();
        if (isset($stockHistory['code'])) {

            $stock_history = StockHistory::where('code', $stockHistory['code'])
                ->first();
            if ($stock_history) {

                $stock_history->update([
                    'item_code' => $stockHistory['itemMaster']['code'],
                    'source_code' => $sourceCode,
                    'stock_code' => $stockHistory['stockCode'] ?? null,
                    'source' => $source,
                    'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                    'retail_price' => $stockHistory['retailPrice'] ?? null,
                    'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                    'least_price' => $stockHistory['leastPrice'] ?? null,
                    'cost_price' => $stockHistory['costPrice'] ?? null,
                    'quantity' => $stockHistory['quantity'] ?? null,
                    'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                    'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                    'discount_amount' => $stockHistory['discountAmount'] ?? null,
                    'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                    'discount_total' => $stockHistory['discountTotal'] ?? null,
                    'total_amount' => $stockHistory['totalAmount'] ?? null,
                    'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                    //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                    'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                    'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                    'expiry_date' => $stockHistory['expiryDate'] ?? null,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }
            DB::commit();
            return $stock_history;
        } else {
            //If there is no existing row in stock history adds a new row
            $this->addStockHistory($stockHistory, $sourceCode, $source, $stock);
        }
        // } catch (\Exception $e) {
        //     DB::rollBack();

        //     throw new Exception($e);
        // }
    }

    public function updateStockHistoryForService($stockHistory, $sourceCode, $source)
    {

        try {

            DB::beginTransaction();
            $stock_history = StockHistory::where('code', $stockHistory['code'])
                ->where('source_code', $sourceCode)->first();

            if ($stock_history) {
                $stock_history->update([
                    'item_code' => $stockHistory['itemMaster']['code'],
                    'source_code' => $sourceCode,
                    'stock_code' => null,
                    'source' => $source,
                    'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                    'retail_price' => $stockHistory['retailPrice'] ?? null,
                    'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                    'least_price' => $stockHistory['leastPrice'] ?? null,
                    'cost_price' => $stockHistory['costPrice'] ?? null,
                    'quantity' => $stockHistory['quantity'] ?? null,
                    'remaining_quantity' => null,
                    'unit_sold_price' => $stockHistory['retailPrice'] ?? null,
                    'discount_amount' => $stockHistory['discountAmount'] ?? null,
                    'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                    'discount_total' => $stockHistory['discountTotal'] ?? null,
                    'total_amount' => $stockHistory['totalAmount'] ?? null,
                    'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null,
                    //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                    'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                    'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                    'expiry_date' => $stockHistory['expiryDate'] ?? null,
                    'updated_by' => 7,
                    //getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);

                DB::commit();
            } else {


                //If there is no existing row in stock history adds a new row
                $this->addStockHistoryForService($stockHistory, $sourceCode, $source);
            }


            return $stock_history;
        } catch (\Exception $e) {
            DB::rollBack();

            throw new Exception($e);
        }
    }

    public function addStockHistoryForStockTransfer($stockHistory, $source_code, $source, $stock)
    {
        try {
            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $stockHistory['itemMaster']['code'],
                'source_code' => $source_code,
                'stock_code' => $stock['code'],
                'source' => $source,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'quantity' => $stockHistory['quantity'] ?? null,
                'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? null,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                'discount_total' => $stockHistory['discountTotal'] ?? null,
                'total_amount' => (($stockHistory['quantity'] * $stockHistory['costPrice'])),
                //- $stockHistory['discountTotal'],//$stockHistory['totalAmount'] ?? null,
                'sub_total_amount' => $stockHistory['quantity'] * $stockHistory['costPrice'],
                //$stockHistory['subTotalAmount'] ?? null,
                'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
            return $stock_history;
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function updateStockHistoryForStockTransfer($stockHistory, $source_code, $locationCode, $source, $stock)
    {
        try {
            DB::beginTransaction();
            if (isset($stockHistory['code'])) {

                $stock_history = StockHistory::where('code', $stockHistory['code'])
                    ->where('source_code', $source_code)->first();
                if ($stock_history) {
                    $stock_history->update([
                        'item_code' => $stockHistory['itemMaster']['code'],
                        'source_code' => $source_code,
                        'stock_code' => $stock['code'],
                        'source' => $source,
                        'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                        'retail_price' => $stockHistory['retailPrice'] ?? null,
                        'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                        'least_price' => $stockHistory['leastPrice'] ?? null,
                        'cost_price' => $stockHistory['costPrice'] ?? null,
                        'quantity' => $stockHistory['quantity'] ?? null,
                        'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                        'discount_amount' => $stockHistory['discountAmount'] ?? null,
                        'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                        'discount_total' => $stockHistory['discountTotal'] ?? null,
                        'total_amount' => ($stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice']),
                        //$stockHistory['totalAmount'] ?? null,
                        'sub_total_amount' => $stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                        //$stockHistory['subTotalAmount'] ?? null,
                        'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                        'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                        'expiry_date' => $stockHistory['expiryDate'] ?? null,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                }
                DB::commit();
                return $stock_history;
            }
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }
}
