<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\TransactionCode;
use App\Models\Item_Models\ItemMaster;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockHistory;
use Exception;
use Illuminate\Support\Facades\DB;
use Mockery\Undefined;

class StockHistoryAutoCareFunction
{

    public function addStockHistoryForInvoice($stockHistory, $source_code, $stock)
    {
        try 
        {
            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $total = $stockHistory['quantity'] * $stockHistory['unit_sold_price'];

            $itemMaster  = itemMaster::where('code', $stockHistory['itemMaster']['code'])->first();

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $itemMaster->code,
                'source_code' => $source_code,
                'stock_code' => $stock['code'],
                'source' => 'INV',
                'location_code' => $stockHistory['locationCode'] ?? '21510000001',
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['itemMaster']['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['itemMaster']['dealerPrice'] ?? null,
                'least_price' => $stockHistory['itemMaster']['leastPrice'] ?? null,
                'cost_price' => $stockHistory['itemMaster']['costPrice'] ?? null,
                'quantity' => $stockHistory['quantity'] ?? null,
                'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                'unit_sold_price' => $stockHistory['unit_sold_price'] ?? null,
                'sub_total_amount' =>  $stockHistory['subTotal'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? null,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? null,
                'discount_total' => $stockHistory['totalDiscount'] ?? null,
                'total_amount' => $total ?? null,
                'warranty_due_date' => $stockHistory['warranty_due_date'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            if ($stock_history) {
                $this->stockUpdate($stock_history);
            }
            DB::commit();
        }
         catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addStockHistoryForGRN($stockHistory, $source_code, $source, $stock ) : StockHistory
    {
       try
        {
            DB::beginTransaction();
            $stock_history_code = TransactionCode::STOCK_HISTORY;
            $cus_code = StockHistory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $stock_history = StockHistory::create([
                'code' => $stock_history_code . $max_id,
                'item_code' => $stockHistory['itemMaster']['code'],
                'source_code' => $source_code,
                'location_code' => $stockHistory['locationCode'],
                'source' => $source,
                'stock_code' => $stock['code'],
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice']  ?? null,
                'quantity' => $stockHistory['quantity'] ?? null,
                'remaining_quantity' => $stock['remaining_quantity'] ?? null,
                'unit_sold_price' => $stockHistory['unitSoldPrice'] ?? null,
                'discount_amount' => $stockHistory['discountAmount'] ?? 0,
                'discount_percentage' => $stockHistory['discountPercentage'] ?? 0,
                'discount_total' => $stockHistory['discountTotal'] ?? 0,
                'total_amount' => $stockHistory['totalAmount'],
                //($stockHistory['quantity'] * $stockHistory['unitSoldPrice'])-
                //($stockHistory['quantity'] * $stockHistory['discountAmount'])
                //(($stockHistory['quantity'] * $stockHistory['unitSoldPrice']) * $stockHistory['discountPercentage'] / 100 )
                // 'total_amount' => $stockHistory['totalAmount'] ?? null, //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'] - $stockHistory['discountTotal'] ,
                'sub_total_amount' => $stockHistory['subTotalAmount'] ?? null, //$stockHistory['quantity'] * $stockHistory['itemMaster']['costPrice'],
                'warranty_due_date' => $stockHistory['warrantyDueDate'] ?? null,
                'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                'expiry_date' => $stockHistory['expiryDate'] ?? null,
                'created_by' => getUserCode(),
                'created_at' =>  getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' =>  getDateTimeNow(),
            ]);
            DB::commit();
            return  $stock_history;
        }
         catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }


    public function stockUpdate($stock_history)
    {
        try {


            $count = Stock::where('item_code', $stock_history->item_code)
                ->where('location_code', $stock_history->location_code)->count();

            if ($count > 0) {
                $stock = Stock::select('id', 'item_code', 'location_code', 'remaining_quantity')
                    ->where('item_code', $stock_history->item_code)
                    ->first();
                if ($stock_history->source === "GRN") {
                    $remainingQuantity = ($stock->remaining_quantity) + ($stock_history->quantity);
                } else if ($stock_history->source === "RTN") {
                    //SalesReturn =>RTN
                    $remainingQuantity = ($stock->remaining_quantity) + ($stock_history->quantity);
                } elseif ($stock_history->source === "INV") {
                    $remainingQuantity = ($stock->remaining_quantity) - ($stock_history->quantity);
                }

                $stock->update([
                    'remaining_quantity' => $remainingQuantity
                ]);
            } else {

                $item = ItemMaster::where('is_service', '=', 0)->where('code', '=', $stock_history->item_code)
                    ->where('is_active', '=', 1)->first();

                if ($item != null) {
                    if ($stock_history->source === "INV") {
                        Stock::create([
                            'item_code' => $stock_history->item_code,
                            'remaining_quantity' => -$stock_history->quantity,
                            'location_code' => $stock_history->location_code
                        ]);
                    } else {
                        Stock::create([
                            'item_code' => $stock_history->item_code,
                            'remaining_quantity' =>  $stock_history->quantity,
                            'location_code' => $stock_history->location_code
                        ]);
                    }
                }
            }
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function updateStockHistory($stockHistory, $source_code, $source)
    {
        try {

            if (isset($stockHistory['code'])) {

                $stock_history = StockHistory::where('code', $stockHistory['code'])
                    ->where('source_code', $source_code)->first();

                //stock Reverse -> function
                if ($stock_history) {
                    $this->stockReverse($stock_history);
                }
                $costPrice = $source == "GRN" ? $stockHistory['costPrice'] : $stockHistory['itemMaster']['costPrice'];
                if ($source == "GRN") {
                    $total = $stockHistory['quantity'] *  $costPrice;
                } else if ($source == "INV") {
                    $total = $stockHistory['quantity'] * $stockHistory['retailPrice'];
                } else {
                    $total = $stockHistory['quantity'] * $stockHistory['itemMaster']['retailPrice'];
                }
                $stock_history->update([
                    'item_code' => $stockHistory['itemMaster']['code'],
                    'source_code' => $source_code,
                    'source' => $source,
                    'location_code' => $stockHistory['locationCode'] ?? '21510000001',
                    'unit_sold_price' => $stockHistory['unit_sold_price'],
                    'quantity' => $stockHistory['quantity'] ?? null,
                    'discountAmount' => $stockHistory['discount'] ?? null,
                    'discountPercentage' => $stockHistory['discountPercentage'] ?? null,
                    'discount_total' => $stockHistory['discount_total'] ?? null,
                    'total_amount' => $total,
                    'sub_total_amount' =>  $stockHistory['sub_total_amount'] ?? null,
                    'warranty_due_date' => $stockHistory['warranty_due_date'] ?? null,
                    'warranty_periods' => $stockHistory['warrantyPeriods'] ?? null,
                    'expiry_date' => $stockHistory['expiryDate'] ?? null,              
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            } else {
                // $this->addStockHistory($stockHistory, $source_code, $source);//Suhail Jamaldeen
            }
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function stockReverse($stock_history)
    {
        try {


            $count = Stock::where('item_code', $stock_history->item_code)->count();

            if ($count > 0) {
                $stock = Stock::select('id', 'item_code', 'remaining_quantity')
                    ->where('item_code', $stock_history->item_code)
                    ->first();

                if ($stock_history->source === "GRN") {
                    $remainingQuantity = ($stock->remaining_quantity) - ($stock_history->quantity);
                } else if ($stock_history->source === "RTN") {
                    //SalesReturn =>RTN
                    $remainingQuantity = ($stock->remaining_quantity) - ($stock_history->quantity);
                } elseif ($stock_history->source === "INV") {
                    $remainingQuantity = ($stock->remaining_quantity) + ($stock_history->quantity);
                }

                $stock->update([
                    'remaining_quantity' => $remainingQuantity
                ]);
            }
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
