<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\DefaultValues;
use App\Enums\StockHistorySource;
use App\Enums\TransactionCode;
use App\Models\Stock_Models\MatureStock;
use App\Models\Stock_Models\Stock;
use App\Models\Invoice_Models\Invoice;
use App\Models\Stock_Models\StockHistory;
use App\Models\Stock_Models\StockHistoryExtInvoice;
use Exception;
use Illuminate\Support\Facades\DB;
use Laravel\Sail\Console\PublishCommand;

class StockFunction
{


    /**
     * getExistingStock
     * Author: Suhail Jamaldeen
     * Date: 18.12.2022
     * Version: 01
     * Logic: Get the stock by stock code if not there move from mature stock else return null
     * @param  mixed $stockCode
     * @return Stock
     */
    public function getExistingStock($stockCode): Stock
    {
        try {
            DB::beginTransaction();

            //Get the stock from Stock Table
            $stock = Stock::where('code', '=', $stockCode)
            ->where('is_freeze', '=', 0)
            ->first();
            if (!$stock) {
                //If stock is not available it should have moved to Matred Stock Table.
                //So we replicate into stock
                $matureStock = MatureStock::where('stock_code', '=', $stockCode)
                    ->first();
                $newRecord = $matureStock->replicate(['stock_code'])->fill(
                    [
                        'code' => $stockCode,
                    ]
                );
                $newRecord->setTable('stocks');
                $stock = $newRecord->save();
                $stock = Stock::where('code', '=', $stockCode)
                ->where('is_freeze', '=', 0)
                ->first();
            }
            DB::commit();
            return $stock;
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * createStock
     *   Author: Suhail Jamaldeen
     * Date: 18.12.2022
     * Logic: Create entry in stock when adding a grn
     * @param  mixed $stockHistory
     * @param  mixed $create
     * @return Stock
     */


    public function createStock($stockHistory, $grnCode, $locationCode): Stock
    {

        try {
            DB::beginTransaction();

            $stock_code = TransactionCode::STOCK;
            $max_code = Stock::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
            $stock = Stock::create([
                'code' => $stock_code . $max_id,
                'item_code' => $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code'],
                'grn_code' => $grnCode,
                'batch' => $stockHistory['batch'] ?? null,
                'stock_location_code' => $locationCode,
                'remaining_quantity' => ($stockHistory['quantity']),
                'order_quantity' => 0,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'discount_price' => $stockHistory['discountPrice'] ?? null,
                'discount' => $stockHistory['discount'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();

            return $stock;
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }


    public function createOrUpdateStockForNotBatchEnabled($stockHistory, $grnCode, $locationCode): Stock
    {
        try {
            DB::beginTransaction();

            $remaining = $stockHistory['quantity'];
            $stock_code = TransactionCode::STOCK;
            $max_code = Stock::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            $stock = Stock::updateOrCreate([
                'item_code' => $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code']
            ], [
                'code' => $stock_code . $max_id,
                'grn_code' => $grnCode,
                'batch' => $stockHistory['batch'] ?? null,
                'stock_location_code' => $locationCode,
                'remaining_quantity' => DB::raw("IFNULL(remaining_quantity, 0) + $remaining"),
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'discount_price' => $stockHistory['discountPrice'] ?? null,
                'discount' => $stockHistory['discount'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();

            return $stock;
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }

    /**
     * updateStock
     * Author: Suhail Jamaldeen
     * Date: 16.09.2023
     * Logic: Create entry in stock when adding a grn. This is used when the batch is disabled.
     *
     *
     *
     * @param  mixed $stockHistory
     * @param  mixed $update
     * @return Stock
     */
    // public function updateOrCreateStock($stockHistory, $grnCode, $locationCode): Stock
    // {

    //     try {
    //         DB::beginTransaction();
    //         $stock = Stock::select(
    //             'remaining_quantity',
    //             'is_freeze'
    //         )->where(
    //                 'item_code',
    //                 '=',
    //                 $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code']
    //             )->where(
    //                 'stock_location_code',
    //                 "=",
    //                 $locationCode
    //             )
    //             ->where('is_freeze', '=', 0 )
    //             ->first();
    //         $newQuantity = $stockHistory['quantity'];

    //         if ($stock) {
    //             $newQuantity = $stock->remaining_quantity + $newQuantity;
    //         }
    //         $stock_code = TransactionCode::STOCK;
    //         $max_code = Stock::max('code');
    //         $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

    //         $stock = Stock::updateOrCreate([
    //             'item_code' => $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code'],
    //             'stock_location_code' => $locationCode,
    //             'is_freeze' => 0,
    //         ], [
    //             'code' => $stock_code . $max_id,
    //             'grn_code' => $grnCode,
    //             'batch' => $stockHistory['batch'] ?? null,
    //             'remaining_quantity' => $newQuantity,
    //             'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
    //             'retail_price' => $stockHistory['retailPrice'] ?? null,
    //             'dealer_price' => $stockHistory['dealerPrice'] ?? null,
    //             'least_price' => $stockHistory['leastPrice'] ?? null,
    //             'cost_price' => $stockHistory['costPrice'] ?? null,
    //             'discount_price' => $stockHistory['discountPrice'] ?? null,
    //             'discount' => $stockHistory['discount'] ?? null,
    //             'created_by' => getUserCode(),
    //             'created_at' => getDateTimeNow(),
    //             'updated_by' => getUserCode(),
    //             'updated_at' => getDateTimeNow(),
    //         ]);

    //         DB::commit();

    //         return $stock;
    //     } catch (\Exception $e) {

    //         throw new Exception($e);
    //     }
    // }

    public function updateOrCreateStock($stockHistory, $grnCode, $locationCode): Stock
    {

        try {
            DB::beginTransaction();
            

        $itemCode = $stockHistory['itemMaster']['code'];
            $newQuantity = $stockHistory['quantity'];

            $existingStock = Stock::where('item_code', $itemCode)
            ->where('stock_location_code', $locationCode)
            ->first();


            if($existingStock) {
                $existingStock->update([
                   'remaining_quantity'=>  $existingStock['remaining_quantity'] +  $newQuantity,
                   'grn_code'=> $grnCode,
                ]);

            $stock = $existingStock;

            } else {
            $stock_code = TransactionCode::STOCK;
            $max_code = Stock::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            $stock = Stock::create([
                'code' => $stock_code . $max_id,
                'item_code' => $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code'],
                'stock_location_code' => $locationCode,
                'is_freeze' => 0,
                'grn_code' => $grnCode,
                'batch' => $stockHistory['batch'] ?? null,
                'remaining_quantity' => $newQuantity,
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'discount_price' => $stockHistory['discountPrice'] ?? null,
                'discount' => $stockHistory['discount'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            }
            // $stock = Stock::select(
            //     'remaining_quantity',
            //     'is_freeze'
            // )->where(
            //         'item_code',
            //         '=',
            //         $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code']
            //     )->where(
            //         'stock_location_code',
            //         "=",
            //         $locationCode
            //     )
            //     ->where('is_freeze', '=', 0 )
            //     ->first();
            // $newQuantity = $stockHistory['quantity'];

            // if ($stock) {
            //     $newQuantity = $stock->remaining_quantity + $newQuantity;
            // }
            // $stock_code = TransactionCode::STOCK;
            // $max_code = Stock::max('code');
            // $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            // $stock = Stock::updateOrCreate([
            //     'item_code' => $stockHistory['itemCode'] ?? $stockHistory['itemMaster']['code'],
            //     'stock_location_code' => $locationCode,
            //     'is_freeze' => 0,
            // ], [
            //     'code' => $stock_code . $max_id,
            //     'grn_code' => $grnCode,
            //     'batch' => $stockHistory['batch'] ?? null,
            //     'remaining_quantity' => $newQuantity,
            //     'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
            //     'retail_price' => $stockHistory['retailPrice'] ?? null,
            //     'dealer_price' => $stockHistory['dealerPrice'] ?? null,
            //     'least_price' => $stockHistory['leastPrice'] ?? null,
            //     'cost_price' => $stockHistory['costPrice'] ?? null,
            //     'discount_price' => $stockHistory['discountPrice'] ?? null,
            //     'discount' => $stockHistory['discount'] ?? null,
            //     'created_by' => getUserCode(),
            //     'created_at' => getDateTimeNow(),
            //     'updated_by' => getUserCode(),
            //     'updated_at' => getDateTimeNow(),
            // ]);

            DB::commit();

            return $stock;
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }




}
