<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Http\Controllers\Controller;
use Http;
use Illuminate\Http\Request;

class SmsFunction extends Controller
{
    public function PaymentReceiptSms($customer, $paymentReceipt)
    {

        $sms = "Hi,Customer ".$customer->title .$customer->first_name .", Your PaymentReceipt No: ". $paymentReceipt->code .", Received Amount: ".$paymentReceipt->total_amount.", Settled Amount: ".$paymentReceipt->settled_amount.", Outstanding Amount: ".$customer->credit_amount.", Over Payment: ".$paymentReceipt->over_payment."Thank You.. Visit Again.".".Time : ".$paymentReceipt->created_at;


        $sms_api_key = env('SMS_API_KEY');
        $sms_user_id = env('SMS_USER_ID');

        $sms_sender_id='ORBIT';

        $url = "http://sms.titum.lk/api/v2/send.php?"."&user_id=".$sms_user_id ."&api_key=".$sms_api_key ."&sender_id=".$sms_sender_id."&to=" .$customer['phone_1'] ."&message=" .$sms;
        $response = Http::get($url);
    }
    public function InvoiceSMS($customer, $invoice,$invoiceCode)
    {
        $customer_phone = $customer->phone_1;
        $cash_customer_phone = $invoiceCode['phone2'];

            $sms = "Hi," . $customer->title .$customer->first_name . ", Invoice No: " . $invoice->code . ". Total Invoice Amount Rs: " . number_format($invoice->total_amount, 2) . " Outstanding Rs: " . number_format($customer->credit_amount, 2) . " Thank You.. Visit Again" . ". Time : " . $invoice->created_at;
            $smsCash = "Dear Customer , Invoice No: " . $invoice->code . ". Total Invoice Amount Rs: " . number_format($invoice->total_amount, 2) . " Thank you" . ". Time : " . $invoice->created_at;

            $sms_api_key = env('SMS_API_KEY');
            $sms_user_id = env('SMS_USER_ID');
            $sms_sender_id = 'ORBIT';

            if($invoiceCode['phone2']){
                $url = "http://sms.titum.lk/api/v2/send.php?" . "&user_id=" . $sms_user_id . "&api_key=" . $sms_api_key . "&sender_id=" . $sms_sender_id . "&to=" . $invoiceCode['phone2']. "&message=" . $smsCash;
                $response = Http::get($url);
            }
            else if ( $customer->phone_1){
                $url = "http://sms.titum.lk/api/v2/send.php?" . "&user_id=" . $sms_user_id . "&api_key=" . $sms_api_key . "&sender_id=" . $sms_sender_id . "&to=" . $customer->phone_1 . "&message=" . $sms;
                $response = Http::get($url);
            }

    }
    public function MoreOfPaymentSMS($customer,$invoice,$settledAmount)
    {


        $sms = "Hi," . $customer->title .$customer->first_name . ", Invoice No: " . $invoice->code . ". Invoice Amount Rs: " . number_format($invoice->total_amount, 2) . " Outstanding Rs: " . number_format($customer->credit_amount, 2) .  " over payment Rs: " . number_format($customer->over_payment, 2) . " return amount payment Rs: " . number_format($customer->return_amount, 2)  ." Payment Receipts Rs: " . number_format($settledAmount, 2) . "Thank You.. Visit Again" . ". Time : ".$invoice->created_at;
        $sms_api_key = env('SMS_API_KEY');
        $sms_user_id = env('SMS_USER_ID');

        $sms_sender_id = 'ORBIT';

        $url = "http://sms.titum.lk/api/v2/send.php?" . "&user_id=" . $sms_user_id . "&api_key=" . $sms_api_key . "&sender_id=" . $sms_sender_id . "&to=" . $customer->phone_1 . "&message=" . $sms;

        $response = Http::get($url);
    }
    public function OutstandingSms($customer)
    {

        $sms= "Hi,Customer ".$customer->title .$customer->first_name .", Your Out Standing Amount: ".  $customer->credit_amount  ."Thank You.. Visit Again.";

        $sms_api_key = env('SMS_API_KEY');
        $sms_user_id = env('SMS_USER_ID');

        $sms_sender_id='ORBIT';

        $url = "http://sms.titum.lk/api/v2/send.php?"."&user_id=".$sms_user_id ."&api_key=".$sms_api_key ."&sender_id=".$sms_sender_id."&to=" .$customer['phone_1'] ."&message=" .$sms;
        $response = Http::get($url);


    }
}
