<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\TransactionCode;
use App\Models\Vehicle_Models\ServicePackageData;
use Illuminate\Support\Facades\DB;

class ServicePackageDataFunction
{
    public function servicePackageData($packageData, $ServiceCode)
    {

        try {
            DB::beginTransaction();

            $data = TransactionCode::SERVICE_PACKAGE_DATA;
            $max_code = ServicePackageData::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
            $packageData = ServicePackageData::create([
                'code' => $data . $max_id,
                'service_package_code' => $ServiceCode,
                'item_code' => $packageData['itemMaster']['code'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
            return response()->json(['status' => 200, 'package Data' =>$packageData]);

        } catch (\Exception $e) {
            DB::rollback();
            return response(['status' => 500, 'message' => $e]);
        }
    }

    public function updateServicePackageData($package_data, $serviceCode)
    {
        DB::beginTransaction();
        try {
            foreach ($package_data as $packageData) {
                if (isset($packageData['code']))
                {
                    $service = ServicePackageData::select('code', 'service_package_code', 'item_code')
                        ->where('code', $packageData['code'])
                        ->where('service_package_code', $serviceCode)->first();

                    $service->update([
                        'service_package_code' => $packageData['servicePackageCode'],
                        'item_code' => $packageData['itemMaster']['code'],
                    ]);
                } 
                else 
                {
                    $this->servicePackageData($packageData, $serviceCode);
                }
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return response(['status' => 500, 'message' => $e]);
        }
    }
}
