<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\PaymentStatus;
use App\Enums\ChequeStatusCode;
use App\Enums\DefaultValues;
use App\Enums\PaymentTypeCode;
use App\Enums\TransactionCode;
use App\Models\Customer_Models\Customer;
use App\Models\PaymentReceipt_Models\BankPayment;
use App\Models\PaymentReceipt_Models\InvoicePayment;
use App\Models\PaymentReceipt_Models\CardPayment;
use App\Models\PaymentReceipt_Models\CashPayment;
use App\Models\PaymentReceipt_Models\ChequePayment;
use App\Models\PaymentReceipt_Models\InvoicePaymentReceipt;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentReceipt_Models\ModeOfPayment;
use App\Models\PaymentReceipt_Models\OnlineTransferPayment;
use App\Models\PaymentReceipt_Models\OverPayment;
use App\Models\PaymentReceipt_Models\ReturnAmount;
use Exception;
use Illuminate\Support\Facades\DB;

class PaymentReceiptFunctionForInvoice
{

    /**
     * addPaymentReceipt
     * Author: Suhail Jamaldeen
     * Date: 12.03.2022
     * Logic: This is called only when add through invoice controller
     * @param  mixed $request
     * @param  mixed $modeOfPayments
     * @param  mixed $invoice
     * @return void
     */
    public function addPaymentReceipt($request, $modeOfPayments, $invoice)
    {
        // try {

            DB::beginTransaction();
            $payment_code = TransactionCode::PAYMENT_RECEIPT_CODE;
            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr($stockLocationCode, -2);

            $max_code = PaymentReceipt::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->max('code');
            $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code", 5) + 1;
            $paymentReceipt = PaymentReceipt::create([
                'code' => $payment_code . $locationPrefix . $max_id,
                'customer_code' => $invoice['customer']['code'] ?? DefaultValues::CUSTOMER_CODE,
                'stock_location_code' => getCurrentLocationCode($request),
                'total_amount' => $request->paidAmount,
                'settled_amount' => $request->paidAmount,
                'over_payment' => ($request->paidAmount - $request->paidAmount),
                'status' => PaymentStatus::PAYMENT_COMPLETED,
                'remarks' => $request->remarks ?? null,
                'payment_date_time' => $invoice->date_time,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            $customer = $request->customer;

            $paidByOverPayment = 0; // This set the values settled by over payment
            $paidByReturnPayment = 0;

            if ($paymentReceipt) {

                if (count($modeOfPayments) > 0) {
                    foreach ($modeOfPayments as $mode_of_payment) {
                        $modePayment_code = TransactionCode::MODE_OF_PAYMENT;
                        $max_code = ModeOfPayment::max('code');
                        $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

                        $modeOfPayment = ModeOfPayment::create([
                            'code' => $modePayment_code . $max_id,
                            'payment_receipt_code' => $paymentReceipt->code,
                            'payment_type_code' => $mode_of_payment['paymentType'],
                            'amount' => $mode_of_payment['amount'],
                            'date_time' => $paymentReceipt['payment_date_time'],
                            'created_by' => getUserCode(),
                            'created_at' => getDateTimeNow(),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                        if ($mode_of_payment) {

                            if ($modeOfPayment->payment_type_code == PaymentTypeCode::CASH_PAYMENT_CODE) {
                                $this->addCashPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::OVER_PAYMENT_CODE) {
                                $paidByOverPayment = $paidByOverPayment + $modeOfPayment['amount'];
                                $this->addOverPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::RETURN_AMOUNT_CODE) {
                                $paidByReturnPayment = $paidByReturnPayment + $modeOfPayment['amount'];
                                $this->addReturnAmount($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::CHEQUE_PAYMENT_CODE) {
                                $this->addChequePayment($mode_of_payment, $invoice, $modeOfPayment->code, $paymentReceipt, $customer,$request);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::BANK_PAYMENT_CODE) {
                                $this->addBankPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::CARD_PAYMENT_CODE) {
                                $this->addCardPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            } elseif ($modeOfPayment->payment_type_code == PaymentTypeCode::ONLINE_TRANSFER_PAYMENT_CODE) {
                                $this->addOnlineTransferPayment($mode_of_payment, $modeOfPayment->code, $paymentReceipt, $customer);
                            }
                        }
                    }
                    //This updates the intermediate table
                    $this->addInvoicePayment($paymentReceipt, $invoice);
                    $customer = Customer::where('code', $invoice->customer_code)->first();

                    if ($customer) {
                        $customer->update([

                            'invoice_total' => $invoice->total_amount + $customer['invoice_total'],
                            'received_amount' => ($invoice['paid_amount'] + $customer['received_amount']) - $paidByOverPayment,
                            'over_payment' => $customer['over_payment']  - $paidByOverPayment,
                            'return_amount' => $customer['return_amount'] - $paidByReturnPayment,
                            'credit_amount' => $customer['credit_amount'] +  ($request->totalAmount - $paymentReceipt->settled_amount),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                    }
                }
            }
            DB::commit();
            return response()->Json([
                'status' => 200,
                'message' => 'Payment Receipt Created'
            ]);
        // } catch (\Exception $e) {
        //     DB::rollback();
        //     throw new Exception($e);
        // }
    }

    public function addInvoicePayment($paymentReceipt, $invoice)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::INVOICE_PAYMENT_CODE;
            $cus_code = InvoicePaymentReceipt::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $invoicePayment = InvoicePaymentReceipt::create([
                'code' => $payment_code . $max_id,
                'payment_receipt_code' => $paymentReceipt->code,
                'invoice_code' => $invoice->code,
                'invoice_total' => $invoice->total_amount,
                'paid_amount' => $paymentReceipt->total_amount,
                'outstanding' => $invoice->total_amount,
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addChequePayment($mode_of_payment, $invoice, $code, $paymentReceipt, $customer,$request)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CHEQUE_PAYMENT_CODE;
            $cus_code = ChequePayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $cheque_Payment = ChequePayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt->code,
                'stock_location_code'=> getCurrentLocationCode($request),
                'mode_of_payment_code' => $code,
                'bank_code' => $mode_of_payment['chequePayment']['bank'],
                //'branch_code' => $mode_of_payment['branch']['code']??null,
                //'customer_code' => $invoice['customer']['code'] ?? null,
                'customer_code' => $customer['code'] ?? null,
                'number' => $mode_of_payment['chequePayment']['chequeNumber'],
                'deposit_date' => $mode_of_payment['chequePayment']['date'] ?? null,
                'amount' => $mode_of_payment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $mode_of_payment['remarks'],
                'status' => ChequeStatusCode::CHEQUE_IN_HAND,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
            // return response()->json([
            //     'status' => 500,
            //     'message' => $e
            // ], 500);
        }
    }

    public function addBankPayment($mode_of_payment, $code, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::BANK_PAYMENT_CODE;
            $cus_code = BankPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $bankPayment = BankPayment::create([

                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt->code,
                'mode_of_payment_code' => $code,
                'customer_code' => $customer['code'] ?? null,
                'bank_code' => $mode_of_payment['bankDeposit']['bank'],
                'reference_number' => $mode_of_payment['bankDeposit']['refNumber'],
                'amount' => $mode_of_payment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $mode_of_payment['remarks'],
                'date' => $mode_of_payment['bankDeposit']['date'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
            // return response()->json([
            //     'status' => 500,
            //     'message' => $e
            // ], 500);
        }
    }


    public function addOnlineTransferPayment($mode_of_payment, $code, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::ONLINE_TRANSFER_PAYMENT_CODE;
            $cus_code = OnlineTransferPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $onlineTransferPayment = OnlineTransferPayment::create([

                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt->code,
                'mode_of_payment_code' => $code,
                'customer_code' => $customer['code'] ?? null,
                'bank_code' => $mode_of_payment['onlineTransfer']['bank'],
                'transfer_id' => $mode_of_payment['onlineTransfer']['transferId'],
                'amount' => $mode_of_payment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $mode_of_payment['remarks']?? null,
                'transfer_date' => $mode_of_payment['onlineTransfer']['transferDate']?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
            // return response()->json([
            //     'status' => 500,
            //     'message' => $e
            // ], 500);
        }
    }
    public function addOverPayment($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::OVER_PAYMENT_CODE;
            $cus_code = OverPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $overPayment = OverPayment::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'customer_code' => $customer['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addReturnAmount($modeOfPayment, $modeOfPaymentCode, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::RETURN_AMOUNT_CODE;
            $cus_code = ReturnAmount::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $returnAmount = ReturnAmount::create([
                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $modeOfPaymentCode,
                'customer_code' => $customer['code'] ?? null,
                'amount' => $modeOfPayment['amount'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function addCashPayment($mode_of_payment, $code, $paymentReceipt, $customer)
    {
        // try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CASH_PAYMENT_CODE;
            $cus_code = CashPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $CashPayment = CashPayment::create([

                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt['code'],
                'mode_of_payment_code' => $code,
                'customer_code' => $customer['code'] ?? null,
                'remarks' => $mode_of_payment['remarks'] ?? null,
                'amount' => $mode_of_payment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        // } catch (\Exception $e) {
        //     DB::rollBack();
        //     throw new Exception($e);
        //     // return response()->json([
        //     //     'status' => 500,
        //     //     'message' => $e
        //     // ], 500);
        // }
    }
    public function addCardPayment($mode_of_payment, $code, $paymentReceipt, $customer)
    {
        try {
            DB::beginTransaction();

            $payment_code = TransactionCode::CARD_PAYMENT_CODE;
            $cus_code = CardPayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $CardPayment = CardPayment::create([

                'code' => $payment_code . $max_id,
                'receipt_code' => $paymentReceipt->code,
                'mode_of_payment_code' => $code,
                'customer_code' => $customer['code'] ?? null,
                'bank_code' => $mode_of_payment['cardPayment']['bank'],
                'card_number' => $mode_of_payment['cardPayment']['cardNumber'],
                'amount' => $mode_of_payment['amount'],
                'date_time' => $paymentReceipt['payment_date_time'],
                'remarks' => $mode_of_payment['remarks'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
            //     return response()->json([
            //         'status' => 500,
            //         'message' => $e
            //     ], 500);
        }
    }
}
