<?php

namespace App\Http\Controllers\Function_Controllers;

use App\Enums\DefaultValues;
use App\Enums\StockHistorySource;
use App\Enums\TransactionCode;
use App\Models\Stock_Models\Stock;
use App\Models\Invoice_Models\Invoice;
use App\Models\Stock_Models\StockHistory;
use App\Models\Stock_Models\StockHistoryExtInvoice;
use Exception;
use Illuminate\Support\Facades\DB;

class MatureStockFunction
{

    /**
     * createStock
     * Author: Suhail Jamaldeen
     * Date: 18.12.2022
     * Logic: Create entry in stock when adding a grn
     * @param  mixed $stockHistory
     * @param  mixed $create
     * @return Stock
     */


    public function createMatureStock($stockHistory, $create, $grnCode, $locationCode): Stock
    {

        try {
            DB::beginTransaction();

            $stock_code = TransactionCode::STOCK;
            $max_code = Stock::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
            $stock = Stock::create([
                'code' => $stock_code . $max_id,
                'item_code' => $stockHistory['itemCode'],
                'grn_code' => $grnCode,
                'batch' => $stockHistory['batch'] ?? null,
                'stock_location_code' => $locationCode,
                'remaining_quantity' => -($stockHistory['quantity']),
                'wholesale_price' => $stockHistory['wholesalePrice'] ?? null,
                'retail_price' => $stockHistory['retailPrice'] ?? null,
                'dealer_price' => $stockHistory['dealerPrice'] ?? null,
                'least_price' => $stockHistory['leastPrice'] ?? null,
                'cost_price' => $stockHistory['costPrice'] ?? null,
                'discount_price' => $stockHistory['discountPrice'] ?? null,
                'discount' => $stockHistory['discount'] ?? null,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            $grn = Stock::where('item_code', '=', $stockHistory['itemCode'])
                    // ->where('remaining_quantity', '<=', 0)
                ->each(function ($oldRecord) {
                    $newRecord = $oldRecord->replicate();
                    $newRecord->setTable('mature_stocks');
                    $newRecord->save();
                    // $oldRecord->delete();
                });
            // $grn = Stock::where('item_code', $stockHistory['itemCode'])
            //     // ->where('remaining_quantity', '<=', 0)
            //     ->each(function ($oldRecord) {
            //         $newRecord = $oldRecord->replicate();
            //         $newRecord->setTable('mature_stocks');
            //         $newRecord->save();
            //         $oldRecord->delete();
            //     });

            DB::commit();

            return $stock;
        } catch (\Exception $e) {

            throw new Exception($e);
        }
    }
}