<?php

namespace App\Http\Controllers\Expense_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\Expense_Models\ExpensePayment;
use Illuminate\Support\Facades\DB;

class ExpensePaymentController extends Controller
{
    public function index()
    {
        try {
            $expenses  = ExpensePayment::select('code','expense_code', 'payment_type_code','bank_code','amount','payment_date','cheque_date','cheque_number','ref_number')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'expensesPayment' =>  $expenses]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $expenses  = ExpensePayment::select('code','expense_code', 'payment_type_code','bank_code','amount','payment_date','cheque_date','cheque_number','ref_number')
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();
            return response()->json(['status' => 200, 'expensesPayment' =>  $expenses]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
           
            $expenses_code = TransactionCode::EXPENSES_PAYMENT;
            $cus_code = ExpensePayment::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            DB::beginTransaction();
            $expenses = ExpensePayment::create([

                'code' => $expenses_code.$max_id,
                'expense_code'=>$request->expense_code,
                'payment_type_code'=>$request->payment_type_code,
                'bank_code'=>$request->bank_code,
                'amount '=>$request->amount,
                'payment_date'=>$request->payment_date,
                'cheque_date'=>$request->cheque_date,
                'cheque_number'=>$request->cheque_number,
                'ref_number'=>$request->ref_number,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expenses Payment created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            
            DB::beginTransaction();
            $expenses = ExpensePayment::where('code', $id)->first();
            $expenses->update([
                'expense_code'=>$request->expense_code,
                'payment_type_code'=>$request->payment_type_code,
                'bank_code'=>$request->bank_code,
                'amount '=>$request->amount,
                'payment_date'=>$request->payment_date,
                'cheque_date'=>$request->cheque_date,
                'cheque_number'=>$request->cheque_number,
                'ref_number'=>$request->ref_number,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expenses Payment updated"]);
        } catch (\Exception $e) {
            DB::rollBack();

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $expenses = ExpensePayment::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $expenses->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Expenses Payment - Deleted"
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
