<?php

namespace App\Http\Controllers\Expense_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\Expense_Models\ExpenseCategory;
use App\Models\Expense_Models\ExpenseType;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class ExpenseCategoryController extends Controller
{
    public function index()
    {
        try {
            $expenseCategory  = ExpenseCategory::select('code', 'name','description')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'expenseCategory' =>  $expenseCategory]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $expenseCategory  = ExpenseCategory::select('code', 'name','description')
            ->with(['expenseTypes' => function ($query) {
                $query->select('code','name','expense_category_code' )
                ->where('is_active', '=', 1);
            }])
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();
            return response()->json(['status' => 200, 'expenseCategory' =>  $expenseCategory]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            // $validator = Validator::make($request->all(), [
            //     'name' => 'required|unique:expense_categories',
            // ]);

            // if ($validator->fails()) {
            //     return response()->json([
            //         'status' => 401,
            //         'errors' => $validator->errors(),
            //     ], 422);
            // }

            DB::beginTransaction();
            $expense_code = TransactionCode::EXPENSES_CATEGORY;
            $cus_code = ExpenseCategory::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $ExpenseCategory = ExpenseCategory::create([

                'code' => $expense_code.$max_id,
                //'expense_type_code'=>$request->expense_type_code,
                'name' => $request->name,
                'description'=>$request->description,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);
             if ($ExpenseCategory) {
                $expenseType = $request->expenseTypes;
                $this->addExpenseType($expenseType, $ExpenseCategory->code);
            }

            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expense Category created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function edit($id)
    {
        //
    }

    protected function addExpenseType($expenseType, $categoryCode)
    {
         try {
        if (count($expenseType) > 0) {
            foreach ($expenseType as $type) {
                $this->createExpenseType($type, $categoryCode);
            }
        }
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    protected function createExpenseType($type, $categoryCode)
    {
        try {
           
            DB::beginTransaction();
            $expense_code = TransactionCode::EXPENSES_TYPE_CODE;
            $cus_code = ExpenseType::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;


            ExpenseType::create([
                'code' => $expense_code. $max_id,
                'name' => $type['name'],
                //'description' => $request->description,
                'expense_category_code' => $categoryCode,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expense Category created"]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
           
            DB::beginTransaction();
            $ExpenseCategory = ExpenseCategory::where('code', $id)->first();
            $ExpenseCategory->update([
                'name' => $request->name,
                //'expense_type_code'=>$request->expense_type_code,
                'description'=>$request->description,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);

            if ($ExpenseCategory) {
                $expenseType = $request->expenseTypes;
                $this->updateExpenseType($expenseType, $ExpenseCategory->code);
            }

            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expense Category updated"]);
        
        } catch (\Exception $e) {
            DB::rollBack();

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    protected function updateExpenseType($expenseType, $categoryCode)
    {
        try {
            
            DB::beginTransaction();
            foreach ($expenseType as $type) {
                $expenseType = "";
                if (isset($type['code'])) {

                    $expenseType = ExpenseType::select('id', 'code', 'expense_category_code', 'name')
                        ->where('code', $type['code'])
                        ->where('expense_category_code', $categoryCode)
                        ->first();

                    $expenseType->update([
                        'name' => $type['name'],
                        'expense_category_code' => $categoryCode,
                        //'description' => $category['description'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow()

                    ]);
                } else {
                    $this->createExpenseType($type, $categoryCode);
                }
            }
            DB::commit();
            return response()->json(['status' => 200, 'message' => "Expense Category updated"]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $ExpenseCategory = ExpenseCategory::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $ExpenseCategory->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Expenses Types - Deleted"
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

}
