<?php

namespace App\Http\Controllers\E_Commerce_Controller;

use App\Http\Controllers\Controller;
use App\Models\Stock_Models\Stock;
use Illuminate\Http\Request;

class stockEcomController extends Controller
{
    //
    public function index()
    {
        try {
            $stock = Stock::select('id','item_code','cost_price', 'retail_price','dealer_price','least_price','wholesale_price', 'remaining_quantity', 'is_active')
            ->with([
                'itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])
                ->where('is_active', '=', 1)
                ->get();
                return $stock;
            //return response()->json(['status' => 200, 'stock' => $stock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $stock = Stock::select('id','item_code','cost_price', 'retail_price','dealer_price','least_price','wholesale_price', 'remaining_quantity', 'is_active')
            ->with([
                'itemMaster' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])   
            ->where('is_active', '=', 1)
                ->where('id', $id)
                ->first();

                return $stock;

            //return response()->json(['status' => 200, 'items' => $stock]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
