<?php

namespace App\Http\Controllers\E_Commerce_Controller;

use App\Http\Controllers\Controller;
use App\Models\Item_Models\ItemMaster;
use Exception;
use Illuminate\Http\Request;

class ItemEcomController extends Controller
{
    //
    public function index()
    {
        try {
            $items = ItemMaster::select('id','code', 'reference_code', 'barcode', 'name', 'description', 'category_code', 'sub_category_code', 'unit_code', 'brand_code', 'color_code', 'bin_location_code', 'wholesale_price', 'retail_price', 'dealer_price', 'least_price', 'cost_price', 'model', 'min_stock', 'max_stock', 'reorder_stock', 'expiry_notification_days', 'is_service')
                ->where('is_active', '=', 1)
                ->get();
                return $items;
            //return response()->json(['status' => 200, 'items' => $items]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $item = ItemMaster::select(
                'id',
                'code',
                'reference_code',
                'barcode',
                'name',
                'description',
                'category_code',
                'sub_category_code',
                'unit_code',
                'brand_code',
                'color_code',
                'bin_location_code',
                'wholesale_price',
                'retail_price',
                'dealer_price',
                'least_price',
                'cost_price',
                'model',
                'min_stock',
                'max_stock',
                'reorder_stock',
                'is_service',
                'expiry_notification_days',
                'size'
            )
                ->with([
                    'itemCategory' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemSubCategory' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemUnit' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemBrand' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemColor' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'itemBinLocation' => function ($query) {
                        $query->select('code', 'location')->where('is_active', '=', 1);
                    }
                ])
                ->where('id', $id)
                ->where('is_active', '=', 1)
                ->first();
                return $item;
            //return response()->json(['status' => 200, 'item' => $item]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
}
