<?php

namespace App\Http\Controllers\Department_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Department_Models\Department;
use Illuminate\Http\Request;
use Exception;

class DepartmentController extends Controller
{
    //
    public function index()
    {
        try {
            $department  = Department::select('code', 'name')->where('is_active', '=', 1)->get();

            return response()->json(
                ['status' => 200, 'Department' =>
                $department]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function departmentSearch($key)
    {
        try {

            $department  = Department::select('code', 'name', )
                ->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                          ->orWhere('name', 'like', "%$key%");                
                })->get();
            return response()->json([
                'status' => 200,
                'department' =>  $department
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $department  = Department::select('code', 'name')
                ->where('is_active', '=', 1)
                ->where('code', '=', $id)->get();
            return response()->json(
                [
                    'status' => 200,
                    'Department' =>  $department
                ]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
