<?php

namespace App\Http\Controllers\DashboardControllers;

use Exception;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Enums\MultiPurposeStatus;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Invoice_Models\Invoice;


class DashboardController extends Controller
{
    //
    /**
     * yesterdayS Sales
     * logic: location based Yestedy sales total
     * Author: Aasif Saneeth
     * Date : 2024.03.11
     * version : 01
     * @param  mixed $request
     * @return void
     */
    public function YesterdaySalesByLocation(Request $request)
    {
        try {

            $yesterday = Carbon::yesterday();

            $yesterdaySales = Invoice::select(
                'code',
                'series_code',
                'stock_location_code',
                'invoice_number',
                'date_time',
                'customer_code',
                'discount_percentage',
                'bill_discount',
                'discount_amount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'total_amount',
                'paid_status',
                'status'
            )->with([
                'stockHistories' => function ($query) {
                    $query->where('is_active', '=', 1);
                }
            ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                // ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate) - 1), date('Y-m-d H:m:s', strtotime($request->toDate))])
                ->whereDate('date_time', Carbon::yesterday())

                ->get();

            $totalAmountSum = $yesterdaySales->sum('total_amount');


            return response()->json([
                'status' => 200,
                'salesDetails' => $yesterdaySales,
                'totalSales' => $totalAmountSum
            ], 200);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function TodaySalesByLocation(Request $request)
    {
        try {
            $today = Carbon::today();

            $todaySales = Invoice::select(
                'code',
                'series_code',
                'stock_location_code',
                'invoice_number',
                'date_time',
                'customer_code',
                'discount_percentage',
                'bill_discount',
                'discount_amount',
                'discount_total',
                'paid_amount',
                'sub_total_amount',
                'total_amount',
                'paid_status',
                'status'
            )
                ->with([
                    'stockHistories' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->select('code', 'name')->where('is_active', '=', 1);
                    }
                ])
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->where('status', '<>', MultiPurposeStatus::REVERSED)
                // ->whereBetween('date_time', [date('Y-m-d H:m:s', strtotime($request->fromDate) ), date('Y-m-d H:m:s', strtotime($request->toDate))])
                ->whereDate('date_time', now()->toDateString())
                ->get();

            $totalAmountSum = $todaySales->sum('total_amount');

            return response()->json([
                'status' => 200,
                'salesDetails' => $todaySales,
                'totalSales' => $totalAmountSum
            ], 200);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function monthSalesByLocation(Request $request)
    {
        $stockLocationCode = getCurrentLocationCode($request);
        try {
            // Get current month and year
            $currentMonth = date('m');
            $currentYear = date('Y');

            $sql = "SELECT STR_TO_DATE(invoices.date_time, '%Y-%m-%d') AS Date,
                       SUM(invoices.total_amount) AS invoiceTotal,
                       SUM((sh.unit_sold_price - sh.cost_price) * sh.quantity) AS totalProfit
                FROM invoices
                LEFT JOIN (SELECT quantity, unit_sold_price, cost_price, source_code
                           FROM stock_histories
                           WHERE source = 2) AS sh ON sh.source_code = invoices.code
                WHERE MONTH(invoices.date_time) = $currentMonth
                  AND YEAR(invoices.date_time) = $currentYear
                  AND invoices.status <> 5
                  AND invoices.stock_location_code = $stockLocationCode
                GROUP BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')
                ORDER BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')";

            $results = DB::select($sql);
            return response()->json(['status' => 200, 'results' => $results], 200);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }

    public function annualSales(Request $request)
    {
        $stockLocationCode = getCurrentLocationCode($request);
        try {
            // Get current month and year

            $currentYear = date('Y');

            $sql = "SELECT STR_TO_DATE(invoices.date_time, '%Y-%m-%d') AS Date,
                       SUM(invoices.total_amount) AS invoiceTotal,
                       SUM((sh.unit_sold_price - sh.cost_price) * sh.quantity) AS totalProfit
                FROM invoices
                LEFT JOIN (SELECT quantity, unit_sold_price, cost_price, source_code
                           FROM stock_histories
                           WHERE source = 2) AS sh ON sh.source_code = invoices.code
                WHERE
                   YEAR(invoices.date_time) = $currentYear
                  AND invoices.status <> 5
                  AND invoices.stock_location_code = $stockLocationCode
                GROUP BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')
                ORDER BY STR_TO_DATE(invoices.date_time, '%Y-%m-%d')";

            $results = DB::select($sql);
            return response()->json(['status' => 200, 'results' => $results], 200);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }


    // public function annualSales(Request $request)
    // {
    //     try {
    //         $today = Carbon::today();

    //         $currentAnnualSales = Invoice::select(
    //             'code',
    //             'series_code',
    //             'stock_location_code',
    //             'invoice_number',
    //             'date_time',
    //             'customer_code',
    //             'discount_percentage',
    //             'bill_discount',
    //             'discount_amount',
    //             'discount_total',
    //             'paid_amount',
    //             'sub_total_amount',
    //             'total_amount',
    //             'paid_status',
    //             'status'
    //         )->with([
    //             'stockHistories' => function ($query) {
    //                 $query->where('is_active', '=', 1);
    //             }
    //          ])
    //             ->with([
    //                 'stockLocation' => function ($query) {
    //                     $query->select('code', 'name')->where('is_active', '=', 1);
    //                 }
    //             ])
    //             ->where('stock_location_code', '=', getCurrentLocationCode($request))
    //             ->where('status', '<>', MultiPurposeStatus::REVERSED)
    //             ->whereYear('date_time', $today->year)   // Filter by current year
    //             ->get();

    //         $totalAmountSum = $currentAnnualSales->sum('total_amount');

    //         return response()->json([
    //             'status' => 200,
    //             'salesDetails' => $currentAnnualSales,
    //             'totalSales' => $totalAmountSum
    //         ], 200);
    //     } catch (\Exception $e) {
    //         throw new Exception($e);
    //     }
    // }




}
