<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\TypeCustomer;



class TypeCustomerController extends Controller
{

    public function index()
    {
        try{
            // return response()->Json(Customer::get(),200);

             $customers  = TypeCustomer::select('customer_code','type_code')
             ->where('is_active', '=', 1)
             ->get();
             return response()->json([
                 'status' => 200,
                 'customer' =>  $customers
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    public function show($id)
    {
        try{
            //return response()->Json(Customer::find($id),200);
               $customer = TypeCustomer::select('customer_code','type_code')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)
               ->first();
               return response()->json([
                   'status' => 200,
                   'customer' =>  $customer
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{

            $customer = TypeCustomer::create([
            'customer_code'=>$request->customer_code,
            'type_code'=>$request->type_code,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow()

        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Customer Type - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }





    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{

            $customer= TypeCustomer::findOrFail($id);
            $customer->update([
                'customer_code'=>$request->customer_code,
                'type_code'=>$request->type_code,
                'updated_by'=>getUserCode(),
                'updated_at'=>getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=> 'Type Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }


    public function destroy($id)
    {
        try{
            $type = TypeCustomer::select('id','is_active')->findOrFail($id);
            $type->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Type - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }

    }
}
