<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Enums\DefaultValues;
use App\Enums\FreezeStatus;
use App\Enums\MultiPurposeStatus;
use App\Enums\TransactionCode;
use App\Enums\StockHistorySource;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Customer_Models\SalesOrder;
use App\Models\Stock_Models\StockHistoryTemp;
use App\Models\Customer_Models\SalesOrderData;
use App\Models\Stock_Models\Stock;
use App\Models\Stock_Models\StockHistory;
use Exception;
use Illuminate\Support\Facades\DB;

class SalesOrderController extends Controller
{

    public function index()
    {
        try {

            $salesOrders = SalesOrder::select(
                'code',
                'customer_code',
                'stock_location_code',
                'sub_total_amount',
                'discount_amount',
                'discount_percentage',
                'order_discount',
                'total_amount',
                'remarks',
                'status',
                'order_date',
                'is_active',
                'created_by',
                'updated_by',
                'created_at',
                'updated_at')


             ->with([
                    'stockHistoryTemps' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ]) ->with([
                    'stockHistoryTemps.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])->with([
                    'stockHistoryTemps.itemMaster.stocks' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->orderBy('created_at', 'DESC')
                ->get();
            return response()->json(['status' => 200, 'salesOrders' => $salesOrders]);
        } catch (Exception $e) {
            return response(['status' => 500, 'Message' => $e]);
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {
            $salesOrder = SalesOrder::select(
            'code',
            'customer_code',
            'stock_location_code',
            'sub_total_amount',
            'discount_amount',
            'discount_percentage',
            'order_discount',
            'total_amount',
            'remarks',
            'order_date',
            'is_active',
            'status',
            'created_by',
            'updated_by',
            'created_at',
            'updated_at')


            ->with([
                    'stockHistoryTemps' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistoryTemps.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                        'stockHistoryTemps.itemMaster.stocks' => function ($query) {
                            $query->where('is_active', '=', 1);
                    }

                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },

                        'customer.customerAddresses' => function ($query) {
                            $query->where('is_active', '=', 1);
                    },

                    'customer.route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])


                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('code', $id)
                ->where('is_active', '=', 1)
                ->first();

            return response()->json(['status' => 200, 'salesOrder' => $salesOrder]);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }

    public function salesOrderSearcForDelivery($key)
    {
        try {
            $salesOrder = SalesOrder::select(
            'code',
            'customer_code',
            'stock_location_code',
            'sub_total_amount',
            'discount_amount',
            'discount_percentage',
            'order_discount',
            'total_amount',
            (DB::raw('stocks.remaining_quantity - stocks.order_quantity as availableQuantity')),
            'remarks',
            'status',
            'order_date',
            'is_active',
            'created_by',
            'updated_by',
            'created_at',
            'updated_at')


            ->with([
                    'stockHistoryTemps' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistoryTemps.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'StockHistoryTemps.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'StockHistoryTemps.itemMaster.stocks' => function ($query) {
                        $query->select(
                            'code',
                            'item_code',
                            'code as stockCode',
                            'remaining_quantity',
                            'order_quantity',
                            'wholesale_price',
                            'retail_price',
                            'cost_price',
                            'stock_location_code',
                        );
                    }
                ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])->with([
                    'deliveryOrders' => function($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'deliveryOrders.stockHistories' => function($query) {
                        $query->where('is_active', '=', 1);

                    },
                    'deliveryOrders.stockHistories.itemMaster' => function($query) {
                        $query->where('is_active', '=', 1);

                    }
                ])
                ->where('code', 'like', "%$key%")
                ->where('is_active', '=', 1)
                ->where('status', '=', 1)
                ->first();

            return response()->json([
                'status' => 200,
                'salesOrder' => $salesOrder
            ]);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }


    public function salesOrderSearchwithStock($key)
    {
        try {
            $salesOrder = SalesOrder::select(
            'code',
            'customer_code',
            'stock_location_code',
            'sub_total_amount',
            'discount_amount',
            'discount_percentage',
            'order_discount',
            'total_amount',
            'remarks',
            'order_date',
            'is_active',
            'created_by',
            'updated_by',
            'created_at',
            'updated_at')


            ->with([
                    'stockHistoryTemps' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'stockHistoryTemps.itemMaster' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'StockHistoryTemps.itemMaster.itemUnit' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customer' => function ($query) {
                        $query->where('is_active', '=', 1);
                    },
                    'customer.customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'StockHistoryTemps.itemMaster.stocks' => function ($query) {
                        $query->select(
                            'code',
                            'item_code',
                            'code as stockCode',
                            'remaining_quantity',
                            'order_quantity',
                            'wholesale_price',
                            'retail_price',
                            'cost_price',
                            'stock_location_code',
                        );
                    }
                ])
                ->with([
                    'stockLocation' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('code', 'like', "%$key%")
                ->where('status', '=', 1)
                ->where('is_active', '=', 1)
                ->get();

            return response()->json([
                'status' => 200,
                'salesOrder' => $salesOrder
            ]);
        } catch (Exception $e) {
            throw new Exception($e);
        }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)

    {
       //try
        {
           DB::beginTransaction();
            $sales = TransactionCode::SALES_ORDER;
            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr("$stockLocationCode", -2);
            $max_code = SalesOrder::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->max('code');

            //$max_code = SalesOrder::max('code');
            //$max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;
            $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code", 5) + 1;

            $salesOrder =  SalesOrder::create([
                'code' => $sales . $locationPrefix . $max_id,
                'customer_code' => $request['customer']['code'],
                'stock_location_code' => getCurrentLocationCode($request),
                'order_date' => getDateTimeNow(),
                'remarks' => $request->remarks,
                'sub_total_amount' => $request->subTotalAmount,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'order_discount' => $request->orderDiscount,
                'total_amount' => $request->totalAmount,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);

            if ($salesOrder) {
                $stockHistory_Temp = $request->stockHistoryTemps;
                if (count($stockHistory_Temp) > 0) {
                    foreach ($stockHistory_Temp as $stockHistoryTemp) {
                    //$this->addStockHistoryTemp($stockHistoryTemp, $salesOrder->code, StockHistorySource::SALES_ORDER, $stock );
                    // $this->stockUpdate($stockHistoryTemp);

                       $count = Stock::where('item_code', $stockHistoryTemp['itemMaster']['code'])
                       //->where('stock_location_code', $stockHistoryTemp['locationCode'] )
                       ->count();

                   if ($count > 0) {
                       $stock = Stock::select('id', 'code', 'item_code', 'stock_location_code', 'order_quantity')
                           ->where('item_code', '=', $stockHistoryTemp['itemMaster']['code'])
                           //->where('stock_location_code', '=', $stockHistoryTemp['locationCode'] )
                        //    ->where('wholesale_price', '=', $stockHistoryTemp['itemMaster']['wholesalePrice'])
                        //    ->Where('retail_price', '=', $stockHistoryTemp['itemMaster']['retailPrice'])
                        //    ->Where('cost_price', '=', $stockHistoryTemp['itemMaster']['costPrice'])
                           ->first();

                        $orderQuantity = $stock['order_quantity'];

                            //If the stock location code and logged in location code are same have to update  the remaining quantiy.
                        if ($stockLocationCode == $stock->stock_location_code) {
                            $orderQuantity = ($stock->order_quantity) + $stockHistoryTemp['quantity'];
                            $source = StockHistorySource::SALES_ORDER;

                        } else {
                            //If the stock location code and logged in location code are different have to update  the order quantity
                            $orderQuantity = ($stock->order_quantity) + $stockHistoryTemp['quantity'];
                            //$source = StockHistorySource::INVOICE_BUT_NOT_DELIVERD;
                        }

                       $stock->update([
                           'order_quantity' => ($orderQuantity),
                           'updated_by' => getUserCode(),
                           'updated_at' =>  getDateTimeNow()
                       ]);
                   }
                   $this->addStockHistoryTemp($stockHistoryTemp, $salesOrder->code, StockHistorySource::SALES_ORDER, $stock );

                    }
                }
            }
            DB::commit();
            return response()->json(['status' => 200, 'Message' => 'Sales Order Created']);
        }
        // catch (Exception $e) {
        //     DB::rollback();
        //     throw new Exception($e);
        // }
    }

    public function changeQuantity(Request $request) {
        try {
            DB::beginTransaction();

            // Extract selected values from the request
            $selectedValues = $request->all();

            foreach ($selectedValues as $selectedValue) {
                // Access properties using array notation
                $code = $selectedValue['code'];
                $quantity = $selectedValue['editQauntity'] ?? 0;

                $stockCode = $selectedValue['stockCode'];



                // Find the stock history record by code
                $stockHistoryTemp = StockHistoryTemp::where('code', $code)->first();
                $stock = Stock::where('code',$stockCode)->first();


                if ($stockHistoryTemp) {
                    // Update the quantities
                    $stockHistoryTemp->update([
                        'quantity' => $stockHistoryTemp->quantity + $quantity,
                        'remaining_quantity' => $stockHistoryTemp->remaining_quantity + $quantity,
                        'purchaser_order_remaining_quantity' => $stockHistoryTemp->purchaser_order_remaining_quantity - $quantity,
                    ]);
                }

                if($stock) {
                    $stock->update([
                        'order_quantity' =>$stock['order_quantity'] + $quantity
                    ]);
                }
            }

            DB::commit();
            return response()->json([
                'status' => 200,
                'selectedvalues' => $selectedValues
            ], 200);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => 500,
                'message' => $e->getMessage()
            ], 500);
        }
    }



    public function stockUpdate($stockHistoryTemp)
    {
        try {

           DB::beginTransaction();
            $count = Stock::where('item_code', $stockHistoryTemp['itemMaster']['code'])
                ->where('stock_location_code', $stockHistoryTemp['locationCode'] )->count();

            if ($count > 0) {
                $stock = Stock::select('id', 'item_code', 'stock_location_code', 'order_quantity')
                    ->where('item_code', '=', $stockHistoryTemp['itemMaster']['code'])
                    ->where('stock_location_code', '=', $stockHistoryTemp['locationCode'])
                    ->where('wholesale_price', '=', $stockHistoryTemp['itemMaster']['wholesalePrice'])
                    ->Where('retail_price', '=', $stockHistoryTemp['itemMaster']['retailPrice'])
                    ->Where('cost_price', '=', $stockHistoryTemp['itemMaster']['costPrice'])
                    ->first();

                $stock->update([
                    'order_quantity' => ($stock->order_quantity) + ($stockHistoryTemp['quantity']),
                    'updated_by' => getUserCode(),
                    'updated_at' =>  getDateTimeNow()
                ]);
            }
            DB::commit();
        } catch (Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }
    private function addStockHistoryTemp($stockHistoryTemp, $sourceCode, $source, $stock)
    {
        try {
            DB::beginTransaction();
            $order = TransactionCode::STOCK_HISTORY_TEMP;
            $max_code = StockHistoryTemp::max('code');
            $max_id = $max_code == null ? config('global.code_value') + 1 : substr("$max_code", 3) + 1;

            $stockHistoryTempp =  StockHistoryTemp::create([
                'code' => $order . $max_id,
                'item_code' => $stockHistoryTemp['itemMaster']['code'] ?? $stockHistoryTemp['itemCode'],
                'source_code' => $sourceCode,
                'stock_code' => $stock['code'],//'stock_code' => $stockHistoryTemp['stockCode'],
                'source' => $source,
                // 'item_remarks'=>$stockHistoryTemp["itemRemarks"] ?? null,
                //'stock_location_code' => $stockHistoryTemp['locationCode'],
                'wholesale_price' => $stockHistoryTemp['itemMaster']['wholesalePrice'] ?? $stockHistoryTemp['wholesalePrice'] ?? null,
                'retail_price' => $stockHistoryTemp['itemMaster']['retailPrice'] ?? $stockHistoryTemp['retailPrice'] ?? null,
                'dealer_price' => $stockHistoryTemp['itemMaster']['dealerPrice'] ?? null,
                'least_price' => $stockHistoryTemp['itemMaster']['leastPrice'] ?? null,
                'cost_price' => $stockHistoryTemp['costPrice'] ?? $stockHistoryTemp['itemMaster']['costPrice'] ?? null,
                'quantity' => $stockHistoryTemp['quantity'] ?? null,
                'remaining_quantity' =>$stockHistoryTemp['quantity'],
                'sub_total_amount' => $stockHistoryTemp['subTotalAmount'],
                'discount_amount' => $stockHistoryTemp['discountAmount'] ?? null,
                'discount_percentage' => $stockHistoryTemp['discountPercentage'] ?? null,
                'discount_total' => $discountTotal ?? null,
                'total_amount' => $stockHistoryTemp['totalAmount'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);


            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            throw new Exception($e);
        }
    }


    public function edit($id)
    {
        //
    }


    public function reversal(Request $request)
    {
        try {
            DB::beginTransaction();

            $salesOrderCode = $request->transactionCode;
            $stockLocationCode = getCurrentLocationCode($request);
            $salesOrder = SalesOrder::where('code', '=', $salesOrderCode)
            ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
            ->first();

            $exsitingQuantity = 0;
            $orderQuantity = 0;

            if($salesOrder)
            {
                $stock_history = StockHistoryTemp::where('source_code', '=', $salesOrderCode)
                ->where('is_active', '=', MultiPurposeStatus::ACTIVE)
                ->get();

                if (count($stock_history) > 0) {
                    foreach ($stock_history as $stockHistory) {

                      //  $itemCode = $stockHistory->itemCode ?: $stockHistory->itemMaster->code;
                       // $stockCode = $stockHistory->stockCode ?? '';
                        $stock = Stock::where('code', '=',  $stockHistory["stock_code"])
                        ->where('stock_location_code' , '=', $stockLocationCode)
                        ->first();
                        //return $stock;
                        if ($stock) {
                            // $stockHistoryQuantity = ($stockHistory->quantity);
                            // $stockQuantity = ($stock->order_quantity);


                            //If the stock location code and logged in location code are same have to update  the remaining quantiy.
                            // if ($stockLocationCode == $stock->stock_location_code)
                            // {
                            //     $stockQuantityUp = $stockQuantity - $stockHistoryQuantity;
                            //     $source = StockHistorySource::SALES_ORDER;

                            // }
                            // else {
                            //     //If the stock location code and logged in location code are different have to update  the order quantity
                            //     $stockQuantityUp = $stockQuantity - $stockHistoryQuantity;
                            // }

                            $stock->update([
                                'order_quantity' =>  $stock["order_quantity"] -  $stockHistory["quantity"],
                                'updated_by' => getUserCode(),
                                'updated_at' => getDateTimeNow(),
                            ]);
                            $exsitingQuantity =  $stock["order_quantity"];
                            $orderQuantity =  $stockHistory["quantity"];
                        }
                    }
                }

                $salesOrder->update([
                    'status' => MultiPurposeStatus::REVERSED,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow(),
                ]);
            }



            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Sales Order Reversed",
                'stock'=>  $stock,
                'existingQauntit' => $exsitingQuantity,
                'orderQuantity' => $orderQuantity,
                // 'code' => $invoice->code,
                // 'dateTime' => $invoice->date_time,
            ], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }






    public function update(Request $request, $id)
    {
        // try
        // {
            DB::beginTransaction();
            $stockLocationCode = getCurrentLocationCode($request);


            $salesOrder = SalesOrder::where('code', $id)->first();
            $salesOrder->update([
                'customer_code' => $request['customer']['code'],
                //'rep_code' => $request->repCode,
                //'amount' => $request->amount,
                'sub_total_amount' => $request->subTotalAmount,
                'discount_amount' => $request->discountAmount,
                'discount_percentage' => $request->discountPercentage,
                'order_discount' => $request->orderDiscount,
                'total_amount' => $request->totalAmount,
                'order_date' => $request->orderDate,
                'remarks' => $request->remarks,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);
            $stock =  null;
            $existingStockHistory = null;
            if ($salesOrder) {
                $stockHistoryTemps = $request->stockHistoryTemps;
                if ( count($stockHistoryTemps) > 0) {
                    foreach ($stockHistoryTemps as $stockHistoryTemp) {

                            $existingStockHistoryCode = $stockHistoryTemp['code'] ?? null;
                            if( $existingStockHistoryCode) {
                                $stock = Stock::where('stock_location_code', '=', $stockLocationCode)
                                ->where('item_code', '=', $stockHistoryTemp['itemCode'])
                                ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                                ->first();
                                $existingStockHistory = StockHistoryTemp::where('code' ,$stockHistoryTemp['code'])->first();

                                $stock->update([
                                    'order_quantity'=>$stock['order_quantity'] -  $existingStockHistory['quantity']
                                ]);

                               $updatedStockHistoRyTemps = $this->updateStockHistoryTemp($stockHistoryTemp, $salesOrder->code, $stockLocationCode);

                               $stock->update([
                                'order_quantity'=>$stock['order_quantity'] +  $updatedStockHistoRyTemps['quantity']
                            ]);

                            }else {
                                $stock = Stock::where('stock_location_code', '=', $stockLocationCode)
                                ->where('item_code', '=', $stockHistoryTemp['itemCode'])
                                ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                                ->first();
                                $stock->update([
                                    'order_quantity'=>$stock['order_quantity'] +  $stockHistoryTemp['quantity']
                                ]);

                                $this->addStockHistoryTemp($stockHistoryTemp, $salesOrder->code, StockHistorySource::SALES_ORDER, $stock );
                            }




                    //    $stock->update([

                    //     'order_quantity' =>  $stock["order_quantity"] - $stockHistoryTemp['quantity']
                    //    ]);




                    //    $stock->update([

                    //     'order_quantity' =>  $stock["order_quantity"] + $updatedStockHistory['quantity']
                    //    ]);

                        //$existingStocksHistoryTemps = StockHistoryTemp;

                        // if($existingStockHistoryCode) {
                        //     $this->updateStockHistoryTemp($stockHistoryTemp, $salesOrder->code);

                        //     $stock = Stock::select(
                        //         'id',
                        //         'code',
                        //         'item_code',
                        //         'stock_location_code',
                        //         'remaining_quantity'
                        //     )
                        //         ->where('stock_location_code', '=', $stockLocationCode)
                        //         //->where('item_code', '=', $existingStockHistoryCode['itemCode'])
                        //         //->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                        //         ->first();
                        // }else {
                        //     $stockLocationCode = getCurrentLocationCode($request);
                        //     $locationPrefix = substr("$stockLocationCode", -2);
                        //     $stock = Stock::select('id', 'code', 'item_code', 'stock_location_code', 'order_quantity')
                        //     ->where('item_code', '=', $stockHistoryTemp['itemMaster']['code'])
                        //     //->where('stock_location_code', '=', $stockHistoryTemp['locationCode'] )
                        //     ->where('wholesale_price', '=', $stockHistoryTemp['itemMaster']['wholesalePrice'])
                        //     ->Where('retail_price', '=', $stockHistoryTemp['itemMaster']['retailPrice'])
                        //     ->Where('cost_price', '=', $stockHistoryTemp['itemMaster']['costPrice'])
                        //     ->first();

                        //  $orderQuantity = $stock->order_quantity;


                        //     // $this->addStockHistoryTemp($stockHistoryTemp, $salesOrder->code, StockHistorySource::SALES_ORDER, $stock );
                        //     // $stock = $this->stockReset($request, $stockHistoryTemp, StockHistorySource::SALES_ORDER,$salesOrder);

                        // }


                    }

                }
            }

            DB::commit();

            return response()->json(['status' => 200,
            'Message' => 'Sales Order Updated',
            //'oldQuantity' =>$oldQuantity,
            // 'stockQuantity'=> $stock['order_quantity'],
            // 'StockHistoryQuanty'=>  $existingStockHistory['quantity']

        ]);

        // }
        // catch (Exception $e) {
        //     DB::rollback();
        //     throw new Exception($e);
        // }
    }

    private function updateStockHistoryTemp($stockHistoryTemp, $salesOrder_code, $stockLocationCode)
    {
        // try {
            DB::beginTransaction();

            $salesOrderData = StockHistoryTemp::where('code', $stockHistoryTemp['code'])
                ->where('source_code', $salesOrder_code)->first();
            if (isset($stockHistoryTemp['code'])) {

                // $stock = Stock::select(
                //     'id',
                //     'code',
                //     'item_code',
                //     'stock_location_code',
                //     'remaining_quantity'
                // )
                //     ->where('stock_location_code', '=', $stockLocationCode)
                //     ->where('item_code', '=', $stockHistoryTemp['itemCode'])
                //     ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                //     ->first();

                //     $stock->update([
                //        'order_quantity'=> $stock["order_quantity"] - $stockHistoryTemp['quantity']
                //     ]);

                     $salesOrderData->update([

                    'item_code' => $stockHistoryTemp['itemMaster']['code'] ?? $stockHistoryTemp['itemCode'],
                    //'stock_location_code' => $salesData['locationCode'] ,
                    'wholesale_price' => $stockHistoryTemp['itemMaster']['wholesalePrice'] ?? $stockHistoryTemp['wholesalePrice'] ?? null,
                    'retail_price' => $stockHistoryTemp['itemMaster']['retailPrice'] ?? $stockHistoryTemp['retailPrice'] ?? null,
                    'dealer_price' => $stockHistoryTemp['itemMaster']['dealerPrice'] ?? null,
                    'least_price' => $stockHistoryTemp['itemMaster']['leastPrice'] ?? null,
                    'cost_price' => $stockHistoryTemp['costPrice'] ?? $stockHistoryTemp['itemMaster']['costPrice'] ?? null,
                    'quantity' => $stockHistoryTemp['quantity'] ?? null,
                    'remaining_quantity' =>$stockHistoryTemp['quantity'],
                    'sub_total_amount' => $stockHistoryTemp['subTotalAmount'],
                    'discount_amount' => $stockHistoryTemp['discountAmount'] ?? null,
                    'discount_percentage' => $stockHistoryTemp['discountPercentage'] ?? null,
                    'discount_total' => $discountTotal ?? null,
                    'total_amount' => $stockHistoryTemp['totalAmount'],
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow()

                ]);

                // $stock->update([
                //     'order_quantity'=> $stock["order_quantity"] + $stockHistoryTemp['quantity']
                //  ]);

            }


            DB::commit();
            return  $salesOrderData;
        // } catch (Exception $e) {
        //     DB::rollback();
        //     throw new Exception($e);
        // }
    }


    public function stockReset($request, $stockHistory, $source, $salesOrder)
    {
        try {
            DB::beginTransaction();
            $stockLocationCode = getCurrentLocationCode($request);

                $stock = Stock::select(
                    'id',
                    'code',
                    'item_code',
                    'stock_location_code',
                    'remaining_quantity'
                )
                    ->where('stock_location_code', '=', $stockLocationCode)
                    ->where('item_code', '=', $stockHistory['itemCode'])
                    ->where('is_freeze', '=', FreezeStatus::NON_FREEZED)
                    ->first();

            if ($stock) {
                $stockHistoryExisting = StockHistoryTemp::select('code', 'quantity')
                    ->where('code', $stockHistory['code'])
                    ->first();

                if (!$stockHistoryExisting) //if the item is new
                {

                    $stockHistoryQuantity = $stockHistory['quantity'];
                    $stockRemainingQuantity = $stock->remaining_quantity;

                    if ($source === StockHistorySource::SALES_ORDER) {
                        $stockQuantityUp = $stockRemainingQuantity - $stockHistoryQuantity;
                    }
                    $stock->update([
                        'remaining_quantity' => $stockQuantityUp,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);

                    $stockHistory['remainingQuantity'] = $stockQuantityUp;
                    $this->addStockHistory($stockHistory, $salesOrder->code, StockHistorySource::SALES_ORDER, $stock);
                } else // if it has existing quantity
                {

                    $stockHistoryQuantity = ($stockHistoryExisting->quantity);
                    //Get the difference between existing stock history quantity and updated stock history quantity
                    // $stockHistory['quantity'] -> updated quantity
                    $stockHistoryDifference = $stockHistoryQuantity - $stockHistory['quantity'];
                    $stockQuantity = $stock->remaining_quantity;
                    if ($source === StockHistorySource::SALES_ORDER) {
                        $stockQuantityUp = $stockQuantity + ($stockHistoryDifference);
                    }
                    $stock->update([
                        'remaining_quantity' => $stockQuantityUp,
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);

                }
                DB::commit();
                return $stock;
            }
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function destroy($id)
    {
        //
    }
}
