<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\CustomerType;
use App\Enums\TransactionCode;



class CustomerTypeController extends Controller
{

    public function index()
    {
        try{

            $customer  = CustomerType::select('code','type')->get();
             return response()->json([
                 'status' => 200,
                 'customer' =>  $customer
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    public function show($id)
    {
        try{
            //return response()->Json(Customer::find($id),200);
               $customer = CustomerType::select('code','type')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'customer' =>  $customer
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {

        try{

            $customer_type_code =TransactionCode::CUSTOMER_TYPE_CODE;
            $cus_code = CustomerType::max('code');

            $max_id= $cus_code==null ? config('global.code_value')+1 : substr("$cus_code",3)+1;
             $customer = CustomerType::create([
            'code'=>$customer_type_code.$max_id,
            'type'=>$request->type,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow()

        ]);
        return response()->json([
            'status'=> 200,
            'message'=>' Type - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{

            $customer= CustomerType::findOrFail($id);
            $customer->update([
                'type'=>$request->type,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=> 'Type Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }


    public function destroy($id)
    {
        try{
            $type = CustomerType::select('id','is_active')->findOrFail($id);
            $type->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Type - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }

    }
}
