<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\CustomerShippingAddress;
use Illuminate\Support\Carbon;

class CustomerShippingAddressController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        try{
             $customersShippingAddress = CustomerShippingAddress::select('customer_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
             ->where('is_active', '=', 1)
             ->get();
             return response()->json([
                 'status' => 200,
                 'customer' =>  $customersShippingAddress
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function show($id)
    {
        try{

               $CustomerShippingAddress = CustomerShippingAddress::select('customer_code','first_name','second_name','company_name','phone_1','phone_2','address','city','district','province','postcode','order_notes')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'customer' =>  $CustomerShippingAddress
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            //$current_date_time = Carbon::now()->toDateTimeString();
            $CustomerShippingAddress = CustomerShippingAddress::create([
            'customer_code'=>$request->customer_code,
            'first_name'=>$request->first_name  ,
            'second_name'=>$request->second_name  ,
            'company_name'=>$request->company_name  ,
            'phone_1'=>$request-> phone_1 ,
            'phone_2'=>$request->phone_2  ,
            'address'=>$request->address  ,
            'city'=>$request->city  ,
            'district'=>$request->district  ,
            'province'=>$request-> province ,
            'postcode'=>$request->postcode  ,
            'order_notes'=>$request->order_notes  ,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow()
         
        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Customer Billig - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{

            $CustomerShippingAddress= CustomerShippingAddress::findOrFail($id);
            $CustomerShippingAddress->update([
                'customer_code'=>$request->customer_code,
                'first_name'=>$request->first_name  ,
                'second_name'=>$request->second_name  ,
                'company_name'=>$request->company_name  ,
                'phone_1'=>$request-> phone_1 ,
                'phone_2'=>$request->phone_2  ,
                'address'=>$request->address  ,
                'city'=>$request->city  ,
                'district'=>$request->district  ,
                'province'=>$request-> province ,
                'postcode'=>$request->postcode  ,
                'order_notes'=>$request->order_notes  ,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);
            return response()->json(['status'=> 200, 'message'=> 'Customer Billing Address Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $CustomerShippingAddress = CustomerShippingAddress::select('id','is_active')->findOrFail($id);
            $CustomerShippingAddress->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Customer Billing Address - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
