<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Function_Controllers\SmsFunction;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\Customer;
use App\Models\Stock_Models\Route;
use App\Models\Customer_Models\CustomerType;
use App\Models\Stock_Models\SalesRep;
use App\Models\Customer_Models\CustomerAddress;
use App\Models\Customer_Models\CustomerContact;
use App\Enums\TransactionCode;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class CustomerController extends Controller
{
    private $sms_function;

    public function __construct()
    {

        $this->sms_function = new SmsFunction();

    }

    public function index()
    {
        try {
            $customers = Customer::select(
                'code',
                'stock_location_code',
                'custom_code',
                'route_code',
                'company_name',
                'title',
                'first_name',
                'second_name',
                'phone_1',
                'customer_type_code',
                'phone_2',
                'email',
                'website',
                'credit_limit',
                'credit_amount',
                'cheque_return_amount',
                'credit_days',
                'username',
                'password',
                'passport_number',
                'nic_number',
                'rating',
                'notes',
                'is_active'
            )
                ->with([
                    'customerType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'vehicleMasters.vehicleType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'vehicleMasters.vehicleBrand' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'route' => function ($query) {
                        $query->select(
                            'rep_code',
                            'route.code',
                            'name'
                        )->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'route.salesRep' => function ($query) {
                        $query->select(

                            'code',
                            'username'
                        )->where('is_active', '=', 1);
                    }
                ])
               //->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->where('is_active', '=', 1)
                ->get();
            return response()->json([
                'status' => 200,
                'customer' => $customers
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    /**
     * customerSearch
     * Author : Suhail Jamaldeen
     * Date : 2022.12.02
     * Version : 2
     * Logic : Customer Search by letters
     * @param  mixed $key
     * @return void
     */
    public function customerSearch($key)
    {
        try {

            $customers = Customer::select(
                'customers.code',
                'route_code',
                'stock_location_code',
                'custom_code',
                'cheque_return_amount',
                'over_payment',
                'credit_amount',
                'customer_type_code',
                'company_name',
                'title',
                'first_name',
                'second_name',
                'credit_limit',
                'return_amount',
                'cheque_return_amount',
                'credit_days',
                'nic_number',
                'phone_1',
                'phone_2'
            )
                ->with([
                    'customerType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'route.salesRep' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where(function ($query) use ($key) {
                    $query->Where('customers.code', 'like', "%$key%")
                        ->orWhere('customers.custom_code', 'like', "%$key%")
                        ->orWhere('customers.first_name', 'like', "%$key%")
                        ->orWhere('customers.phone_1', 'like', "%$key%")
                        ->orWhere('customers.phone_2', 'like', "%$key%");
                })
                ->orWhere(function ($query) use ($key) {
                    $query->whereHas(
                            'customerAddresses',
                            function ($query) use ($key) {
                                $query
                                 ->Where('phone_1','like', "%$key%")
                                ->orWhere('phone_2', 'like', "%$key%");
                            }
                        );
                    })
                ->where([['customers.is_active', '=', 1]])
                // ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();

            return response()->json([
                'status' => 200,
                'customer' => $customers
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function show($id)
    {
        try {

            $customer = Customer::select(
                'code',
                'custom_code',
                'route_code',
                'company_name',
                'title',
                'first_name',
                'second_name',
                'phone_1',
                'customer_type_code',
                'phone_2',
                'email',
                'website',
                'credit_limit',
                'credit_amount',
                'credit_days',
                'username',
                'password',
                'passport_number',
                'nic_number',
                'rating',
                'notes',
                'is_active',
                'is_verified'
            )

                ->with([
                    'customerType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'customerAddresses' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'customerContacts' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'vehicleMasters.vehicleType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'vehicleMasters.vehicleBrand' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'route' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->with([
                    'salesReturns' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])

                ->where('is_active', '=', 1)
                ->where('code', $id)
                ->first();
            return response()->json([
                'status' => 200,
                'customer' => $customer,
                //'customerAddress'=>$customerAddress

            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function create()
    {
    }

    public function store(Request $request)
    {

        DB::beginTransaction();
        // try {
            $customer_code = TransactionCode::CUSTOMER_CODE;
            $cus_code = Customer::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $customer = Customer::create([
                'code' => $customer_code . $max_id,
                'custom_code' => $request->customCode,
                //'rep_code' => $request->rep['code'] ?? null,
                'stock_location_code'=> getCurrentLocationCode($request),
                'route_code' => $request->route['code'] ?? null,
                'customer_type_code' => $request->customerType != null ? $request->customerType['code'] : null,
                'company_name' => $request->companyName,
                'first_name' => $request->firstName,
                'title'=> $request->title,
                'second_name' => $request->secondName,
                'phone_1' => $request->phone1,
                'phone_2' => $request->phone2,
                'email' => $request->email,
                'website' => $request->website,
                'credit_limit' => $request->creditLimit,
                'invoice_total' => 0,
                'received_amount' => 0,
                'over_payment' => 0,
                'credit_amount' => 0,
                'return_amount' => 0,
                'cheque_return_amount' => 0,
                'credit_days' => $request->creditDays,
                'username' => $request->username,
                'password' => $request->password,
                'passport_number' => $request->passportNumber,
                'nic_number' => $request->nicNumber,
                'rating' => $request->rating,
                'notes' => $request->notes,
                'fax' => $request->fax,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            if ($customer) {

                $customerAddresses = $request->customerAddresses;
                $customerContact = $request->customerContacts;

                $this->addCustomerAddress($customerAddresses, $customer->code);
                $this->addCustomerContact($customerContact, $customer->code);

                DB::commit();
                return response()->json([
                    'status' => 200,
                    'message' => "Customer Created",
                    'code' => $customer_code . $max_id,

                ], 200);
            }
        // } catch (\Exception $e) {
        //     DB::rollBack();

        //     throw new Exception($e);
        // }
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {

        try {
            DB::beginTransaction();

            $customer = Customer::select('id', 'code')->where('code', $id)->first();
            $customer->update([
                'custom_code' => $request->customCode,
                // 'rep_code' => $request->repCode,
                'route_code' => $request->route['code'] ?? null,
                'customer_type_code' => $request->customerType != null ? $request->customerType['code'] : null,
                'company_name' => $request->companyName,
                'title'=> $request->title,
                'first_name' => $request->firstName,
                'second_name' => $request->secondName,
                'phone_1' => $request->phone1,
                'phone_2' => $request->phone2,
                'email' => $request->email,
                'website' => $request->website,
                'credit_days' => $request->creditDays,
                'credit_limit' => $request->creditLimit,
                'username' => $request->username,
                'password' => $request->password,
                'passport_number' => $request->passportNumber,
                'nic_number' => $request->nicNumber,
                'rating' => $request->rating,
                'notes' => $request->notes,
                'is_active' => $request->isActive,
                'fax' => $request->fax,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);
            if ($customer) {

                $customerAddresses = $request->customerAddresses;
                $customerContact = $request->customerContacts;


                $this->updateCustomerAddress($customerAddresses, $customer->code);
                $this->updateCustomerContact($customerContact, $customer->code);



                DB::commit();
                return response()->json([
                    'status' => 200,
                    'message' => "Customer Updated",

                ], 200);
            }
        } catch (\Exception $e) {

            DB::rollBack();
            throw new Exception($e);
        }
    }

    public function destroy($id)
    {
        try {
            $customer = Customer::select('id', 'is_active')->findOrFail($id);
            $customer->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Customer- Deleted"
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    protected function addCustomerAddress($customerAddresses, $customer_code)
    {


        try {

            // if ($customerAddresses[0]['firstName']) {
            //     foreach ($customerAddresses as $address) {
            //         $this->createSingleAddress($address, $customer_code);
            //     }
            // }
            foreach ($customerAddresses as $address) {
                $this->createSingleAddress($address, $customer_code);
            }
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    protected function updateCustomerAddress($customerAddresses, $customer_code)
    {
        try {
            DB::transaction(function () {
            });
            DB::beginTransaction();

            foreach ($customerAddresses as $address) {
                $customerAddress = "";

                if (isset($address['id'])) {
                    $customerAddress = CustomerAddress::select('id', 'customer_code')
                        ->where('id', $address['id'])
                        ->where('customer_code', $customer_code)
                        ->first();
                }


                if ($customerAddress) {
                    $customerAddress->update([
                        'first_name' => $address['firstName'],
                        'second_name' => $address['secondName'],
                        'email' => $address['email'],
                        'phone_1' => $address['phone1'],
                        'phone_2' => $address['phone2'],
                        'address' => $address['address'],
                        'country' => $address['country'],
                        'district' => $address['district'],
                        'city' => $address['city'],
                        'post_box' => $address['postBox'],
                        'is_active' => $address['isActive'],
                        //'company' => $address['company'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                } else {
                    $this->createSingleAddress($address, $customer_code);
                }
            }
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Customer Address created"
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    private function createSingleAddress($address, $customer_code)
    {

        try {
            DB::transaction(function () {
            });
            DB::beginTransaction();
            CustomerAddress::create([
                'customer_code' => $customer_code,
                'first_name' => $address['firstName'],
                'second_name' => $address['secondName'],
                'email' => $address['email'],
                'phone_1' => $address['phone1'],
                'phone_2' => $address['phone2'],
                'address' => $address['address'],
                'country' => $address['country'],
                'district' => $address['district'],
                'city' => $address['city'],
                'post_box' => $address['postBox'],
                //'company' => $address['company'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Customer Address created"
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    protected function addCustomerContact($customerContacts, $customer_code)
    {
        try {
            if (count($customerContacts) > 0) {

                foreach ($customerContacts as $contact) {
                    $this->createSingleContact($contact, $customer_code);
                }
            }
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    protected function updateCustomerContact($customerContacts, $customer_code)
    {
        try {

            DB::beginTransaction();
            foreach ($customerContacts as $contact) {
                $customerContacts = "";
                if (isset($contact['id'])) {
                    $customerContacts = CustomerContact::select('id', 'customer_code')
                        ->where('id', $contact['id'])
                        ->where('customer_code', $customer_code)
                        ->first();
                }


                if ($customerContacts) {
                    $customerContacts->update([
                        'full_name' => $contact['fullName'],
                        'phone_1' => $contact['phone1'],
                        'phone_2' => $contact['phone2'],
                        'email' => $contact['email'],
                        'is_active' => $contact['isActive'],
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);
                } else {
                    $this->createSingleContact($contact, $customer_code);
                }
            }
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Customer Address created"
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }

    protected function createSingleContact($contact, $customer_code)
    {
        try {
            DB::transaction(function () {
            });
            DB::beginTransaction();

            CustomerContact::create([
                'contacts_type_code' => 21110000001,
                'customer_code' => $customer_code,
                'full_name' => $contact['fullName'],
                'phone_1' => $contact['phone1'],
                'phone_2' => $contact['phone2'],
                'email' => $contact['email'],
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
            ]);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Customer Contact created"
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }
    public function outstandingSms(Request $request)
    {
        try {
            $customers = $request->customer;

            if (count($customers) > 0) {
                $customerDetails = collect(); // Initialize an empty collection to store customer details
                $phoneNumbers = []; // Initialize an array to store customer phone numbers

                foreach ($customers as $customerCode) {
                    $details = Customer::select(
                        'code',
                        'first_name',
                        'phone_1',
                        'credit_amount',
                        'title',
                    )
                    ->where('code', $customerCode)
                    ->first(); // Get the first matching record

                    if ($details && $details->phone_1 && $details->credit_amount !== null) {
                        // Assuming there's a method to send SMS to the customer
                        $this->sms_function->OutstandingSms($details);

                        // Add the customer's phone number to the array
                        $phoneNumbers[] = $details->phone_1;

                        // Add customer details to the collection
                        $customerDetails->push([
                            'code' => $details->code,
                            'first_name' => $details->first_name,
                            'phone_1' => $details->phone_1,
                            'credit_amount' => $details->credit_amount,
                            'title' => $details->title,
                        ]);
                    } else {
                        \Log::info('Skipping customer with null phone number:', ['customer' => $customerCode]);
                    }
                }

                return response()->json([
                    'status' => 200,
                    'message' => 'SMS sent successfully',
                    'numbers' => $phoneNumbers,
                    'data' => $customerDetails
                ]);
            }

            return response()->json([
                'status' => 400,
                'message' => 'No customers selected'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e->getMessage()
            ]);
        }
    }
}


