<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\CustomerContactsType;
use Illuminate\Support\Carbon;

class CustomerContactsTypeController extends Controller
{

    public function index()
    {
        try{
            // return response()->Json(Customer::get(),200);

             $customers  = CustomerContactsType::select('code','contact_type')->where('is_active', '=', 1)->get();
             return response()->json([
                 'status' => 200,
                 'customer' =>  $customers
             ]);


         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }


    public function show($id)
    {
        try{
            //return response()->Json(Customer::find($id),200);
               $customer = CustomerContactsType::select('code','contact_type')->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'customer' =>  $customer
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{

            $max_id= (1000+CustomerContactsType::max('id')+1);
            $customer = CustomerContactsType::create([

            'code'=>$max_id,
            'contact_type'=>$request->contact_type,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow()
                ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Customer Type - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }





    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{
           
            $customer= CustomerContactsType::findOrFail($id);
            $customer->update([
                'contact_type'=>$request->contact_type,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status'=> 200, 'message'=> 'Type Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function destroy($id)
    {
        try{
            $customer = CustomerContactsType::select('id','is_active')->findOrFail($id);
            $customer->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Contacts Type - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
