<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use App\Models\Customer_Models\CustomerContact;
use Illuminate\Support\Carbon;

class CustomerContactController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try{
             $customers  = CustomerContact::select('contacts_type_code','customer_code','full_name','phone_1','phone_2','email')
             ->where('is_active', '=', 1)->get();
             return response()->json([
                 'status' => 200,
                 'customer' =>  $customers
             ]);
         }catch (\Exception $e) {
             return response()->json([
                 'status'=> 500,
                 'message'=> $e
             ],500);
         }
    }

    public function show($id)
    {
        try{
               $customer = CustomerContact::select('contacts_type_code','customer_code','full_name','phone_1','phone_2','email')
               ->where( 'is_active', '=', 1)
               ->where('id', $id)->first();
               return response()->json([
                   'status' => 200,
                   'customer' =>  $customer
               ]);

           }catch (\Exception $e) {
               return response()->json([
                   'status'=> 500,
                   'message'=> $e
               ],500);
           }
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try{
            $customer = CustomerContact::create([
            'contacts_type_code'=>$request->contacts_type_code,
            'customer_code'=>$request->customer_code,
            'full_name'=>$request->full_name,
            'phone_1'=>$request->phone_1,
            'phone_2'=>$request->phone_2,
            'email'=>$request->email,
            'created_by' => getUserCode(),
            'created_at' => getDateTimeNow(),
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow()
         

        ]);
        return response()->json([
            'status'=> 200,
            'message'=>'Customer Contact - Created'
            ]);


        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try{
            //$current_date_time = Carbon::now()->toDateTimeString();
            $customer= CustomerContact::findOrFail($id);
            $customer->update([
            'contacts_type_code'=>$request->contacts_type_code,
            'customer_code'=>$request->customer_code,
            'full_name'=>$request->full_name,
            'phone_1'=>$request->phone_1,
            'phone_2'=>$request->phone_2,
            'email'=>$request->email,
            'updated_by' => getUserCode(),
            'updated_at' => getDateTimeNow(),

            ]);
            return response()->json(['status'=> 200, 'message'=> 'Customer Contact Updated']);

        } catch (\Exception $e) {


            return response()->json([
                'status'=> 500,
                'message'=> $e
            ],500);
        }
    }


    public function destroy($id)
    {
        try{
            $customer = CustomerContact::select('id','is_active')->findOrFail($id);
            $customer->update([
                'is_active'=>0
            ]);
            return response()->json([
                'status'=> 204,
                'message'=>"Customer Contact - Deleted"
                ]);


            }catch (\Exception $e) {
                return response()->json([
                    'status'=> 500,
                    'message'=> $e
                ],500);
            }
    }
}
