<?php

namespace App\Http\Controllers\Customer_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json;
use Illuminate\Support\Carbon;
use App\Models\Customer_Models\CustomerAddress;



class CustomerAddressController extends Controller
{


    public function index()
    {
        try {
            // return response()->Json(CustomerAddress::get(),200);

            $customers  = CustomerAddress::select('customer_code', 'first_name', 'second_name', 'email', 'phone_1', 'phone_2', 'address', 'district','country', 'city', 'post_box', 'company')
                ->where('is_active', '=', 1)->get();
            return response()->json([
                'status' => 200,
                'customers' =>  $customers
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            //return response()->Json(CustomerAddress::find($id),200);
            $customer = CustomerAddress::select('customer_code', 'first_name', 'second_name', 'email', 'phone_1', 'phone_2', 'address','district', 'country', 'city', 'post_box', 'company','is_active')
                ->where('is_active', '=', 1)
                ->where('id', $id)->first();
            return response()->json([
                'status' => 200,
                'customer' =>  $customer
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     *
     */
    public function create()
    {
        //
    }

    /**
     *
     *
     */
    public function store(Request $request)
    {
        try {
            // $current_date_time = Carbon::now()->toDateTimeString();
            $customer = CustomerAddress::create([
                'customer_code' => $request->customer_code,
                'first_name' => $request->first_name,
                'second_name' => $request->second_name,
                'email' => $request->email,
                'phone_1' => $request->phone_1,
                'phone_2' => $request->phone_2,
                'address' => $request->address,
                'country' => $request->country,
                'city' => $request->city,
                'post_box' => $request->post_box,
                'company' => $request->company,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
        
                //'updated_by' => $request->updated_by,
              


            ]);
            return response()->json([
                'status' => 200,
                'message' => 'Customer Address - Created'
            ]);
        } catch (\Exception $e) {


            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     *
     */

    public function edit($id)
    {
        //
    }

    /**
     *
     *
     */
    public function update(Request $request, $id)
    {
        try {

            $customer = CustomerAddress::findOrFail($id);
            $customer->update([
                'first_name' => $request->first_name,
                'second_name' => $request->second_name,
                'email' => $request->email,
                'phone_1' => $request->phone_1,
                'phone_2' => $request->phone_2,
                'address' => $request->address,
                'country' => $request->country,
                'city' => $request->city,
                'post_box' => $request->post_box,
                'company' => $request->company,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status' => 200, 'message' => 'Customer Address Updated']);
        } catch (\Exception $e) {


            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function destroy($id)
    {
        try {
            $type = CustomerAddress::select('id', 'is_active')->findOrFail($id);
            $type->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Customer Address - Deleted"
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
