<?php

namespace App\Http\Controllers\Bizx_User_Controllers;

use App\Http\Controllers\Controller;
use App\Models\System_Models\Role;
use Illuminate\Http\Request;

class MainNavigationController extends Controller
{

    public function getNavigationByRole1(Request $request)
    {
        $userRoleId = $request->key;
        $roleForMainNavigation = Role::with('mainNavigations')
            ->with('mainNavigations.levelOneNavigations')
            ->with('mainNavigations.levelOneNavigations.roles')
            ->with('mainNavigations.levelOneNavigations.levelTwoNavigations')
            ->with('mainNavigations.levelOneNavigations.roles')
            ->where('id', '=', $userRoleId)
            ->first();


        $roleReportNavigation = Role::with('reportMainNavigations')
            ->with('reportMainNavigations.levelOneNavigations')
            ->with('reportMainNavigations.levelOneNavigations.roles')
            ->where('id', '=', $userRoleId)
            ->first();

        return response()
            ->json([
                'status' => 200,
                'mainNavigation' => $roleForMainNavigation,
                'reportNavigation' => $roleReportNavigation
            ]);

    }

    public function getNavigationByRole12(Request $request)
    {
        $userRoleId = $request->key;
        $roleForMainNavigation = Role::with([
            'mainNavigations.levelOneNavigations' => function ($query) use ($userRoleId) {
                $query->where('is_active', '=', 1)
                    ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                        $roleQuery->where('roles.id', '=', $userRoleId);
                    });
            },
            'mainNavigations.levelOneNavigations.levelTwoNavigations' => function ($query) use ($userRoleId) {
                $query->where('is_active', '=', 1)
                    ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                        $roleQuery->where('roles.id', '=', $userRoleId);
                    });
            }

        ])
            ->where('id', '=', $userRoleId)
            ->first();

        $roleReportNavigation =
            // Role::with([
            //         'reportMainNavigations.levelOneNavigations',
            //         'reportMainNavigations.levelOneNavigations.roles' => function ($query) use ($userRoleId) {
            //             $query->where('roles.id', '=', $userRoleId);
            //         },
            //     ])

            Role::with([
                'reportMainNavigations.mainNavigations.levelOneNavigations' => function ($query) use ($userRoleId) {
                    $query->where('is_active', '=', 1)
                        ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                            $roleQuery->where('roles.id', '=', $userRoleId);
                        });
                },
                'reportMainNavigations.mainNavigations.levelOneNavigations.levelTwoNavigations' => function ($query) use ($userRoleId) {
                    $query->where('is_active', '=', 1)
                        ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                            $roleQuery->where('roles.id', '=', $userRoleId);
                        });
                }

            ])
                ->where('id', '=', $userRoleId)
                ->first();

        return response()
            ->json([
                'status' => 200,
                'mainNavigation' => $roleForMainNavigation,
                'reportNavigation' => $roleReportNavigation
            ]);
    }

    public function getNavigationByRole(Request $request)
    {
        $userRoleId = $request->key;

        $roleForMainNavigation = Role::with([
            'mainNavigations' => function ($query) use ($userRoleId) {
                $query->with([
                    'levelOneNavigations' => function ($query) use ($userRoleId) {
                        $query->where('is_active', '=', 1)
                            ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                                $roleQuery->where('roles.id', '=', $userRoleId);
                            });
                    },
                    'levelOneNavigations.levelTwoNavigations' => function ($query) use ($userRoleId) {
                        $query->where('is_active', '=', 1)
                            ->whereHas('roles', function ($roleQuery) use ($userRoleId) {
                                $roleQuery->where('roles.id', '=', $userRoleId);
                            });
                    },
                ]);
            },
        ])
            ->where('id', '=', $userRoleId)
            ->first();

        $roleReportNavigation = Role::with([
            'reportMainNavigations' => function ($query) use ($userRoleId) {
                $query->where('report_main_navigation_role.is_active', 1)->orderBy('order');
            },
            'reportMainNavigations.reportLevelOneNavigations' => function ($query) use ($userRoleId) {
                $query->where('is_active', 1)
                    ->whereHas('roles', function ($subQuery) use ($userRoleId) {
                        $subQuery->where('role_id', $userRoleId);
                    })
                    ->orderBy('order');

            }
        ])->where('id', $userRoleId)->first();

        return response()
            ->json([
                'status' => 200,
                  'mainNavigation' => $roleForMainNavigation,
                'reportNavigation' => $roleReportNavigation
            ]);
    }

}