<?php

namespace App\Http\Controllers\Bizx_User_Controllers;

use App\Http\Controllers\Controller;
use App\Models\Stock_Models\StockLocation;
use App\Models\System_Models\SystemPage;
use App\Models\System_Models\SystemPagesUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AuthController extends Controller
{

    public function logIn(Request $request)
    {
        // try {

        $request->validate([
            'username' => 'required',
            'password' => 'required',
            //'device_name' => 'required',
        ]);

        $user = User::select('id', 'username', 'password')
            ->where('username', $request->username)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return response()->json([
                'status' => 401,
                'logged_in_error' => 'Check your username or password'
            ], 401);
        }

        $token = $user->createToken('autocare', ['shop'])->plainTextToken;
        // $userRole = $user->userRoles()->first();

        $userId = $user->id;

        // $users = User::find($userId);


        $user = User::select(
            'id',
            'username'
        )
            ->with([
                'stockLocations'
            ])

            ->with([
                'stockLocations.stockLocationDetail'
            ])
            ->where('id', '=', $userId)
            ->first();


        $userDetails = User::join('stock_location_user_roles', 'users.id', '=', 'stock_location_user_roles.user_id')
            ->join('stock_locations', 'stock_location_user_roles.stock_location_code', '=', 'stock_locations.code')
            ->join('roles', 'stock_location_user_roles.role_id', '=', 'roles.id')
            ->select('users.id as user_name', 'stock_locations.name as location_name', 'roles.name as role_name')
            ->get();

        return response()->json([
            'status' => 200,
            'accessToken' => $token,
            'user' => $user,

        ]);

        // } catch (\Exception $error) {
        //     return response()->json([
        //         'status' => 500,
        //         'message' => "Back-end error",
        //         'errors' => $error
        //     ], 500);
        // }
    }
    public function me(Request $request)
    {
        $header = $request->header('LocationCode');
        return $header;
    }

    public function logout()
    {
        try {

            $user = request()->user();
            $user->tokens()->where('id', $user->currentAccessToken()->id)->delete();

            return response()->json([
                'status' => 200,
                'message' => "Logged out",
            ]);

        } catch (\Exception $error) {
            return response()->json([
                'status' => 500,
                'message' => "Back-end error",
                'errors' => $error
            ], 500);
        }
    }

    public function signInWithUser()
    {
        return response()->json([
            'status' => 500,
            'message' => "Back-end error",
            'errors' =>' $error'
        ], 500);
        try {
            if ($admin = Auth::user()) {

                // $userRole = $admin->userRole()->first();

                return response()->json([
                    'status' => 200,
                    'message' => 'Authorized.',
                    // 'userRole' => $userRole->name,
                    'user' => [
                        'username' => $admin->username,
                    ],
                    'user_details' => $admin
                ]);
            }
        } catch (\Exception $error) {
            return response()->json([
                'status' => 500,
                'message' => "Back-end error",
                'errors' => $error
            ], 500);
        }
    }
}