<?php

namespace App\Http\Controllers\Bank_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\Bank_Models\Bank;
use Illuminate\Support\Facades\Auth;

class BankController extends Controller
{

    public function index()
    {

        try {
            $banks  = Bank::select('code', 'name')->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'Bank' =>  $banks]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $banks  = Bank::select('code', 'name')->where('id', $id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'Banks' =>  $banks]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        
        try {

            $bank_code = TransactionCode::BANK_CODE;
            $cus_code = Bank::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $bank = Bank::create([

                'code' => $bank_code . $max_id,
                'name' => $request->name,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);

            return response()->json(['status' => 200, 'message' => "Bank created"]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            $bank = Bank::findOrFail($id);
            $bank->update([
                'name' => $request->name,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status' => 200, 'message' => "Bank updated"]);
        } catch (\Exception $e) {


            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $bank = Bank::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $bank->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "Bank - Deleted"
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}
