<?php

namespace App\Http\Controllers\Bank_Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Enums\TransactionCode;
use App\Models\Bank_Models\BankBranch;

class BankBranchController extends Controller
{

    public function index()
    {
        try {
            $bankBranch = BankBranch::select('code', 'bank_code', 'name')
                ->where('is_active', '=', 1)->get();
            return response()->json(['status' => 200, 'Bank' => $bankBranch]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $bankBranch = BankBranch::select('code', 'bank_code', 'name')->where('id', $id)->where('is_active', '=', 1)->first();
            return response()->json(['status' => 200, 'Banks' => $bankBranch]);
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {

            $branch_code = TransactionCode::BANK_BRANCH_CODE;
            $cus_code = BankBranch::max('code');
            $max_id = $cus_code == null ? config('global.code_value') + 1 : substr("$cus_code", 3) + 1;

            $bankBranch = BankBranch::create([

                'code' => $branch_code . $max_id,
                'bank_code' => $request->bank_code,
                'name' => $request->name,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);

            return response()->json(['status' => 200, 'message' => "Bank created"]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            $bankBranch = BankBranch::findOrFail($id);
            $bankBranch->update([
                'name' => $request->name,
                'bank_code' => $request->bank_code,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()
            ]);
            return response()->json(['status' => 200, 'message' => "bank Branch updated"]);

        } catch (\Exception $e) {


            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $bankBranch = BankBranch::select('id', 'is_active')->where('code', $id)->where('is_active', '=', 1)->first();
            $bankBranch->update([
                'is_active' => 0
            ]);
            return response()->json([
                'status' => 204,
                'message' => "bank Branch - Deleted"
            ]);


        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }
}