<?php

namespace App\Http\Controllers\Account_Transaction_Controller;

use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccLedgerType;
use App\Models\AccountTransaction_Models\LedgerType;
use Exception;
use Illuminate\Http\Request;

class LedgerTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


    public function ledgerTypeSearch($key)
    {
        try {

            $ledgerTypes = AccLedgerType::select(
                'code',
                'name'
            )->where(function ($query) use ($key) {
                $query->Where('code', 'like', "%$key%")
                    ->orWhere('name', 'like', "%$key%");
            })
                ->where([['is_active', '=', 1]])
                ->get();

            return response()->json([
                'status' => 200,
                'ledgerTypes' => $ledgerTypes
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}