<?php

namespace App\Http\Controllers\Account_Transaction_Controller;

use App\Enums\EntryType;
use App\Enums\GeneralLedgerSourceValues;
use App\Enums\LedgerType;
use App\Enums\MultiPurposeStatus;
use App\Enums\TransactionCode;
use App\Enums\TransactionMode;
use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccClosingBalance;

use App\Models\AccountTransaction_Models\AccGeneralLedger;
use App\Models\AccountTransaction_Models\AccLedgerType;
use App\Models\AccountTransaction_Models\AccTransaction;
use App\Models\Expense_Models\Expense;
use Carbon\Carbon;
use DateTime;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Mockery\Undefined;
use Illuminate\Support\Collection;

class ClosingBalanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    
       /**
     * dayEndByUser
     * 
     * author: suhail jamaldeen
     * <version:01>
     * logic: based on the ledger date and ledger type report from closing balance 
     * @param  mixed $request
     * @return void
     */
    public function getClosingBalanceByDateAndType(Request $request)
    {
        try {
            $date = $request->date;
            $ledgerTypeCode = $request->ledgerTypeCode;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $stockLocationCode = getCurrentLocationCode($request);
    
            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date',
            );
    
            if ($ledgerTypeCode) {
                $closingBalance->with([
                    'generalLedgers.accTransaction',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeFrom',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeTo',
                ]);
            } 
            
            else {
                $closingBalance->get();
            }
    
            $closingBalance->where([
                ['is_active', '=', 1],
                ['status', '<>', 5],
                ['stock_location_code', '=', $stockLocationCode]
            ]);
    
            if($fromDate && $toDate)
            {
                $closingBalance->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))]);
            }
    
            if ($ledgerTypeCode) {
                $closingBalance->where('acc_ledger_type_code', '=', $ledgerTypeCode);
            }
    
            $closingBalance = $closingBalance->get();
    
            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance,
                'date' => $fromDate,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }

    }
    public function dayEndClosingBalanace(Request $request)
    {
        try {
            $date = $request->date;
            $ledgerTypeCode = $request->ledgerTypeCode;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $stockLocationCode = getCurrentLocationCode($request);
    
            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date',
            );
    
            if ($ledgerTypeCode) {
                $closingBalance->with([
                    'generalLedgers.accTransaction',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeFrom',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeTo',
                ]);
            } 
            
            else {
                $closingBalance->get();
            }
    
            $closingBalance->where([
                ['is_active', '=', 1],
                ['status', '<>', 5],
                ['stock_location_code', '=', $stockLocationCode]
            ]);
    
            if($fromDate && $toDate)
            {
                $closingBalance->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))]);
            }
    
            if ($ledgerTypeCode) {
                $closingBalance->where('acc_ledger_type_code', '=', $ledgerTypeCode);
            }
    
            $closingBalance = $closingBalance->get();
    
            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance,
                'date' => $fromDate,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function LedegerAudit(Request $request)
    {
        try {
            $date = $request->date;
            $ledgerTypeCode = $request->ledgerTypeCode;
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;
            $stockLocationCode = getCurrentLocationCode($request);
    
            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date',
            );
    
            if ($ledgerTypeCode) {
                $closingBalance->with([
                    'generalLedgers.accTransaction',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeFrom',
                    'generalLedgers.accTransaction.journalType.accLedgerTypeTo',
                ]);
            } 
            
            else {
                $closingBalance->get();
            }
    
            $closingBalance->where([
                ['is_active', '=', 1],
                ['status', '<>', 5],
                ['stock_location_code', '=', $stockLocationCode]
            ]);
    
            if($fromDate && $toDate)
            {
                $closingBalance->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))]);
            }
    
            if ($ledgerTypeCode) {
                $closingBalance->where('acc_ledger_type_code', '=', $ledgerTypeCode);
            }
    
            $closingBalance = $closingBalance->get();
    
            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance,
                'date' => $fromDate,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }


    public function ledgerDetailsSummary(Request $request)
    {
        try {
            $date = $request->date;
            $ledgerTypeCode = $request->ledgerTypeCode;
            $stockLocationCode = getCurrentLocationCode($request);
            $fromDate = $request->fromDate;
            $toDate = $request->toDate;

            $date1 = new DateTime($request->fromDate);
            $newDate = $date1->modify('-1 day');

            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date',
            )
                ->with([
                    'generalLedgers' => function ($query) use ($ledgerTypeCode) {
                        $query->select(
                            'code',
                        )->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType.accLedgerTypeFrom' => function ($query) use ($ledgerTypeCode) {
                        $query->where('code', '=', $ledgerTypeCode)
                            ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType.accLedgerTypeTo' => function ($query) use ($ledgerTypeCode) {
                        $query->where('code', '=', $ledgerTypeCode)
                            ->where('is_active', '=', 1);
                    }
                ])
                ->where([
                    ['is_active', '=', 1],
                    ['status', '<>', 5],
                    ['stock_location_code', '=', $stockLocationCode]
                ]);
                
                if($fromDate && $toDate)
                {
                    $closingBalance->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromDate)-1), date('Y-m-d H:m:s', strtotime($toDate))]);
                }

                if($ledgerTypeCode)
                {
                    $closingBalance->where('acc_ledger_type_code', '=', $ledgerTypeCode);
                }

                $closingBalance = $closingBalance->get();

                
            $previousDateBroughtForward = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date'
            )
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $newDate->format('Y-m-d'))
                ->where('status', '<>', 5)
                ->where('stock_location_code', '=', getCurrentLocationCode($request));
                
                if($ledgerTypeCode)
                {
                    $previousDateBroughtForward->where('acc_ledger_type_code', '=', $ledgerTypeCode);
                }

                $previousDateBroughtForward = $previousDateBroughtForward->get();

            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance,
                'previousDateBroughtForward' => $previousDateBroughtForward,
                'previousDate' => $newDate,

            ]);

        } catch (\Exception $e) {
            return response()
                ->json([
                    'status' => 500,
                    'message' => $e
                ], 500);
        }

    }

    /**
     * dayEndByUser
     * date:2023.11.06
     * author: fathima sajana
     * <version:01>
     * logic: based on the ledger date, user based and ledge report from closing balance 
     * @param  mixed $request
     * @return void
     */
    public function dayEndByUser1(Request $request)
    {
        try {
            $date = $request->date;
            $ledgerTypeCode = $request->ledgerTypeCode;
            $createdBy = $request->id;
            $stockLocationCode = getCurrentLocationCode($request);
            
            $dayEndByUser = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date',
                'created_by'
            )
                ->with([
                    'generalLedgers' => function ($query) use ($ledgerTypeCode) {
                        $query->select(
                            'code',
                        )
                        ->where('status', '<>', 5)
                        ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType.accLedgerTypeFrom' => function ($query) use ($ledgerTypeCode) {
                        $query->where('code', '=', $ledgerTypeCode)
                            ->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType.accLedgerTypeTo' => function ($query) use ($ledgerTypeCode) {
                        $query->where('code', '=', $ledgerTypeCode)
                            ->where('is_active', '=', 1);
                    }
                ])
                ->where([
                    ['is_active', '=', 1],
                    ['ledger_date', '=', $date],
                    ['acc_ledger_type_code', '=', $ledgerTypeCode],
                    ['status', '<>', 5],
                    ['created_by', '=', $createdBy],
                    ['stock_location_code', '=', $stockLocationCode]
                ])
                ->get();

            return response()->json([
                'status' => 200,
                'dayEndByUser' => $dayEndByUser,
                'date' => $date,

            ]);

        } catch (\Exception $e) {
            return response()
                ->json([
                    'status' => 500,
                    'message' => $e
                ], 500);
        }

    }
    
    public function dayEndByUser(Request $request)
    {
    try {
        $date = $request->date;
        $ledgerTypeCode = $request->ledgerTypeCode;
        $createdBy = $request->id;
        $stockLocationCode = getCurrentLocationCode($request);

        $query = AccClosingBalance::select(
            'code',
            'stock_location_code',
            'acc_ledger_type_code',
            'cash_amount',
            'cheque_amount',
            'ledger_date',
            'created_by'
        )
        ->with([
            'generalLedgers' => function ($query) use ($ledgerTypeCode) {
                $query->select('code')->where('is_active', '=', 1);
            }
        ])
        ->with([
            'generalLedgers.accTransaction' => function ($query) {
                $query->where('is_active', '=', 1);
            }
        ])
        ->with([
            'generalLedgers.accTransaction.journalType' => function ($query) {
                $query->where('is_active', '=', 1);
            }
        ])
        ->with([
            'generalLedgers.accTransaction.journalType.accLedgerTypeFrom' => function ($query) use ($ledgerTypeCode) {
                $query->where('code', '=', $ledgerTypeCode)->where('is_active', '=', 1);
            }
        ])
        ->with([
            'generalLedgers.accTransaction.journalType.accLedgerTypeTo' => function ($query) use ($ledgerTypeCode) {
                $query->where('code', '=', $ledgerTypeCode)->where('is_active', '=', 1);
            }
        ])
        ->where('is_active', '=', 1)
        ->where('stock_location_code', '=', $stockLocationCode)
        ->where('status', '<>', 5);

        if ($date) {
            $query->where('ledger_date', '=', $date);
        }

        if ($ledgerTypeCode) {
            $query->where('acc_ledger_type_code', '=', $ledgerTypeCode);
        }

        if ($createdBy) {
            $query->where('created_by', '=', $createdBy);
        }

        $dayEndByUser = $query->get();

        return response()->json([
            'status' => 200,
            'dayEndByUser' => $dayEndByUser,
            'date' => $date,
        ]);

    } catch (\Exception $e) {
        return response()
            ->json([
                'status' => 500,
                'message' => $e
            ], 500);
    }
}


    public function previewClosingBalance(Request $request)
    {


        // $accLedger = new AccGeneralLedger();
        // $accLedger->code = "asas";
        // $accLedgerCollection = new Collection();
        // $accLedgerCollection->push($accLedger);

        // return $accLedgerCollection;


        // try {

        $accLedgerCollection = new Collection();
        $date = $request->date;
        $fromdate = $request->fromDate;
        $toDate = $request->toDate;

        $task = $request->task;

        $stockLocationCode = getCurrentLocationCode($request);
        $createdBy = getUserCode();
        $closingBalanceCode = TransactionCode::CLOSING_BALANCE_CODE;
        $generalLedgerCode = TransactionCode::GENERAL_LEDGER_CODE;

        $locationPrefix = substr($stockLocationCode, -2);
        $cashInHand = 0;
        $chequeInHand = 0;

        $generalLedger = AccClosingBalance::select(
            'code',
            'stock_location_code',
            'acc_ledger_type_code',
            'cash_amount',
            'cheque_amount',
            'ledger_date'
        )
            ->where('is_active', '=', 1)
            ->where('ledger_date', '=', $date)
            ->where('status', '<>', 5)
            ->where('stock_location_code', '=', $stockLocationCode)
            //->where('created_by', '=', $createdBy)
            ->get();

        if (count($generalLedger)) {


            return response()->json([
                'status' => 200,
                'note' => 'Closing Balance already available for the date ' . $date . '',
                'generalLedger' => $generalLedger
            ]);
        } else {

            DB::beginTransaction();
            $closingBalanceCode = TransactionCode::CLOSING_BALANCE_CODE;
            $locationPrefix = substr($stockLocationCode, -2);

            // $generalLedgerBroughtForward = AccClosingBalance::where('ledger_date', $date)
            //     ->orderBy('ledger_date', 'DESC')
            //     ->first();
            $generalLedgerBroughtForwardCash = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date'
            )
                ->where('is_active', '=', 1)
                //->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromdate) - 2), date('Y-m-d H:m:s', strtotime($toDate))])
                ->where('stock_location_code', '=', $stockLocationCode)
                //->where('created_by', '=', $createdBy)
                ->where('status', '<>', 5)
                ->where('acc_ledger_type_code', '=',  LedgerType::CASH)
                ->orderBy('ledger_date', 'DESC')
                ->first();

            // brought forward cash value

            $accLedgerBroughtFrwdCashByCashBook = new AccGeneralLedger();
            $accLedgerBroughtFrwdCashByCashBook->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_CASH_BOOK;
             $accLedgerBroughtFrwdCashByCashBook->amount = !is_null( $generalLedgerBroughtForwardCash) ? $generalLedgerBroughtForwardCash->cash_amount : 0;

            $accLedgerBroughtFrwdCashByCashBook->ledger_type = LedgerType::CASH;
            $accLedgerBroughtFrwdCashByCashBook->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdCashByCashBook->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBroughtFrwdCashByCashBook);


            $accLedgerBroughtFrwdChequeByCashBook = new AccGeneralLedger();
            $accLedgerBroughtFrwdChequeByCashBook->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_CASH_BOOK;
            $accLedgerBroughtFrwdChequeByCashBook->amount = !is_null($generalLedgerBroughtForwardCash) ? $generalLedgerBroughtForwardCash->cheque_amount : 0;

            $accLedgerBroughtFrwdChequeByCashBook->ledger_type = LedgerType::CASH;
            $accLedgerBroughtFrwdChequeByCashBook->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdChequeByCashBook->transaction_type = TransactionMode::CHEQUE;

            $accLedgerCollection->push($accLedgerBroughtFrwdChequeByCashBook);


            //  accLedgerBroughtFrwdByBank

            $generalLedgerBroughtForward = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date'
            )
                ->where('is_active', '=', 1)
                //->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromdate) - 2), date('Y-m-d H:m:s', strtotime($toDate))])
                ->where('stock_location_code', '=', $stockLocationCode)
                //->where('created_by', '=', $createdBy)
                ->where('status', '<>', 5)
                ->where('acc_ledger_type_code', '=', LedgerType::BANK)
                ->orderBy('ledger_date', 'DESC')
                ->first();


            $accLedgerBroughtFrwdCashByBank = new AccGeneralLedger();
            $accLedgerBroughtFrwdCashByBank->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_BANK;
            $accLedgerBroughtFrwdCashByBank->amount = !is_null($generalLedgerBroughtForward) ? $generalLedgerBroughtForward->cash_amount : 0;
            $accLedgerBroughtFrwdCashByBank->ledger_type = LedgerType::BANK;
            $accLedgerBroughtFrwdCashByBank->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdCashByBank->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBroughtFrwdCashByBank);

            $accLedgerBroughtFrwdChequeByBank = new AccGeneralLedger();
            $accLedgerBroughtFrwdChequeByBank->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_BANK;
            $accLedgerBroughtFrwdChequeByBank->amount = !is_null($generalLedgerBroughtForward) ? $generalLedgerBroughtForward->cheque_amount : 0;
            $accLedgerBroughtFrwdChequeByBank->ledger_type = LedgerType::BANK;
            $accLedgerBroughtFrwdChequeByBank->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdChequeByBank->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBroughtFrwdChequeByBank);

            //accLedgerBroughtFrwdByCreditCard
            $generalLedgerBroughtForward = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount',
                'ledger_date'
            )
                ->where('is_active', '=', 1)
                //->whereBetween('ledger_date', [date('Y-m-d H:m:s', strtotime($fromdate) - 2), date('Y-m-d H:m:s', strtotime($toDate))])
                ->where('stock_location_code', '=', $stockLocationCode)
                //->where('created_by', '=', $createdBy)
                ->where('status', '<>', 5)
                ->where('acc_ledger_type_code', '=', LedgerType::CREDIT_CARD)
                ->orderBy('ledger_date', 'DESC')
                ->first();

            $accLedgerBroughtFrwdCashByCreditCard = new AccGeneralLedger();
            $accLedgerBroughtFrwdCashByCreditCard->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_CREDIT_CARD;
            $accLedgerBroughtFrwdCashByCreditCard->amount = !is_null($generalLedgerBroughtForward) ? $generalLedgerBroughtForward->cash_amount : 0;
            $accLedgerBroughtFrwdCashByCreditCard->ledger_type = LedgerType::CREDIT_CARD;
            $accLedgerBroughtFrwdCashByCreditCard->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdCashByCreditCard->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBroughtFrwdCashByCreditCard);

            $accLedgerBroughtFrwdChequeByCreditCard = new AccGeneralLedger();
            $accLedgerBroughtFrwdChequeByCreditCard->source_code = GeneralLedgerSourceValues::BROUGHT_FORWARD_CREDIT_CARD;
            $accLedgerBroughtFrwdChequeByCreditCard->amount = !is_null($generalLedgerBroughtForward) ? $generalLedgerBroughtForward->cheque_amount : 0;
            $accLedgerBroughtFrwdChequeByCreditCard->ledger_type = LedgerType::CREDIT_CARD;
            $accLedgerBroughtFrwdChequeByCreditCard->entry_type = EntryType::DEBIT;
            $accLedgerBroughtFrwdChequeByCreditCard->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBroughtFrwdChequeByCreditCard);

            // Cash Payment
            $cash_payment = 'SELECT IFNULL(sum(cash_payments.amount),0) AS cash_total, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN cash_payments on cash_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cash_payments.status <> 5 AND ( STR_TO_DATE(cash_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $cash_payment = DB::select($cash_payment);

            $accLedgerCashPayment = new AccGeneralLedger();
            $accLedgerCashPayment->source_code = GeneralLedgerSourceValues::CASH_PAYMENT;
            $accLedgerCashPayment->amount = $cash_payment[0]->cash_total;
            $accLedgerCashPayment->ledger_type = LedgerType::CASH;
            $accLedgerCashPayment->entry_type = EntryType::DEBIT;
            $accLedgerCashPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerCashPayment);


            $cheque_payment = 'SELECT IFNULL(sum(cheque_payments.amount),0)AS cheque_total, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN cheque_payments on cheque_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cheque_payments.status <> 5 AND ( STR_TO_DATE(cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $cheque_payment = DB::select($cheque_payment);

            $accLedgerCashPayment = new AccGeneralLedger();
            $accLedgerCashPayment->source_code = GeneralLedgerSourceValues::CHEQUE_PAYMENT;
            $accLedgerCashPayment->amount = $cheque_payment[0]->cheque_total;
            $accLedgerCashPayment->ledger_type = LedgerType::CASH;
            $accLedgerCashPayment->entry_type = EntryType::DEBIT;
            $accLedgerCashPayment->transaction_type = TransactionMode::CHEQUE;

            $accLedgerCollection->push($accLedgerCashPayment);


            $card_payment = 'SELECT IFNULL(sum(card_payments.amount),0)AS card_total, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN card_payments on card_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND card_payments.status <> 5  AND ( STR_TO_DATE(card_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $card_payment = DB::select($card_payment);

            $accLedgerCardPayment = new AccGeneralLedger();
            $accLedgerCardPayment->source_code = GeneralLedgerSourceValues::CARD_PAYMENT;
            $accLedgerCardPayment->amount = $card_payment[0]->card_total;
            $accLedgerCardPayment->ledger_type = LedgerType::CREDIT_CARD;
            $accLedgerCardPayment->entry_type = EntryType::DEBIT;
            $accLedgerCardPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerCardPayment);


            $bank_payment = 'SELECT IFNULL(sum(bank_payments.amount),0)AS bank_amount, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN bank_payments on bank_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND bank_payments.status <> 5  AND ( STR_TO_DATE(bank_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $bank_payment = DB::select($bank_payment);

            $accLedgerBankPayment = new AccGeneralLedger();
            $accLedgerBankPayment->source_code = GeneralLedgerSourceValues::BANK_PAYMENT;
            $accLedgerBankPayment->amount = $bank_payment[0]->bank_amount;
            $accLedgerBankPayment->ledger_type = LedgerType::BANK;
            $accLedgerBankPayment->entry_type = EntryType::DEBIT;
            $accLedgerBankPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBankPayment);


            $online_transfer_payment = 'SELECT IFNULL(sum(online_transfer_payments.amount),0)AS online_transfer_amount, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN online_transfer_payments on online_transfer_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND online_transfer_payments.status <> 5  AND ( STR_TO_DATE(online_transfer_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $online_transfer_payment = DB::select($online_transfer_payment);

            $accLedgerOnlineTransferPayment = new AccGeneralLedger();
            $accLedgerOnlineTransferPayment->source_code = GeneralLedgerSourceValues::ONLINE_TRANSFER_PAYMENT;
            $accLedgerOnlineTransferPayment->amount = $online_transfer_payment[0]->online_transfer_amount;
            $accLedgerOnlineTransferPayment->ledger_type = LedgerType::BANK;
            $accLedgerOnlineTransferPayment->entry_type = EntryType::DEBIT;
            $accLedgerOnlineTransferPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerOnlineTransferPayment);


            // $expense_amount = Expense::select(
            //     'expenses.code',
            //     'total_amount',
            //     'expense_types.name AS expense_type',
            //     'expense_categories.name AS expense_category'
            // )
            //     ->join('expense_types', 'expense_types.code', '=', 'expenses.expense_type_code')
            //     ->join('expense_categories', 'expense_categories.code', '=', 'expenses.expense_category_code')
            //     ->join('stock_locations', 'stock_locations.code', '=', 'expenses.stock_location_code')
            //     ->where('expenses.is_active', '=', 1)
            //     ->where('expenses.stock_location_code', '=', $stockLocationCode)
            //     ->whereBetween('payment_date', [date('Y-m-d H:m:s', strtotime($fromdate) - 1), date('Y-m-d H:m:s', strtotime($toDate))])
            //     ->get();

            // if (count($expense_amount) > 0) {
            //     foreach ($expense_amount as $expenseAmount) {

            //         $accLedgerExpenseAmount = new AccGeneralLedger();
            //         $accLedgerExpenseAmount->source_code = GeneralLedgerSourceValues::EXPENSE_AMOUNT;
            //         $accLedgerExpenseAmount->amount = $expenseAmount->total_amount;
            //         $accLedgerExpenseAmount->ledger_type = LedgerType::CASH;
            //         $accLedgerExpenseAmount->entry_type = EntryType::CREDIT;
            //         $accLedgerExpenseAmount->transaction_type = TransactionMode::CASH;

            //         $accLedgerCollection->push($accLedgerExpenseAmount);

            //     }
            // }

            // $payment_vouchers = 'SELECT IFNULL(sum(settled_amount),0)AS payment_voucher_settled FROM payment_vouchers WHERE (payment_vouchers.status <> 5 AND stock_location_code = ' . $stockLocationCode . ' AND( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            // $payment_voucher_total = DB::select($payment_vouchers);

            // $accLedgerVoucherTotal = new AccGeneralLedger();

            // $accLedgerVoucherTotal->source_code = GeneralLedgerSourceValues::PAYMENT_VOUCHER;
            // $accLedgerVoucherTotal->amount = $payment_voucher_total[0]->payment_voucher_settled;
            // $accLedgerVoucherTotal->ledger_type = LedgerType::CREDIT_CARD;
            // $accLedgerVoucherTotal->entry_type = EntryType::DEBIT;
            // $accLedgerVoucherTotal->transaction_type = TransactionMode::CASH;

            // $accLedgerCollection->push($accLedgerVoucherTotal);

            $supplier_cash_payment = 'SELECT IFNULL(sum(supplier_cash_payments.amount),0)AS supplier_cash_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_cash_payments on supplier_cash_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_cash_payments.status <> 5  AND ( STR_TO_DATE(supplier_cash_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_cash_payment = DB::select($supplier_cash_payment);
            if (count($supplier_cash_payment) > 0) {
                $accLedgerSupplierCashPayment = new AccGeneralLedger();
                $accLedgerSupplierCashPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CASH_PAYMENT;
                $accLedgerSupplierCashPayment->amount = $supplier_cash_payment[0]->supplier_cash_total;
                $accLedgerSupplierCashPayment->ledger_type = LedgerType::CASH;
                $accLedgerSupplierCashPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierCashPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierCashPayment);
            }


            $supplier_cheque_payment = 'SELECT IFNULL(sum(supplier_cheque_payments.amount),0)AS supplier_cheque_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_cheque_payments on supplier_cheque_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_cheque_payments.status <> 5  AND ( STR_TO_DATE(supplier_cheque_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_cheque_payment = DB::select($supplier_cheque_payment);

            if (count($supplier_cheque_payment) > 0) {
                $accLedgerSupplierChequePayment = new AccGeneralLedger();
                $accLedgerSupplierChequePayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CHEQUE_PAYMENT;
                $accLedgerSupplierChequePayment->amount = $supplier_cheque_payment[0]->supplier_cheque_total;
                $accLedgerSupplierChequePayment->ledger_type = LedgerType::BANK;
                $accLedgerSupplierChequePayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierChequePayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierChequePayment);
            }


            $supplier_card_payment = 'SELECT IFNULL(sum(supplier_card_payments.amount),0)AS supplier_card_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_card_payments on supplier_card_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_card_payments.status <> 5  AND ( STR_TO_DATE(supplier_card_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_card_payment = DB::select($supplier_card_payment);
            if (count($supplier_card_payment) > 0) {

                $accLedgerSupplierCardPayment = new AccGeneralLedger();
                $accLedgerSupplierCardPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CARD_PAYMENT;
                $accLedgerSupplierCardPayment->amount = $supplier_card_payment[0]->supplier_card_total;
                $accLedgerSupplierCardPayment->ledger_type = LedgerType::CREDIT_CARD;
                $accLedgerSupplierCardPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierCardPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierCardPayment);
            }

            $supplier_bank_payment = 'SELECT IFNULL(sum(supplier_bank_payments.amount),0)AS supplier_bank_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_bank_payments on supplier_bank_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_bank_payments.status <> 5  AND ( STR_TO_DATE(supplier_bank_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';
            //$supplier_bank_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_bank_total FROM supplier_bank_payments WHERE (supplier_bank_payments.status <> 5 AND ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $supplier_bank_payment = DB::select($supplier_bank_payment);
            if (count($supplier_bank_payment) > 0) {

                $accLedgerSupplierBankPayment = new AccGeneralLedger();
                $accLedgerSupplierBankPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_BANK_PAYMENT;
                $accLedgerSupplierBankPayment->amount = $supplier_bank_payment[0]->supplier_bank_total;
                $accLedgerSupplierBankPayment->ledger_type = LedgerType::CASH;
                $accLedgerSupplierBankPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierBankPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierBankPayment);

            }
            $supplier_online_transfer = 'SELECT IFNULL(sum(supplier_online_transfers.amount),0)AS supplier_online_transfer_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_online_transfers on supplier_online_transfers.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . ' AND supplier_online_transfers.status <> 5  AND ( STR_TO_DATE(supplier_online_transfers.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$supplier_online_transfer = 'SELECT IFNULL(sum(amount),0)AS supplier_online_transfer_total FROM supplier_online_transfers WHERE (supplier_online_transfers.status <> 5 AND ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $supplier_online_transfer = DB::select($supplier_online_transfer);
            if (count($supplier_online_transfer) > 0) {

                $accLedgerSupplierOnlineTransferPayment = new AccGeneralLedger();
                $accLedgerSupplierOnlineTransferPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_ONLINE_TRANSFER_PAYMENT;
                $accLedgerSupplierOnlineTransferPayment->amount = $supplier_online_transfer[0]->supplier_online_transfer_total;
                $accLedgerSupplierOnlineTransferPayment->ledger_type = LedgerType::BANK;
                $accLedgerSupplierOnlineTransferPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierOnlineTransferPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierOnlineTransferPayment);

            }

            $customer_cheque_return_cash_payments = 'SELECT IFNULL(sum(cus_cheq_rtrn_cash_payments.amount),0)AS customer_cheque_return_cash_total, stock_location_code, stock_locations.name FROM cus_cheq_return_receipts 
            JOIN cus_cheq_rtrn_cash_payments on cus_cheq_rtrn_cash_payments.cheque_receipt_code = cus_cheq_return_receipts.code
            JOIN stock_locations on stock_locations.code = cus_cheq_return_receipts.stock_location_code
            WHERE (cus_cheq_return_receipts.stock_location_code =' . $stockLocationCode . ' AND cus_cheq_rtrn_cash_payments.status <> 5  AND ( STR_TO_DATE(cus_cheq_rtrn_cash_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$customer_cheque_return_cash_payments = 'SELECT IFNULL(sum(amount),0)AS customer_cheque_return_cash_total FROM cus_cheq_rtrn_cash_payments WHERE ( ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $customer_cheque_return_cash_payments = DB::select($customer_cheque_return_cash_payments);
            if (count($customer_cheque_return_cash_payments) > 0) {

                $customerChequeReturnCashPayment = new AccGeneralLedger();
                $customerChequeReturnCashPayment->source_code = GeneralLedgerSourceValues::CUSTOMER_CHEQUE_RETURN_CASH_PAYMENT;
                $customerChequeReturnCashPayment->amount = $customer_cheque_return_cash_payments[0]->customer_cheque_return_cash_total;
                $customerChequeReturnCashPayment->ledger_type = LedgerType::CASH;
                $customerChequeReturnCashPayment->entry_type = EntryType::DEBIT;
                $customerChequeReturnCashPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($customerChequeReturnCashPayment);

            }

            $customer_cheque_return_cheque_payments = 'SELECT IFNULL(sum(cus_cheq_rtrn_cheque_payments.amount),0)AS customer_cheque_return_cheque_total, stock_location_code, stock_locations.name FROM cus_cheq_return_receipts 
            JOIN cus_cheq_rtrn_cheque_payments on cus_cheq_rtrn_cheque_payments.cheque_receipt_code = cus_cheq_return_receipts.code
            JOIN stock_locations on stock_locations.code = cus_cheq_return_receipts.stock_location_code
            WHERE (cus_cheq_return_receipts.stock_location_code =' . $stockLocationCode . ' AND cus_cheq_rtrn_cheque_payments.status <> 5  AND ( STR_TO_DATE(cus_cheq_rtrn_cheque_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$customer_cheque_return_cheque_payments = 'SELECT IFNULL(sum(amount),0)AS customer_cheque_return_cheque_total FROM cus_cheq_rtrn_cheque_payments WHERE ( ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $customer_cheque_return_cheque_payments = DB::select($customer_cheque_return_cheque_payments);
            if (count($customer_cheque_return_cheque_payments) > 0) {

                $customerChequeReturnChequePayment = new AccGeneralLedger();
                $customerChequeReturnChequePayment->source_code = GeneralLedgerSourceValues::CUSTOMER_CHEQUE_RETURN_CHEQUE_PAYMENT;
                $customerChequeReturnChequePayment->amount = $customer_cheque_return_cheque_payments[0]->customer_cheque_return_cheque_total;
                $customerChequeReturnChequePayment->ledger_type = LedgerType::CASH;
                $customerChequeReturnChequePayment->entry_type = EntryType::DEBIT;
                $customerChequeReturnChequePayment->transaction_type = TransactionMode::CHEQUE;

                $accLedgerCollection->push($customerChequeReturnChequePayment);

            }

            $customer_cheque_return_bank_payments = 'SELECT IFNULL(sum(cus_cheq_rtrn_bank_payments.amount),0)AS customer_cheque_return_bank_total, stock_location_code, stock_locations.name FROM cus_cheq_return_receipts 
            JOIN cus_cheq_rtrn_bank_payments on cus_cheq_rtrn_bank_payments.cheque_receipt_code = cus_cheq_return_receipts.code
            JOIN stock_locations on stock_locations.code = cus_cheq_return_receipts.stock_location_code
            WHERE (cus_cheq_return_receipts.stock_location_code =' . $stockLocationCode . ' AND cus_cheq_rtrn_bank_payments.status <> 5  AND ( STR_TO_DATE(cus_cheq_rtrn_bank_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$customer_cheque_return_bank_payments = 'SELECT IFNULL(sum(amount),0)AS customer_cheque_return_bank_total FROM cus_cheq_rtrn_bank_payments WHERE ( ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $customer_cheque_return_bank_payments = DB::select($customer_cheque_return_bank_payments);
            if (count($customer_cheque_return_bank_payments) > 0) {

                $customerChequeReturnBankPayment = new AccGeneralLedger();
                $customerChequeReturnBankPayment->source_code = GeneralLedgerSourceValues::CUSTOMER_CHEQUE_RETURN_BANK_PAYMENT;
                $customerChequeReturnBankPayment->amount = $customer_cheque_return_bank_payments[0]->customer_cheque_return_bank_total;
                $customerChequeReturnBankPayment->ledger_type = LedgerType::BANK;
                $customerChequeReturnBankPayment->entry_type = EntryType::DEBIT;
                $customerChequeReturnBankPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($customerChequeReturnBankPayment);

            }

            $customer_cheque_return_online_transfer_payments = 'SELECT IFNULL(sum(cus_cheq_rtrn_online_payments.amount),0)AS customer_cheque_return_online_total, stock_location_code, stock_locations.name FROM cus_cheq_return_receipts 
            JOIN cus_cheq_rtrn_online_payments on cus_cheq_rtrn_online_payments.cheque_receipt_code = cus_cheq_return_receipts.code
            JOIN stock_locations on stock_locations.code = cus_cheq_return_receipts.stock_location_code
            WHERE (cus_cheq_return_receipts.stock_location_code =' . $stockLocationCode . ' AND cus_cheq_rtrn_online_payments.status <> 5  AND ( STR_TO_DATE(cus_cheq_rtrn_online_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$customer_cheque_return_online_transfer_payments = 'SELECT IFNULL(sum(amount),0)AS customer_cheque_return_online_total FROM cus_cheq_rtrn_online_payments WHERE ( ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $customer_cheque_return_online_transfer_payments = DB::select($customer_cheque_return_online_transfer_payments);
            if (count($customer_cheque_return_online_transfer_payments) > 0) {

                $customerChequeReturnOnlinePayment = new AccGeneralLedger();
                $customerChequeReturnOnlinePayment->source_code = GeneralLedgerSourceValues::CUSTOMER_CHEQUE_RETURN_ONLINE_PAYMENT;
                $customerChequeReturnOnlinePayment->amount = $customer_cheque_return_online_transfer_payments[0]->customer_cheque_return_online_total;
                $customerChequeReturnOnlinePayment->ledger_type = LedgerType::BANK;
                $customerChequeReturnOnlinePayment->entry_type = EntryType::DEBIT;
                $customerChequeReturnOnlinePayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($customerChequeReturnOnlinePayment);

            }

            $customer_cheque_return_card__payments = 'SELECT IFNULL(sum(cus_cheq_rtrn_card_payments.amount),0)AS customer_cheque_return_card_total, stock_location_code, stock_locations.name FROM cus_cheq_return_receipts 
            JOIN cus_cheq_rtrn_card_payments on cus_cheq_rtrn_card_payments.cheque_receipt_code = cus_cheq_return_receipts.code
            JOIN stock_locations on stock_locations.code = cus_cheq_return_receipts.stock_location_code
            WHERE (cus_cheq_return_receipts.stock_location_code =' . $stockLocationCode . ' AND cus_cheq_rtrn_card_payments.status <> 5  AND ( STR_TO_DATE(cus_cheq_rtrn_card_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$customer_cheque_return_card__payments = 'SELECT IFNULL(sum(amount),0)AS customer_cheque_return_card_total FROM cus_cheq_rtrn_card_payments WHERE ( ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $customer_cheque_return_card__payments = DB::select($customer_cheque_return_card__payments);
            if (count($customer_cheque_return_card__payments) > 0) {

                $customerChequeReturnCardPayment = new AccGeneralLedger();
                $customerChequeReturnCardPayment->source_code = GeneralLedgerSourceValues::CUSTOMER_CHEQUE_RETURN_CARD_PAYMENT;
                $customerChequeReturnCardPayment->amount = $customer_cheque_return_card__payments[0]->customer_cheque_return_card_total;
                $customerChequeReturnCardPayment->ledger_type = LedgerType::CREDIT_CARD;
                $customerChequeReturnCardPayment->entry_type = EntryType::DEBIT;
                $customerChequeReturnCardPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($customerChequeReturnCardPayment);

            }

            $expense_cash_payments = 'SELECT IFNULL(sum(expense_cash_payments.amount),0)AS expense_cash_total, stock_location_code, stock_locations.name FROM expenses 
            JOIN expense_cash_payments on expense_cash_payments.expense_code = expenses.code
            JOIN stock_locations on stock_locations.code = expenses.stock_location_code
            WHERE (expenses.stock_location_code =' . $stockLocationCode . ' AND expense_cash_payments.status <> 5  AND ( STR_TO_DATE(expense_cash_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$expense_cash_payments = 'SELECT IFNULL(sum(amount),0)AS expense_cash_total FROM expense_cash_payments WHERE ( ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $expense_cash_payments = DB::select($expense_cash_payments);
            if (count($expense_cash_payments) > 0) {

                $expenseCashPayments = new AccGeneralLedger();
                $expenseCashPayments->source_code = GeneralLedgerSourceValues::EXPENSE_CASH_PAYMENT;
                $expenseCashPayments->amount = $expense_cash_payments[0]->expense_cash_total;
                $expenseCashPayments->ledger_type = LedgerType::CASH;
                $expenseCashPayments->entry_type = EntryType::CREDIT;
                $expenseCashPayments->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($expenseCashPayments);

            }

            $expense_cheque_payments = 'SELECT IFNULL(sum(expense_cheque_payments.amount),0)AS expense_cheque_total, stock_location_code, stock_locations.name FROM expenses 
            JOIN expense_cheque_payments on expense_cheque_payments.expense_code = expenses.code
            JOIN stock_locations on stock_locations.code = expenses.stock_location_code
            WHERE (expenses.stock_location_code =' . $stockLocationCode . ' AND expense_cheque_payments.status <> 5  AND ( STR_TO_DATE(expense_cheque_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$expense_cheque_payments = 'SELECT IFNULL(sum(amount),0)AS expense_cheque_total FROM expense_cheque_payments WHERE ( ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $expense_cheque_payments = DB::select($expense_cheque_payments);
            if (count($expense_cheque_payments) > 0) {

                $expenseChequePayments = new AccGeneralLedger();
                $expenseChequePayments->source_code = GeneralLedgerSourceValues::EXPENSE_CHEQUE_PAYMENT;
                $expenseChequePayments->amount = $expense_cheque_payments[0]->expense_cheque_total;
                $expenseChequePayments->ledger_type = LedgerType::BANK;
                $expenseChequePayments->entry_type = EntryType::CREDIT;
                $expenseChequePayments->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($expenseChequePayments);

            }

            $expense_card_payments = 'SELECT IFNULL(sum(expense_card_payments.amount),0)AS expense_card_total, stock_location_code, stock_locations.name FROM expenses 
            JOIN expense_card_payments on expense_card_payments.expense_code = expenses.code
            JOIN stock_locations on stock_locations.code = expenses.stock_location_code
            WHERE (expenses.stock_location_code =' . $stockLocationCode . ' AND expense_card_payments.status <> 5  AND ( STR_TO_DATE(expense_card_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$expense_card_payments = 'SELECT IFNULL(sum(amount),0)AS expense_card_total FROM expense_card_payments WHERE ( ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $expense_card_payments = DB::select($expense_card_payments);
            if (count($expense_card_payments) > 0) {

                $expenseCardPayments = new AccGeneralLedger();
                $expenseCardPayments->source_code = GeneralLedgerSourceValues::EXPENSE_CARD_PAYMENT;
                $expenseCardPayments->amount = $expense_card_payments[0]->expense_card_total;
                $expenseCardPayments->ledger_type = LedgerType::CREDIT_CARD;
                $expenseCardPayments->entry_type = EntryType::CREDIT;
                $expenseCardPayments->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($expenseCardPayments);

            }

            $expense_bank_payments = 'SELECT IFNULL(sum(expense_bank_payments.amount),0)AS expense_bank_total, stock_location_code, stock_locations.name FROM expenses 
            JOIN expense_bank_payments on expense_bank_payments.expense_code = expenses.code
            JOIN stock_locations on stock_locations.code = expenses.stock_location_code
            WHERE (expenses.stock_location_code =' . $stockLocationCode . ' AND expense_bank_payments.status <> 5  AND ( STR_TO_DATE(expense_bank_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$expense_bank_payments = 'SELECT IFNULL(sum(amount),0)AS expense_bank_total FROM expense_bank_payments WHERE ( ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $expense_bank_payments = DB::select($expense_bank_payments);
            if (count($expense_bank_payments) > 0) {

                $expenseBankPayments = new AccGeneralLedger();
                $expenseBankPayments->source_code = GeneralLedgerSourceValues::EXPENSE_BANK_PAYMENT;
                $expenseBankPayments->amount = $expense_bank_payments[0]->expense_bank_total;
                $expenseBankPayments->ledger_type = LedgerType::CASH;
                $expenseBankPayments->entry_type = EntryType::CREDIT;
                $expenseBankPayments->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($expenseBankPayments);

            }

            $expense_online_payments = 'SELECT IFNULL(sum(expense_online_payments.amount),0)AS expense_online_total, stock_location_code, stock_locations.name FROM expenses 
            JOIN expense_online_payments on expense_online_payments.expense_code = expenses.code
            JOIN stock_locations on stock_locations.code = expenses.stock_location_code
            WHERE (expenses.stock_location_code =' . $stockLocationCode . ' AND expense_online_payments.status <> 5  AND ( STR_TO_DATE(expense_online_payments.date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            //$expense_online_payments = 'SELECT IFNULL(sum(amount),0)AS expense_online_total FROM expense_online_payments WHERE ( ( STR_TO_DATE(date_time, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $expense_online_payments = DB::select($expense_online_payments);
            if (count($expense_online_payments) > 0) {

                $expenseOnlinePayments = new AccGeneralLedger();
                $expenseOnlinePayments->source_code = GeneralLedgerSourceValues::EXPENSE_ONLINE_PAYMENT;
                $expenseOnlinePayments->amount = $expense_online_payments[0]->expense_online_total;
                $expenseOnlinePayments->ledger_type = LedgerType::BANK;
                $expenseOnlinePayments->entry_type = EntryType::CREDIT;
                $expenseOnlinePayments->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($expenseOnlinePayments);

            }

            //Customer Cheque Return Payment
//Company Cheque Return

            $account_transaction = AccTransaction::select(
                'acc_transactions.code as source_code',
                'acc_transactions.date_time',
                'acc_journal_types.code',
                'amount',
                'acc_journal_types.name AS acc_journal',
                'acc_journal_types.acc_ledger_type_from_code',
                'acc_journal_types.entry_type_from',
                'acc_journal_types.transaction_mode_from',
                'acc_journal_types.acc_ledger_type_to_code',
                'acc_journal_types.entry_type_to',
                'acc_journal_types.transaction_mode_to'

            )
                ->join('stock_locations', 'stock_locations.code', '=', 'acc_transactions.stock_location_code')
                ->join('acc_journal_types', 'acc_journal_types.code', '=', 'acc_transactions.acc_journal_type_code')
                ->where('acc_journal_types.is_active', '=', 1)
                ->where('acc_transactions.stock_location_code', '=', $stockLocationCode)
                //->where('acc_transactions.created_by', '=', $createdBy)
                ->whereBetween('acc_transactions.date_time', [date('Y-m-d H:m:s', strtotime($fromdate) - 1), date('Y-m-d H:m:s', strtotime($toDate))])
                ->get();
            if (count($account_transaction) > 0) {
                foreach ($account_transaction as $accountTransaction) {
                    $accLedgerCashPayment = new AccGeneralLedger();
                    $accLedgerCashPayment->source_code = $accountTransaction->source_code;
                    $accLedgerCashPayment->amount = $accountTransaction->amount;
                    $accLedgerCashPayment->ledger_type = $accountTransaction->acc_ledger_type_from_code;
                    $accLedgerCashPayment->entry_type = $accountTransaction->entry_type_from;
                    $accLedgerCashPayment->transaction_type = $accountTransaction->transaction_mode_from;
                    $accLedgerCashPayment->transaction_type_name = $accountTransaction->acc_journal;

                    $accLedgerCollection->push($accLedgerCashPayment);

                    $cashInHand = $cashInHand + $accLedgerCashPayment->amount;

                    if ($accountTransaction->acc_ledger_type_to_code !== null) {

                        $accLedgerCashPaymentTo = new AccGeneralLedger();
                        $accLedgerCashPaymentTo->source_code = $accountTransaction->source_code;
                        $accLedgerCashPaymentTo->amount = $accountTransaction->amount;
                        $accLedgerCashPaymentTo->ledger_type = $accountTransaction->acc_ledger_type_to_code;
                        $accLedgerCashPaymentTo->entry_type = $accountTransaction->entry_type_to;
                        $accLedgerCashPaymentTo->transaction_type = $accountTransaction->transaction_mode_to;
                        $accLedgerCashPaymentTo->transaction_type_name = $accountTransaction->acc_journal;

                        $accLedgerCollection->push($accLedgerCashPaymentTo);

                        $cashInHand = $cashInHand + $accLedgerCashPaymentTo->amount;
                    }
                }
            }

            if ($task == "generate") {

                //Get all the ledger types
                $accLedgerTypes = AccLedgerType::select(
                    'code'
                )->where('is_active', '=', 1)
                    ->get();



                foreach ($accLedgerTypes as $accLedgerType) {

                    $max_code_closing_balance = AccClosingBalance::select('code')
                        ->where('stock_location_code', '=', $stockLocationCode)
                       // ->where('created_by', '=', $createdBy)
                        ->max('code');

                    $max_id_closing_balance = $max_code_closing_balance == null ? config('global.code_value') + 1 : substr($max_code_closing_balance, 5) + 1;

                    $ledgerType = strval($accLedgerType->code);
                    // return  $ledgerType   ;
                    //Cash Calculation
                    $selectedLedgersDebitCashInHand = $accLedgerCollection
                        ->where('ledger_type', $ledgerType)
                        ->where('entry_type', 0)
                        ->where('transaction_type', 0);



                    $totalDebitCashInHand = $selectedLedgersDebitCashInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });


                    $selectedLedgersCreditCashInHand = $accLedgerCollection
                        ->where('ledger_type', $ledgerType)
                        ->where('entry_type', 1)
                        ->where('transaction_type', 0);


                    $totalCreditCashInHand = $selectedLedgersCreditCashInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });

                    //End of Cash


                    //Cheeue Calculation
                    $selectedLedgersDebitChequeInHand = $accLedgerCollection
                        ->where('ledger_type', '=', $ledgerType)
                        ->where('entry_type', 0)
                        ->where('transaction_type', 1);



                    $totalDebitChequeInHand = $selectedLedgersDebitChequeInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });


                    $selectedLedgersCreditChequeInHand = $accLedgerCollection
                        ->where('ledger_type', $ledgerType)
                        ->where('entry_type', 1)
                        ->where('transaction_type', 1);


                    $totalCreditChequeInHand = $selectedLedgersCreditChequeInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });

                    //End of Cheeue


                    $closingBalance = AccClosingBalance::create([
                        'code' => $closingBalanceCode . $locationPrefix . $max_id_closing_balance,
                        'acc_ledger_type_code' => $accLedgerType->code,
                        'ledger_date' => $date,
                        'stock_location_code' => $stockLocationCode,
                        'cash_amount' => $totalDebitCashInHand - $totalCreditCashInHand,
                        'cheque_amount' => $totalDebitChequeInHand - $totalCreditChequeInHand,
                        'is_active' => 1,
                        'status' => MultiPurposeStatus::ACTIVE,
                        'created_by' => getUserCode(),
                        'created_at' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);

                    $selectedGLForCurrent = $accLedgerCollection
                        ->where('ledger_type', $ledgerType);


                    foreach ($selectedGLForCurrent as $accLedger) {
                        $max_code = AccGeneralLedger::select('code')
                            ->max('code');
                        $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;

                        $generalLedger = AccGeneralLedger::create([
                            'code' => $generalLedgerCode . $locationPrefix . $max_id,
                            'source_code' => $accLedger->source_code,
                            'acc_closing_balance_code' => $closingBalance->code,
                            'amount' => $accLedger->amount,
                            'entry_type' => $accLedger->entry_type,
                            'transaction_type' => $accLedger->transaction_type,
                            'status' => MultiPurposeStatus::ACTIVE,
                            'created_by' => getUserCode(),
                            'created_at' => getDateTimeNow(),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }

                }

                DB::commit();
                // return   $closingBalance ;


                return response()->json([
                    'status' => 200,
                    'generalLedger' => $accLedgerCollection
                ]);


            } else {
                return response()->json([
                    'status' => 200,
                    'generalLedger' => $accLedgerCollection,
                    'cashInHand' => $cashInHand,
                    'chequeInHand' => $chequeInHand
                ]);
            }


        }
        // } catch (\Exception $e) {
        //     throw new Exception($e);
        // }
    }

    public function closingBalanceReversal(Request $request)
    {
        try { 

            $date = $request->date;
            $createdBy = getUserCode();

            $closingBalance = AccClosingBalance::where('ledger_date', '=', $date)
            ->where('is_active', '=', 1)
            //->where('created_by', '=', $createdBy)
            ->get();

            if($closingBalance)
            {
                if (count($closingBalance) > 0) {
                    foreach ($closingBalance as $closing_balance) {
    
                        $closing_balance->update([
                            'status' => MultiPurposeStatus::REVERSED,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                    
                        AccGeneralLedger::where('acc_closing_balance_code', $closing_balance->code)
                        ->update([
                            'status' => MultiPurposeStatus::REVERSED,
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow()
                        ]);
                    }
                
                }
                return response()->json([
                    'status' => 200,
                    'message' => $closingBalance
                ]);
            }

            else
            {
                return response()->json([
                    'status' => 200,
                    'message' => 'Cannot be reversed - ' . $date . ' this date'
                ]);
            }
          

        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

    public function previewClosingBalanceByLoggedInUser(Request $request)
    {


        // $accLedger = new AccGeneralLedger();
        // $accLedger->code = "asas";
        // $accLedgerCollection = new Collection();
        // $accLedgerCollection->push($accLedger);

        // return $accLedgerCollection;


        // try {

        $accLedgerCollection = new Collection();
        $date = $request->date;
        $fromdate = $request->fromDate;
        $toDate = $request->toDate;

        $task = $request->task;

        $loggedInUser = getUserCode();

        $stockLocationCode = getCurrentLocationCode($request);
        $closingBalanceCode = TransactionCode::CLOSING_BALANCE_CODE;
        $generalLedgerCode = TransactionCode::GENERAL_LEDGER_CODE;

        $locationPrefix = substr($stockLocationCode, -2);
        $cashInHand = 0;
        $chequeInHand = 0;



        $generalLedger = AccClosingBalance::select(
            'code',
            'stock_location_code',
            'acc_ledger_type_code',
            'cash_amount',
            'cheque_amount',
            'ledger_date',
            'created_by'
        )
            ->where('is_active', '=', 1)
            ->where('ledger_date', '=', $date)
            ->where('created_by', '=', $loggedInUser)
            ->where('stock_location_code', '=', $stockLocationCode)
            ->get();

        if (count($generalLedger)) {

            return response()->json([
                'status' => 200,
                'note' => `Closing Balance already available for the date {$date}`,
                'generalLedger' => $generalLedger
            ]);
        } else {


            DB::beginTransaction();
            $closingBalanceCode = TransactionCode::CLOSING_BALANCE_CODE;
            $locationPrefix = substr($stockLocationCode, -2);

            // Cash Payment




            $cash_payment = 'SELECT IFNULL(sum(cash_payments.amount),0) AS cash_total, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN cash_payments on cash_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cash_payments.status <> 5 AND created_by =' . $loggedInUser . '  AND ( STR_TO_DATE(cash_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';


            $cash_payment = DB::select($cash_payment);


            $accLedgerCashPayment = new AccGeneralLedger();
            $accLedgerCashPayment->source_code = GeneralLedgerSourceValues::CASH_PAYMENT;
            $accLedgerCashPayment->amount = $cash_payment[0]->cash_total;
            $accLedgerCashPayment->ledger_type = LedgerType::CASH;
            $accLedgerCashPayment->entry_type = EntryType::DEBIT;
            $accLedgerCashPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerCashPayment);


            $cheque_payment = 'SELECT IFNULL(sum(cheque_payments.amount),0)AS cheque_total, stock_location_code, stock_locations.name FROM payment_receipts 
        JOIN cheque_payments on cheque_payments.receipt_code = payment_receipts.code
        JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
        WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND cheque_payments.status <> 5 AND created_by =' . $loggedInUser . '  AND ( STR_TO_DATE(cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $cheque_payment = DB::select($cheque_payment);

            $accLedgerCashPayment = new AccGeneralLedger();
            $accLedgerCashPayment->source_code = GeneralLedgerSourceValues::CHEQUE_PAYMENT;
            $accLedgerCashPayment->amount = $cheque_payment[0]->cheque_total;
            $accLedgerCashPayment->ledger_type = LedgerType::CASH;
            $accLedgerCashPayment->entry_type = EntryType::DEBIT;
            $accLedgerCashPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerCashPayment);



            $card_payment = 'SELECT IFNULL(sum(card_payments.amount),0)AS card_total, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN card_payments on card_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND card_payments.status <> 5 AND created_by =' . $loggedInUser . '   AND ( STR_TO_DATE(card_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $card_payment = DB::select($card_payment);

            $accLedgerCardPayment = new AccGeneralLedger();
            $accLedgerCardPayment->source_code = GeneralLedgerSourceValues::CARD_PAYMENT;
            $accLedgerCardPayment->amount = $card_payment[0]->card_total;
            $accLedgerCardPayment->ledger_type = LedgerType::CREDIT_CARD;
            $accLedgerCardPayment->entry_type = EntryType::DEBIT;
            $accLedgerCardPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerCardPayment);

            $bank_payment = 'SELECT IFNULL(sum(bank_payments.amount),0)AS bank_amount, stock_location_code, stock_locations.name FROM payment_receipts 
            JOIN bank_payments on bank_payments.receipt_code = payment_receipts.code
            JOIN stock_locations on stock_locations.code = payment_receipts.stock_location_code
            WHERE  (payment_receipts.stock_location_code =' . $stockLocationCode . ' AND bank_payments.status <> 5  AND created_by =' . $loggedInUser . ' AND ( STR_TO_DATE(bank_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $bank_payment = DB::select($bank_payment);

            $accLedgerBankPayment = new AccGeneralLedger();
            $accLedgerBankPayment->source_code = GeneralLedgerSourceValues::BANK_PAYMENT;
            $accLedgerBankPayment->amount = $bank_payment[0]->bank_amount;
            $accLedgerBankPayment->ledger_type = LedgerType::BANK;
            $accLedgerBankPayment->entry_type = EntryType::DEBIT;
            $accLedgerBankPayment->transaction_type = TransactionMode::CASH;

            $accLedgerCollection->push($accLedgerBankPayment);

            $expense_amount = Expense::select(
                'expenses.code',
                'total_amount',
                'expense_types.name AS expense_type',
                'expense_categories.name AS expense_category'
            )
                ->join('expense_types', 'expense_types.code', '=', 'expenses.expense_type_code')
                ->join('expense_categories', 'expense_categories.code', '=', 'expenses.expense_category_code')
                ->join('stock_locations', 'stock_locations.code', '=', 'expenses.stock_location_code')
                ->where('expenses.created_by', '=', $loggedInUser)
                ->where('expenses.is_active', '=', 1)
                ->where('expenses.stock_location_code', '=', $stockLocationCode)
                ->whereBetween('payment_date', [date('Y-m-d H:m:s', strtotime($fromdate) - 1), date('Y-m-d H:m:s', strtotime($toDate))])
                ->get();

            if (count($expense_amount) > 0) {
                foreach ($expense_amount as $expenseAmount) {

                    $accLedgerExpenseAmount = new AccGeneralLedger();
                    $accLedgerExpenseAmount->source_code = GeneralLedgerSourceValues::EXPENSE_AMOUNT;
                    $accLedgerExpenseAmount->amount = $expenseAmount->total_amount;
                    $accLedgerExpenseAmount->ledger_type = LedgerType::CASH;
                    $accLedgerExpenseAmount->entry_type = EntryType::CREDIT;
                    $accLedgerExpenseAmount->transaction_type = TransactionMode::CASH;

                    $accLedgerCollection->push($accLedgerExpenseAmount);

                }
            }

            // $payment_vouchers = 'SELECT IFNULL(sum(settled_amount),0)AS payment_voucher_settled FROM payment_vouchers WHERE (payment_vouchers.status <> 5 AND stock_location_code = ' . $stockLocationCode . ' AND( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            // $payment_voucher_total = DB::select($payment_vouchers);

            // $accLedgerVoucherTotal = new AccGeneralLedger();

            // $accLedgerVoucherTotal->source_code = GeneralLedgerSourceValues::PAYMENT_VOUCHER;
            // $accLedgerVoucherTotal->amount = $payment_voucher_total[0]->payment_voucher_settled;
            // $accLedgerVoucherTotal->ledger_type = LedgerType::CREDIT_CARD;
            // $accLedgerVoucherTotal->entry_type = EntryType::DEBIT;
            // $accLedgerVoucherTotal->transaction_type = TransactionMode::CASH;

            // $accLedgerCollection->push($accLedgerVoucherTotal);

            $supplier_cash_payment = 'SELECT IFNULL(sum(supplier_cash_payments.amount),0)AS supplier_cash_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_cash_payments on supplier_cash_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . '  AND created_by =' . $loggedInUser . ' AND supplier_cash_payments.status <> 5  AND ( STR_TO_DATE(supplier_cash_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_cash_payment = DB::select($supplier_cash_payment);
            if (count($supplier_cash_payment) > 0) {
                $accLedgerSupplierCashPayment = new AccGeneralLedger();
                $accLedgerSupplierCashPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CASH_PAYMENT;
                $accLedgerSupplierCashPayment->amount = $supplier_cash_payment[0]->supplier_cash_total;
                $accLedgerSupplierCashPayment->ledger_type = LedgerType::CASH;
                $accLedgerSupplierCashPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierCashPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierCashPayment);
            }


            $supplier_cheque_payment = 'SELECT IFNULL(sum(supplier_cheque_payments.amount),0)AS supplier_cheque_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_cheque_payments on supplier_cheque_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . '  AND created_by =' . $loggedInUser . ' AND supplier_cheque_payments.status <> 5  AND ( STR_TO_DATE(supplier_cheque_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_cheque_payment = DB::select($supplier_cheque_payment);

            if (count($supplier_cheque_payment) > 0) {
                $accLedgerSupplierChequePayment = new AccGeneralLedger();
                $accLedgerSupplierChequePayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CHEQUE_PAYMENT;
                $accLedgerSupplierChequePayment->amount = $supplier_cheque_payment[0]->supplier_cheque_total;
                $accLedgerSupplierChequePayment->ledger_type = LedgerType::CASH;
                $accLedgerSupplierChequePayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierChequePayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierChequePayment);
            }

            $supplier_card_payment = 'SELECT IFNULL(sum(supplier_card_payments.amount),0)AS supplier_card_total, stock_location_code, stock_locations.name FROM payment_vouchers 
            JOIN supplier_card_payments on supplier_card_payments.voucher_code = payment_vouchers.code
            JOIN stock_locations on stock_locations.code = payment_vouchers.stock_location_code
            WHERE (payment_vouchers.stock_location_code =' . $stockLocationCode . '  AND created_by =' . $loggedInUser . ' AND supplier_card_payments.status <> 5  AND ( STR_TO_DATE(supplier_card_payments.created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '"))';

            $supplier_card_payment = DB::select($supplier_card_payment);
            if (count($supplier_card_payment) > 0) {

                $accLedgerSupplierCardPayment = new AccGeneralLedger();
                $accLedgerSupplierCardPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_CARD_PAYMENT;
                $accLedgerSupplierCardPayment->amount = $supplier_card_payment[0]->supplier_card_total;
                $accLedgerSupplierCardPayment->ledger_type = LedgerType::CREDIT_CARD;
                $accLedgerSupplierCardPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierCardPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierCardPayment);
            }

            $supplier_bank_payment = 'SELECT IFNULL(sum(amount),0)AS supplier_bank_total FROM supplier_bank_payments WHERE (supplier_bank_payments.status <> 5  AND created_by =' . $loggedInUser . ' AND ( STR_TO_DATE(created_at, "%Y-%m-%d")  BETWEEN "' . $fromdate . '" AND "' . $toDate . '" ))';
            $supplier_bank_payment = DB::select($supplier_bank_payment);
            if (count($supplier_bank_payment) > 0) {

                $accLedgerSupplierBankPayment = new AccGeneralLedger();
                $accLedgerSupplierBankPayment->source_code = GeneralLedgerSourceValues::SUPPLIER_BANK_PAYMENT;
                $accLedgerSupplierBankPayment->amount = $supplier_bank_payment[0]->supplier_bank_total;
                $accLedgerSupplierBankPayment->ledger_type = LedgerType::BANK;
                $accLedgerSupplierBankPayment->entry_type = EntryType::CREDIT;
                $accLedgerSupplierBankPayment->transaction_type = TransactionMode::CASH;

                $accLedgerCollection->push($accLedgerSupplierBankPayment);

            }



            $account_transaction = AccTransaction::select(
                'acc_transactions.code as source_code',
                'acc_journal_types.code',
                'amount',
                'acc_journal_types.name AS acc_journal',
                'acc_journal_types.acc_ledger_type_from_code',
                'acc_journal_types.entry_type_from',
                'acc_journal_types.transaction_mode_from',
                'acc_journal_types.acc_ledger_type_to_code',
                'acc_journal_types.entry_type_to',
                'acc_journal_types.transaction_mode_to'
            )
                ->join('stock_locations', 'stock_locations.code', '=', 'acc_transactions.stock_location_code')
                ->join('acc_journal_types', 'acc_journal_types.code', '=', 'acc_transactions.acc_journal_type_code')
                ->where('acc_journal_types.is_active', '=', 1)
                ->where('acc_transactions.created_by', '=', $loggedInUser)
                //  ->whereBetween('acc_transactions.created_at', [date('Y-m-d H:m:s', strtotime($date1) - 1), date('Y-m-d H:m:s', strtotime($date1) + 1)])
                ->get();
            if (count($account_transaction) > 0) {
                foreach ($account_transaction as $accountTransaction) {
                    $accLedgerCashPayment = new AccGeneralLedger();
                    $accLedgerCashPayment->source_code = $accountTransaction->source_code;
                    $accLedgerCashPayment->amount = $accountTransaction->amount;
                    $accLedgerCashPayment->ledger_type = $accountTransaction->acc_ledger_type_from_code;
                    $accLedgerCashPayment->entry_type = $accountTransaction->entry_type_from;
                    $accLedgerCashPayment->transaction_type = $accountTransaction->transaction_mode_from;
                    $accLedgerCashPayment->transaction_type_name = $accountTransaction->acc_journal;

                    $accLedgerCollection->push($accLedgerCashPayment);

                    $cashInHand = $cashInHand + $accLedgerCashPayment->amount;

                    if ($accountTransaction->acc_ledger_type_to_code !== null) {

                        $accLedgerCashPaymentTo = new AccGeneralLedger();
                        $accLedgerCashPaymentTo->source_code = $accountTransaction->source_code;
                        $accLedgerCashPaymentTo->amount = $accountTransaction->amount;
                        $accLedgerCashPaymentTo->ledger_type = $accountTransaction->acc_ledger_type_to_code;
                        $accLedgerCashPaymentTo->entry_type = $accountTransaction->entry_type_to;
                        $accLedgerCashPaymentTo->transaction_type = $accountTransaction->transaction_mode_to;
                        $accLedgerCashPaymentTo->transaction_type_name = $accountTransaction->acc_journal;

                        $accLedgerCollection->push($accLedgerCashPaymentTo);

                        $cashInHand = $cashInHand + $accLedgerCashPaymentTo->amount;


                    }
                }
            }


            if ($task == "generate") {




                //Get all the ledger types
                $accLedgerTypes = AccLedgerType::select(
                    'code'
                )->where('is_active', '=', 1)
                    ->get();

                foreach ($accLedgerTypes as $accLedgerType) {

                    $max_code_closing_balance = AccClosingBalance::select('code')
                        ->where('stock_location_code', '=', $stockLocationCode)
                        ->max('code');

                    $max_id_closing_balance = $max_code_closing_balance == null ? config('global.code_value') + 1 : substr($max_code_closing_balance, 5) + 1;

                    $ledgerType = strval($accLedgerType->code);
                    // return  $ledgerType   ;
                    //Cash Calculation
                    $selectedLedgersDebitCashInHand = $accLedgerCollection
                        ->where('ledger_type', )
                        ->where('entry_type', 0)
                        ->where('transaction_type', 0);


                    $totalDebitCashInHand = $selectedLedgersDebitCashInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });


                    $selectedLedgersCreditCashInHand = $accLedgerCollection
                        ->where('ledger_type', $accLedgerType->code)
                        ->where('entry_type', 1)
                        ->where('transaction_type', 0);


                    $totalCreditCashInHand = $selectedLedgersCreditCashInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });

                    //End of Cash


                    //Cheeue Calculation
                    $selectedLedgersDebitChequeInHand = $accLedgerCollection
                        ->where('ledger_type', '=', $ledgerType)
                        ->where('entry_type', 0)
                        ->where('transaction_type', 1);



                    $totalDebitChequeInHand = $selectedLedgersDebitChequeInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });


                    $selectedLedgersCreditChequeInHand = $accLedgerCollection
                        ->where('ledger_type', $accLedgerType->code)
                        ->where('entry_type', 1)
                        ->where('transaction_type', 1);


                    $totalCreditChequeInHand = $selectedLedgersCreditChequeInHand->sum(function ($ledger) {
                        return $ledger->amount;
                    });

                    //End of Cheeue

                    $closingBalance = AccClosingBalance::create([
                        'code' => $closingBalanceCode . $locationPrefix . $max_id_closing_balance,
                        'acc_ledger_type_code' => $accLedgerType->code,
                        'ledger_date' => $date,
                        'stock_location_code' => $stockLocationCode,
                        'cash_amount' => $totalCreditCashInHand - $totalDebitCashInHand,
                        'cheque_amount' => $totalCreditChequeInHand - $totalDebitChequeInHand,
                        'is_active' => 1,
                        'created_by' => getUserCode(),
                        'created_at' => getDateTimeNow(),
                        'updated_by' => getUserCode(),
                        'updated_at' => getDateTimeNow(),
                    ]);


                    foreach ($accLedgerCollection as $accLedger) {
                        $max_code = AccGeneralLedger::select('code')
                            ->max('code');
                        $max_id = $max_code == null ? config('global.code_value') + 1 : substr($max_code, 5) + 1;

                        $generalLedger = AccGeneralLedger::create([
                            'code' => $generalLedgerCode . $locationPrefix . $max_id,
                            'source_code' => $accLedger->source_code,
                            'acc_closing_balance_code' => $closingBalance->code,
                            'amount' => $accLedger->amount,
                            'entry_type' => $accLedger->entry_type,
                            'transaction_type' => $accLedger->transaction_type,
                            'created_by' => getUserCode(),
                            'created_at' => getDateTimeNow(),
                            'updated_by' => getUserCode(),
                            'updated_at' => getDateTimeNow(),
                        ]);
                    }


                }
                DB::commit();
                // return   $closingBalance ;


                return response()->json([
                    'status' => 200,
                    'generalLedger' => $accLedgerCollection
                ]);


            } 
            
            else {
                return response()->json([
                    'status' => 200,
                    'generalLedger' => $accLedgerCollection,
                    'cashInHand' => $cashInHand,
                    'chequeInHand' => $chequeInHand
                ]);
            }


        }
    }

    public function getClosingBalanceByDate(Request $request)
    {
        //try {

            $date = $request->date;

            $date1 = new DateTime($request->date);
            $newDate = $date1->modify('+1 day');
            $createdBy = getUserCode();
            
            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount'
            )
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $date)
                ->where('status', '<>', 5)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                //->where('created_by', '=', $createdBy)
                ->get();

            $closingBalanceReversable = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount'
            )
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $newDate->format('Y-m-d'))
                ->where('status', '<>', 5)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                //->where('created_by', '=', $createdBy)
                ->get();
            
                return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance,
                'closingBalanceGenerate' => count($closingBalance) > 0 ? true : false,
                'closingBalanceReversable' => count($closingBalanceReversable) > 0 ? false : true,
                'isReversable' => (('closingBalanceReversable'))? 1:0,
            ]);
        // } catch (\Exception $e) {
        //     throw new Exception($e);
        // }
    }


    public function recentClosingBalance(Request $request)
    {

        try {
            $key = $request->key;
            $createdBy = getUserCode();

            $recentClosingBalance = AccClosingBalance::select(
                'code',
                'ledger_date',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount'
            )
                ->Where('code', 'like', "%$key%")
                ->where('status', '<>', 5)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                //->where('created_by', '=', $createdBy)
                ->limit(1)->orderBy('ledger_date', 'DESC')->get();

            return response()->json(['status' => 200, 'recentClosingBalance' => $recentClosingBalance]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function getOpeningBalanceByDate(Request $request)
    {
        try {
            $date = $request->date;
            $closingBalance = AccClosingBalance::where(
                'ledger_date',
                $date
            )
                ->first()
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $date)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();

            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }


    public function getClosingBalanceByDateAndUser(Request $request)
    {
        try {
            $date = $request->date;
            $userid = $request->date;
            $closingBalance = AccClosingBalance::select(
                'code',
                'stock_location_code',
                'acc_ledger_type_code',
                'cash_amount',
                'cheque_amount'
            )
                ->with([
                    'generalLedgers' => function ($query) {
                        $query->select(
                            'code',
                        )->where('is_active', '=', 1)
                            ->where('entry_type', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'generalLedgers.accTransaction.journalType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->with([
                    'ledgerType' => function ($query) {
                        $query->where('is_active', '=', 1);
                    }
                ])
                ->where('is_active', '=', 1)
                ->where('ledger_date', '=', $date)
                ->where('created_by', '=', $userid)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->get();

            return response()->json([
                'status' => 200,
                'closingBalance' => $closingBalance
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }
}