<?php

namespace App\Http\Controllers\Account_Transaction_Controller;

use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccTransaction;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccountTransactionController extends Controller
{
    public function index(Request $request)
    {
        try {
            $accTransaction = AccTransaction::select(
                'code',
                'amount',
                'description',
                'acc_journal_type_code',
                'is_debit',
                'date_time',
                'created_at',
                'updated_at',
                'created_by'
            )
            ->with([
                'journalType' => function ($query) {
                     $query->where('is_active', '=', 1);
                }
            ])

                ->where('is_active', '=', 1)
                ->where('stock_location_code', '=', getCurrentLocationCode($request))
                ->orderBy('created_at', 'DESC')
                ->get();

            return response()->json(
                [
                    'status' => 200,
                    'accTransaction' =>
                    $accTransaction
                ]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $accTransaction = AccTransaction::select(
                'code',
                'amount',
                'description',
                'acc_journal_type_code',
                'date_time',
                'is_debit',
                'created_by'
            )->with([
                'journalType' => function ($query) {
                     $query->where('is_active', '=', 1);
                }
            ])
                ->where('is_active', '=', 1)
                ->where('code', '=', $id)
                ->first();
            return response()->json(
                [
                    'status' => 200,
                    'accTransaction' => $accTransaction
                ]
            );
        } catch (\Exception $e) {

            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * store
     * auhtor: fathima sajana
     * logic: account transacction store location based
     * date: 2023.04.03
     * version:01
     * @param  mixed $request
     * @return void
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $accTransaction = TransactionCode::ACCOUNT_TRANSACTION;
            $stockLocationCode = getCurrentLocationCode($request);
            $locationPrefix = substr("$stockLocationCode", -2);
            $max_code = AccTransaction::select('code')
                ->where('stock_location_code', '=', $stockLocationCode)
                ->max('code');

            $max_id = $max_code == null || $max_code == '' ? config('global.code_value') + 1 : substr("$max_code", 5) + 1;
            $type = $request->type;
            $accTransaction = AccTransaction::create([
                'code' => $accTransaction . $locationPrefix . $max_id,
                'acc_journal_type_code' => $request->journalType['code'],
                'stock_location_code' => getCurrentLocationCode($request),
                'amount' => $request->amount,
                'description' => $request->description,
                'date_time' => $request->dateTime,
                'is_debit' => $type == 'is_debit' ? 0 : 1,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow()

            ]);


            DB::commit();
            return response(['status' => 200, 'Message' => 'Account Transaction Created']);

        } catch (\Exception $e) {
            DB::rollback();
            throw new Exception($e);
        }
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();
            $accTransaction = AccTransaction::where('code', $id)->first();
            $type = $request->type;
            $accTransaction->update([
                'acc_journal_type_code' => $request->journalType['code'],
                'amount' => $request->amount,
                'description' => $request->description,
                'date_time' => $request->dateTime,
                'is_debit' => $type == 'is_debit' ? 0 : 1,
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow(),

            ]);

            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Account Transaction Updated",

            ], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            throw new Exception($e);
        }
    }
}