<?php

namespace App\Http\Controllers\Account_Transaction_Controller;

use App\Enums\TransactionCode;
use App\Http\Controllers\Controller;
use App\Models\AccountTransaction_Models\AccJournalType;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AccJournalTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
            $journalType = AccJournalType::select(
                'code',
                'name',
                'acc_ledger_type_from_code',
                'entry_type_from',
                'transaction_mode_from',
                'acc_ledger_type_to_code',
                'entry_type_to',
                'transaction_mode_to',
               // 'date_time'
            )->where('is_active', '=', 1)
                ->get();
            return response()->json([
                'status' => 200,
                'journalTypes' => $journalType
            ]);
        } catch (\Exception $e) {
            return response()
                ->json([
                    'status' => 500,
                    'message' => $e
                ], 500);
        }
    }

    public function show($id)
    { {
            try {
                $journalType = AccJournalType::select(
                    'code',
                    'name',
                    'acc_ledger_type_from_code',
                    'entry_type_from',
                    'transaction_mode_from',
                    'acc_ledger_type_to_code',
                    'entry_type_to',
                    'transaction_mode_to',
                    //'date_time'
                )
                    ->with([
                        'accLedgerTypeFrom' => function ($query) {
                            $query->select('code', 'name')
                                ->where('is_active', '=', 1);
                        }
                    ])
                    ->with([
                        'accLedgerTypeTo' => function ($query) {
                            $query->select('code', 'name')
                                ->where('is_active', '=', 1);
                        }
                    ])

                    ->where('is_active', '=', 1)
                    ->where('code', '=', $id)
                    ->first();


                return response()->json([
                    'status' => 200,
                    'journalType' => $journalType
                ]);


            } catch (\Exception $e) {
                return response()
                    ->json([
                        'status' => 500,
                        'message' => $e
                    ], 500);
            }
        }
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {

            DB::beginTransaction();

            $journalTypeCode = TransactionCode::JOURNAL_TYPE_CODE;
            $entry_code = AccJournalType::max('code');
            $max_id = $entry_code == null ? config('global.code_value') + 1 : substr("$entry_code", 3) + 1;

            $journalType = AccJournalType::create([

                'code' => $journalTypeCode . $max_id,
                'name' => $request->name,
                'acc_ledger_type_from_code' => $request->ledgerType['code'],
                'entry_type_from' => $request->entryType['code'],
                'transaction_mode_from' => $request->transactionMode['code'],
                'acc_ledger_type_to_code' => $request->toLedgerType['code'] ?? null,
                'entry_type_to' => $request->toEntryType['code'] ?? null,
                'transaction_mode_to' => $request->toTransactionMode['code'] ?? null,
               // 'date_time' => $request->dateTime,
                'created_by' => getUserCode(),
                'created_at' => getDateTimeNow(),
                'updated_by' => getUserCode(),
                'updated_at' => getDateTimeNow()

            ]);
            DB::commit();
            return response()->json([
                'status' => 200,
                'message' => "Journal Type created"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => $e
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    { {
            try {
                DB::beginTransaction();
                $journalType = AccJournalType::where('code', $id)->first();
                $journalType->update([
                    'name' => $request->name,
                    'acc_ledger_type_from_code' => $request->ledgerType['code'],
                    'entry_type_from' => $request->entryType['code'],
                    'transaction_mode_from' => $request->transactionMode['code'],
                    'acc_ledger_type_to_code' => $request->toLedgerType['code'] ?? null,
                    'entry_type_to' => $request->toEntryType['code'] ?? null,
                    'transaction_mode_to' => $request->toTransactionMode['code'] ?? null,
                    'date_time' => $request->dateTime,
                    'updated_by' => getUserCode(),
                    'updated_at' => getDateTimeNow()

                ]);

                DB::commit();
                return response()->json([
                    'status' => 200,
                    'message' => "Journal Type Updated"
                ]);
            } catch (\Exception $e) {
                DB::rollBack();
                throw new Exception($e);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Summary of journalSearch
     * @param mixed $key
     * @throws \App\Http\Controllers\Account_Transaction_Controller\Exception
     * @return \Illuminate\Http\JsonResponse|mixed
     */
    public function journalTypeSearch($key)
    {
        try {

            $journalTypes = AccJournalType::select(
                'code',
                'name',
                'acc_ledger_type_from_code',
                'entry_type_from',
                'transaction_mode_from'
            )
                ->where([['is_active', '=', 1]])
                ->where(function ($query) use ($key) {
                    $query->Where('code', 'like', "%$key%")
                        ->orWhere('name', 'like', "%$key%");
                })->get();
            return response()->json([
                'status' => 200,
                'journalTypes' => $journalTypes
            ]);
        } catch (\Exception $e) {
            throw new Exception($e);
        }
    }

}